/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.buffers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.util.Files;

class DiskHandle
implements BufferHandle {
    private final File file;

    public DiskHandle(File file) {
        this.file = file;
    }

    @Override
    public void close() {
        this.file.delete();
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.file.exists()) {
            return Files.inputStream(this.file);
        }
        throw new IllegalStateException(this.file.getPath() + " has been disposed");
    }

    @Override
    public long size() {
        if (this.file.exists()) {
            return (int)this.file.length();
        }
        throw new IllegalStateException(this.file.getPath() + " has been disposed");
    }
}

