/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.buffers;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.buffers.DiskBuffer;
import oracle.dbtools.common.buffers.DiskOrMemoryBuffer;
import oracle.dbtools.common.buffers.MemoryBuffer;
import oracle.dbtools.common.buffers.PassThroughBuffer;
import oracle.dbtools.common.buffers.StreamBuffer;
import oracle.dbtools.common.util.Closeables;

public class Buffers {
    static final long BUFFER_SIZE = 4096L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferHandle buffer(InputStream stream) throws IOException {
        OutputStream out = null;
        StreamBuffer buf = Buffers.newBuffer();
        try {
            out = buf.open();
            Buffers.drain(stream, out);
            stream.close();
            out.close();
            out = null;
            BufferHandle bufferHandle = buf.acquire();
            return bufferHandle;
        }
        finally {
            Closeables.close(out);
        }
    }

    public static InputStream disposeOnCloseStream(final BufferHandle handle) throws IOException {
        return new FilterInputStream(handle.getStream()){

            @Override
            public void close() throws IOException {
                super.close();
                handle.close();
            }
        };
    }

    public static StreamBuffer newBuffer() {
        return new DiskOrMemoryBuffer();
    }

    public static StreamBuffer newBuffer(Storage storage) {
        if (Storage.DISK == storage) {
            return new DiskBuffer();
        }
        return new MemoryBuffer();
    }

    public static BufferHandle passThrough(InputStream stream) throws IOException {
        return new PassThroughBuffer(stream);
    }

    static File tempFile() throws IOException {
        return File.createTempFile("alfa-stage", "alfa");
    }

    private static long drain(InputStream is, OutputStream os) throws IOException {
        ReadableByteChannel source = Channels.newChannel(is);
        WritableByteChannel destination = Channels.newChannel(os);
        return Buffers.drain(source, destination);
    }

    private static long drain(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            length += (long)buffer.limit();
            destination.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destination.write(buffer);
        }
        return length;
    }

    public static enum Storage {
        DISK,
        RAM;

    }
}

