/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

import java.util.Locale;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.plugin.api.i18n.Translatable;

public class HTMLTranslatable
implements Translatable {
    private final Translatable content;
    private final CharSequence htmlPrefix;
    private final CharSequence htmlSuffix;
    private static final Iterable<Locale> NO_PREFERENCE = Iterables.empty();

    private HTMLTranslatable(CharSequence htmlPrefix, Translatable text, CharSequence htmlSuffix) {
        this.htmlPrefix = htmlPrefix;
        this.content = text;
        this.htmlSuffix = htmlSuffix;
    }

    public String toString() {
        return this.toString(NO_PREFERENCE);
    }

    public String toString(Iterable<Locale> localePreference) {
        StringBuilder b = new StringBuilder();
        b.append(this.htmlPrefix);
        if (null != this.content) {
            String localized = this.content.toString(localePreference);
            b.append(localized);
        }
        b.append(this.htmlSuffix);
        return b.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class EscapedHTML
    implements Translatable {
        private final Translatable text;

        private EscapedHTML(Translatable text) {
            this.text = text;
        }

        public String toString(Iterable<Locale> localePreference) {
            String escaped = Text.escapeHtml(this.text.toString(localePreference));
            return escaped;
        }
    }

    public static class Builder {
        private Translatable content;
        private CharSequence htmlPrefix;
        private CharSequence htmlSuffix;

        private Builder() {
        }

        public HTMLTranslatable build() {
            return new HTMLTranslatable(this.htmlPrefix, this.content, this.htmlSuffix);
        }

        public Builder html(HTMLTranslatable content) {
            this.content = content;
            return this;
        }

        public Builder prefix(CharSequence prefix) {
            this.htmlPrefix = prefix;
            return this;
        }

        public Builder suffix(CharSequence suffix) {
            this.htmlSuffix = suffix;
            return this;
        }

        public Builder text(Translatable content) {
            if (content instanceof HTMLTranslatable) {
                return this.html((HTMLTranslatable)content);
            }
            this.content = new EscapedHTML(content);
            return this;
        }

        public String toString() {
            return this.build().toString();
        }
    }
}

