/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.Connection;
import java.sql.SQLException;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ref.CachedStatementProfile;
import sqlj.runtime.profile.ref.ClientDataSupport;
import sqlj.runtime.profile.ref.LRUObjectPool;
import sqlj.runtime.profile.ref.ObjectPool;
import sqlj.runtime.profile.ref.ProfileImpl;
import sqlj.runtime.profile.ref.SharedProfile;
import sqlj.runtime.profile.ref.StatementCacheProfile;

public class StatementCacheCustomization
implements Customization {
    private int m_poolSize;
    private static final HashKey POOL_KEY = new HashKey("@PoolKey");
    private static ObjectPool DEFAULT_POOL = null;
    static final long serialVersionUID = -1702003903903900018L;

    public StatementCacheCustomization(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(n + "");
        }
        this.m_poolSize = n;
    }

    public int getPoolSize() {
        return this.m_poolSize;
    }

    public String toString() {
        return "StatementCacheCustomization (size = " + this.getPoolSize() + ")";
    }

    public boolean acceptsConnection(Connection connection) {
        return true;
    }

    public ConnectedProfile getProfile(ConnectionContext connectionContext, Profile profile) throws SQLException {
        if (this.getPoolSize() == 0) {
            return this.createCachedStatementProfile(null, connectionContext, profile);
        }
        return this.getProfile(this.getClientDataSupport(connectionContext.getConnection()), connectionContext, profile);
    }

    protected ClientDataSupport getClientDataSupport(Connection connection) {
        if (connection instanceof ClientDataSupport) {
            return (ClientDataSupport)((Object)connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectedProfile getProfile(ClientDataSupport clientDataSupport, ConnectionContext connectionContext, Profile profile) throws SQLException {
        SharedProfile sharedProfile;
        if (clientDataSupport == null) {
            return this.createStatementCache(clientDataSupport, connectionContext, profile);
        }
        HashKey hashKey = new HashKey(profile.getProfileName());
        ClientDataSupport clientDataSupport2 = clientDataSupport;
        synchronized (clientDataSupport2) {
            sharedProfile = (SharedProfile)clientDataSupport.getClientData(hashKey);
            if (sharedProfile == null) {
                ConnectedProfile connectedProfile = this.createStatementCache(clientDataSupport, connectionContext, profile);
                sharedProfile = new SharedProfile(connectedProfile);
                clientDataSupport.setClientData(hashKey, sharedProfile);
            }
        }
        return sharedProfile.newProfile();
    }

    protected ConnectedProfile createStatementCache(ClientDataSupport clientDataSupport, ConnectionContext connectionContext, Profile profile) throws SQLException {
        CachedStatementProfile cachedStatementProfile = this.createCachedStatementProfile(clientDataSupport, connectionContext, profile);
        return new StatementCacheProfile(cachedStatementProfile, this.getPool(clientDataSupport));
    }

    protected CachedStatementProfile createCachedStatementProfile(ClientDataSupport clientDataSupport, ConnectionContext connectionContext, Profile profile) throws SQLException {
        return ProfileImpl.getDefaultCachedProfile(connectionContext, profile.getProfileData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectPool getPool(ClientDataSupport clientDataSupport) {
        if (clientDataSupport == null) {
            HashKey hashKey = POOL_KEY;
            synchronized (hashKey) {
                if (DEFAULT_POOL == null) {
                    DEFAULT_POOL = this.createPool(clientDataSupport);
                }
            }
            return DEFAULT_POOL;
        }
        ObjectPool objectPool = (ObjectPool)clientDataSupport.getClientData(POOL_KEY);
        if (objectPool == null) {
            objectPool = this.createPool(clientDataSupport);
            clientDataSupport.setClientData(POOL_KEY, objectPool);
        }
        return objectPool;
    }

    protected ObjectPool createPool(ClientDataSupport clientDataSupport) {
        return new LRUObjectPool(this.m_poolSize);
    }

    private static class HashKey {
        private String m_keyValue;

        HashKey(String string) {
            this.m_keyValue = string;
        }

        public boolean equals(Object object) {
            return object instanceof HashKey && this.m_keyValue.equals(((HashKey)object).m_keyValue);
        }

        public int hashCode() {
            return this.m_keyValue.hashCode();
        }

        public String toString() {
            return this.m_keyValue;
        }
    }
}

