/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime.sqlmonitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.jdbc.OracleDriver;
import sqlj.util.io.OracleOutputStreamWriter;

public class SQLMonitor {
    private static String m_instrumentApp;
    private static String[] m_instrumentComps;
    private static boolean m_initialized;
    private static int m_eventId;
    private static boolean m_dmsMonitoring;
    private static boolean m_serverTracing;
    private static String[] m_monitorComps;
    private static String m_dumpFileName;
    private static Object m_dmsConsole;
    private static Object m_eventFactory;
    private static Object m_phaseEventFactory;
    private static Object m_stateFactory;
    private static String DEFAULT_SYS_URL;
    private static String m_sysUrl;
    private static String m_sysUser;
    private static String m_sysPassword;
    private static String m_serverTracingDir;

    public static void setInstrumentApp(String app) {
        if (app == null) {
            return;
        }
        m_instrumentApp = app.equalsIgnoreCase("true") || app.equals("1") ? "defaultApp" : (app.equalsIgnoreCase("false") || app.equals("0") ? null : app);
    }

    public static String getInstrumentApp() {
        return m_instrumentApp;
    }

    public static void setInstrumentComps(String strComponents) {
        if (m_instrumentComps == null && strComponents != null) {
            StringTokenizer st = new StringTokenizer(strComponents, ",");
            m_instrumentComps = new String[st.countTokens()];
            for (int i = 0; i < st.countTokens(); ++i) {
                SQLMonitor.m_instrumentComps[i] = (String)st.nextElement();
            }
        }
    }

    public static String[] getInstrumentComps() {
        return m_instrumentComps;
    }

    public static boolean isInstrumented() {
        return SQLMonitor.getInstrumentComps() != null && SQLMonitor.getInstrumentComps().length != 0;
    }

    public static boolean isInstrumented(String component) {
        String[] comps = SQLMonitor.getInstrumentComps();
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].equalsIgnoreCase("all") && !comps[i].equals(component)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getMonitorPropFile() {
        if (m_instrumentApp != null) {
            return m_instrumentApp.replace('.', File.separatorChar) + ".properties";
        }
        return null;
    }

    public static void dumpMonitorPropFile() {
        int i;
        if (!SQLMonitor.isInstrumented()) {
            return;
        }
        Object osw = null;
        try {
            osw = new OracleOutputStreamWriter((OutputStream)new FileOutputStream(SQLMonitor.getMonitorPropFile()));
        }
        catch (Exception exn) {
            try {
                try {
                    File tmpFile = new File(SQLMonitor.getMonitorPropFile());
                    if (!tmpFile.exists()) {
                        if (tmpFile.getParentFile() != null) {
                            tmpFile.getParentFile().mkdirs();
                        }
                        tmpFile.createNewFile();
                    }
                }
                catch (Exception _) {
                    // empty catch block
                }
                osw = new OutputStreamWriter(new FileOutputStream(SQLMonitor.getMonitorPropFile()));
            }
            catch (Exception e) {
                System.out.println("SQLMonitor: Monitor property file creation error: " + e.getMessage());
            }
        }
        if (osw == null) {
            return;
        }
        PrintWriter pw = new PrintWriter((Writer)osw, true);
        for (i = 0; i < m_instrumentComps.length; ++i) {
            if (i == 0) {
                pw.println("sqlmonitor.components=" + m_instrumentComps[i]);
                continue;
            }
            pw.println("," + m_instrumentComps[i]);
        }
        for (i = 0; i < m_instrumentComps.length; ++i) {
            if (i == 0) {
                pw.println("sqlmonitor.monitorcomp=" + m_instrumentComps[i]);
                continue;
            }
            pw.println("," + m_instrumentComps[i]);
        }
        pw.println("sqlmonitor.dms=true");
        pw.println("sqlmonitor.servertracing=true");
        pw.println("sqlmonitor.sysurl=" + DEFAULT_SYS_URL);
        pw.println("sqlmonitor.sysuser=" + m_sysUser);
        pw.println("sqlmonitor.syspassword=" + m_sysPassword);
        pw.println("sqlmonitor.dumpfile=" + m_instrumentApp.replace('.', File.separatorChar) + ".mtr");
        pw.flush();
        pw.close();
        try {
            ((OutputStreamWriter)osw).flush();
            ((OutputStreamWriter)osw).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void init(String app) {
        m_initialized = true;
        String propFName = app;
        propFName = propFName.replace('.', File.separatorChar) + ".properties";
        try {
            LineNumberReader lis = SQLMonitor.getLineNumberReader(propFName, "sqlmonitor.properties");
            String line = null;
            while (lis != null && (line = lis.readLine()) != null) {
                String str;
                if (line.startsWith("sqlmonitor.monitorcomp")) {
                    String comp = line.substring("sqlmonitor.monitorcomp=".length());
                    SQLMonitor.setMonitorComps(comp);
                    continue;
                }
                if (line.startsWith("sqlmonitor.dms")) {
                    String dms = line.substring("sqlmonitor.dms=".length());
                    SQLMonitor.setDmsMonitoring(dms.equals("1") || dms.equalsIgnoreCase("true"));
                    continue;
                }
                if (line.startsWith("sqlmonitor.servertracing")) {
                    str = line.substring("sqlmonitor.servertracing=".length());
                    SQLMonitor.setServerTracing(str.equals("1") || str.equalsIgnoreCase("true"));
                    continue;
                }
                if (line.startsWith("sqlmonitor.sysurl")) {
                    str = line.substring("sqlmonitor.sysurl=".length());
                    SQLMonitor.setSysUrl(str);
                    continue;
                }
                if (line.startsWith("sqlmonitor.sysuser")) {
                    str = line.substring("sqlmonitor.sysuser=".length());
                    SQLMonitor.setSysUser(str);
                    continue;
                }
                if (line.startsWith("sqlmonitor.syspassword")) {
                    str = line.substring("sqlmonitor.syspassword=".length());
                    SQLMonitor.setSysPassword(str);
                    continue;
                }
                if (!line.startsWith("sqlmonitor.dumpfile")) continue;
                String fname = line.substring("sqlmonitor.dumpfile=".length());
                SQLMonitor.setDumpFileName(fname);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static LineNumberReader getLineNumberReader(String fname, String defaultFName) {
        LineNumberReader lis = null;
        try {
            InputStream is;
            ClassLoader loader = SQLMonitor.class.getClassLoader();
            InputStream inputStream = is = loader != null ? loader.getResourceAsStream(fname) : ClassLoader.getSystemResourceAsStream(fname);
            if (is == null) {
                File stylefile = new File(defaultFName);
                lis = new LineNumberReader(new InputStreamReader(new FileInputStream(stylefile)));
            } else {
                lis = new LineNumberReader(new InputStreamReader(is));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lis;
    }

    public static int getNextId() {
        return m_eventId++;
    }

    public static boolean getDmsMonitoring() {
        return m_dmsMonitoring;
    }

    public static void setDmsMonitoring(boolean dMonitoring) {
        m_dmsMonitoring = dMonitoring;
    }

    public static boolean getServerTracing() {
        return m_serverTracing;
    }

    public static void setServerTracing(boolean sTracing) {
        m_serverTracing = sTracing;
    }

    public static void setMonitorComps(String compStr) {
        StringTokenizer st = new StringTokenizer(compStr, ",");
        m_monitorComps = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            SQLMonitor.m_monitorComps[i++] = st.nextToken();
        }
    }

    public static boolean isMonitored(String app, String comp) {
        if (!m_initialized) {
            SQLMonitor.init(app);
        }
        for (int i = 0; m_monitorComps != null && i < m_monitorComps.length; ++i) {
            if (!m_monitorComps[i].equalsIgnoreCase("all") && !m_monitorComps[i].equals(comp)) continue;
            return true;
        }
        return false;
    }

    public static String[] getMonitorComps() {
        return m_monitorComps;
    }

    public static void setSysUser(String user) {
        m_sysUser = user;
    }

    public static void setSysPassword(String pswd) {
        m_sysPassword = pswd;
    }

    private static void setSysUrl(String url) {
        m_sysUrl = url;
    }

    public static double[] getServerElapses(long sqlTimestamp) throws Exception {
        int i;
        double serverExecute = -1.0;
        double serverFetch = -1.0;
        double serverParse = -1.0;
        String serverTraceDir = SQLMonitor.getServerTracingDir();
        if (serverTraceDir == null) {
            return null;
        }
        String[] fileNames = new File(serverTraceDir).list();
        if (fileNames == null) {
            return null;
        }
        File[] files = new File[fileNames.length];
        for (i = 0; i < fileNames.length; ++i) {
            fileNames[i] = serverTraceDir + File.separator + fileNames[i];
            files[i] = new File(fileNames[i]);
        }
        for (i = 0; i < files.length; ++i) {
            LineNumberReader ln = new LineNumberReader(new InputStreamReader(new FileInputStream(fileNames[i])));
            String line = null;
            boolean found = false;
            while ((line = ln.readLine()) != null) {
                if (line.indexOf("" + sqlTimestamp) <= -1) continue;
                found = true;
                break;
            }
            if (!found) continue;
            String cmd = "tkprof " + fileNames[i] + " " + fileNames[i] + ".prf";
            Process svProcess = Runtime.getRuntime().exec(cmd);
            svProcess.waitFor();
            ln = new LineNumberReader(new InputStreamReader(new FileInputStream(fileNames[i] + ".prf")));
            line = null;
            while ((line = ln.readLine()) != null) {
                if (line.indexOf("" + sqlTimestamp) <= -1) continue;
                while ((line = ln.readLine()) != null) {
                    StringTokenizer st;
                    if (serverExecute == -1.0 && line.indexOf("Execute") > -1) {
                        st = new StringTokenizer(line);
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        serverExecute = new Double(st.nextToken());
                    }
                    if (serverFetch == -1.0 && line.indexOf("Fetch") > -1) {
                        st = new StringTokenizer(line);
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        serverFetch = new Double(st.nextToken());
                    }
                    if (serverParse == -1.0 && line.indexOf("Parse") > -1) {
                        st = new StringTokenizer(line);
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        serverParse = new Double(st.nextToken());
                    }
                    if (!(serverExecute > -1.0) || !(serverFetch > -1.0) || !(serverParse > -1.0)) continue;
                }
                break block3;
            }
            if (serverExecute > -1.0 && serverFetch > -1.0 && serverParse > -1.0) break;
        }
        if (serverExecute > -1.0) {
            serverExecute *= 1000.0;
        }
        if (serverFetch > -1.0) {
            serverFetch *= 1000.0;
        }
        if (serverParse > -1.0) {
            serverParse *= 1000.0;
        }
        return new double[]{serverExecute, serverFetch, serverParse};
    }

    private static String getServerTracingDir() {
        if (m_serverTracingDir != null) {
            return m_serverTracingDir;
        }
        try {
            Properties props = new Properties();
            props.put("user", m_sysUser);
            props.put("password", m_sysPassword);
            props.put("internal_logon", "sysdba");
            DriverManager.registerDriver((Driver)new OracleDriver());
            Connection conn = DriverManager.getConnection(m_sysUrl, props);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select value from v$parameter where name = 'user_dump_dest'");
            if (rs.next()) {
                m_serverTracingDir = rs.getString(1);
            }
            rs.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return m_serverTracingDir;
    }

    public static void dump() {
        if (SQLMonitor.getMonitorComps() == null || SQLMonitor.getMonitorComps().length == 0 || !SQLMonitor.getDmsMonitoring()) {
            return;
        }
        Object console = SQLMonitor.getDMSConsole();
        try {
            Class<?> dmsConsole = Class.forName("oracle.dms.console.DMSConsole");
            Method dumpMethod = dmsConsole.getMethod("dump", String.class, Boolean.TYPE, Boolean.TYPE);
            dumpMethod.invoke(console, SQLMonitor.getDumpFileName(), Boolean.TRUE, Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close() {
        SQLMonitor.dump();
        Object console = SQLMonitor.getDMSConsole();
        try {
            Class<?> dmsConsole = Class.forName("oracle.dms.console.DMSConsole");
            Method exitMethod = dmsConsole.getMethod("exit", new Class[0]);
            exitMethod.invoke(console, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getDumpFileName() {
        if (m_dumpFileName == null) {
            m_dumpFileName = m_instrumentApp.replace('.', File.separatorChar);
            m_dumpFileName = m_dumpFileName + ".mtr";
        }
        return m_dumpFileName;
    }

    private static void setDumpFileName(String fname) {
        m_dumpFileName = fname;
    }

    private static synchronized Object getDMSConsole() {
        if (m_dmsConsole == null) {
            try {
                Class<?> dmsConsole = Class.forName("oracle.dms.console.DMSConsole");
                Method getConsole = dmsConsole.getMethod("getConsole", new Class[0]);
                m_dmsConsole = getConsole.invoke(null, new Object[0]);
                Method init = dmsConsole.getMethod("init", String.class);
                init.invoke(m_dmsConsole, "DMSConsole for SQLJ Applications");
                Method setDumpFile = dmsConsole.getMethod("setDumpFile", String.class);
                setDumpFile.invoke(m_dmsConsole, SQLMonitor.getDumpFileName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_dmsConsole;
    }

    public static Object getEventFactory() {
        if (m_eventFactory == null) {
            try {
                Class<?> dmsConsole = Class.forName("oracle.dms.console.DMSConsole");
                Method newEventFactory = dmsConsole.getMethod("newEventFactory", new Class[0]);
                m_eventFactory = newEventFactory.invoke(SQLMonitor.getDMSConsole(), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_eventFactory;
    }

    public static Object getPhaseEventFactory() {
        if (m_phaseEventFactory == null) {
            try {
                Class<?> dmsConsole = Class.forName("oracle.dms.console.DMSConsole");
                Method newPhaseEventFactory = dmsConsole.getMethod("newPhaseEventFactory", new Class[0]);
                m_phaseEventFactory = newPhaseEventFactory.invoke(SQLMonitor.getDMSConsole(), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_phaseEventFactory;
    }

    public static Object getStateFactory() {
        if (m_stateFactory == null) {
            try {
                Class<?> dmsConsole = Class.forName("oracle.dms.console.DMSConsole");
                Method newStateFactory = dmsConsole.getMethod("newStateFactory", new Class[0]);
                m_stateFactory = newStateFactory.invoke(SQLMonitor.getDMSConsole(), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_stateFactory;
    }

    public static String getPrefix(String moduleName) {
        String separator = null;
        separator = File.separatorChar == '\\' ? "\\\\" : File.separator;
        String prefix = separator + "SQLJ" + (m_instrumentApp == null ? "" : separator + m_instrumentApp.replace(".", separator));
        if (moduleName != null && moduleName.length() > 0) {
            prefix = prefix + separator + moduleName.replace(".", separator);
        }
        return prefix;
    }

    static {
        m_initialized = false;
        m_eventId = 0;
        m_serverTracing = false;
        m_dmsConsole = null;
        m_eventFactory = null;
        m_phaseEventFactory = null;
        m_stateFactory = null;
        m_sysUrl = DEFAULT_SYS_URL = "jdbc:oracle:oci8:@";
        m_sysUser = "scott";
        m_sysPassword = "tiger";
        m_serverTracingDir = null;
    }
}

