/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.internal.OracleConnection;
import oracle.sqlj.runtime.OracleConnectionCloseCallback;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.ConnectionContextFactory;
import sqlj.runtime.SqljDataSource;
import sqlj.runtime.error.RuntimeErrors;
import sqlj.runtime.ref.DefaultContext;

public class OracleConnectionContextFactory
implements ConnectionContextFactory,
Serializable {
    private SqljDataSource dataSource;

    public OracleConnectionContextFactory(SqljDataSource sqljDataSource) {
        this.dataSource = sqljDataSource;
    }

    public DefaultContext getDefaultContext(boolean bl) throws SQLException {
        DefaultContext defaultContext = this.getDefaultContext();
        defaultContext.getConnection().setAutoCommit(bl);
        return defaultContext;
    }

    public DefaultContext getDefaultContext(String string, String string2, boolean bl) throws SQLException {
        DefaultContext defaultContext = this.getDefaultContext(string, string2);
        defaultContext.getConnection().setAutoCommit(bl);
        return defaultContext;
    }

    public ConnectionContext getContext(Class clazz, boolean bl) throws SQLException {
        ConnectionContext connectionContext = this.getContext(clazz);
        connectionContext.getConnection().setAutoCommit(bl);
        return connectionContext;
    }

    public ConnectionContext getContext(Class clazz, String string, String string2, boolean bl) throws SQLException {
        ConnectionContext connectionContext = this.getContext(clazz, string, string2);
        connectionContext.getConnection().setAutoCommit(bl);
        return connectionContext;
    }

    public DefaultContext getDefaultContext() throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.dataSource.getConnection();
        DefaultContext defaultContext = new DefaultContext((Connection)oracleConnection);
        try {
            Class<?> clazz = oracleConnection.getClass();
            Method method = clazz.getMethod("registerCloseCallback", OracleCloseCallback.class, Object.class);
            method.invoke((Object)oracleConnection, new OracleConnectionCloseCallback(), defaultContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultContext;
    }

    public DefaultContext getDefaultContext(String string, String string2) throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.dataSource.getConnection(string, string2);
        DefaultContext defaultContext = new DefaultContext((Connection)oracleConnection);
        try {
            Class<?> clazz = oracleConnection.getClass();
            Method method = clazz.getMethod("registerCloseCallback", OracleCloseCallback.class, Object.class);
            method.invoke((Object)oracleConnection, new OracleConnectionCloseCallback(), defaultContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultContext;
    }

    public ConnectionContext getContext(Class clazz) throws SQLException {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(Class.forName("java.sql.Connection"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        OracleConnection oracleConnection = (OracleConnection)this.dataSource.getConnection();
        ConnectionContext connectionContext = null;
        try {
            connectionContext = (ConnectionContext)constructor.newInstance(oracleConnection);
        }
        catch (InstantiationException instantiationException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        catch (IllegalAccessException illegalAccessException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        catch (InvocationTargetException invocationTargetException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        try {
            Class<?> clazz2 = oracleConnection.getClass();
            Method method = clazz2.getMethod("registerCloseCallback", OracleCloseCallback.class, Object.class);
            method.invoke((Object)oracleConnection, new OracleConnectionCloseCallback(), connectionContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return connectionContext;
    }

    public ConnectionContext getContext(Class clazz, String string, String string2) throws SQLException {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(Class.forName("java.sql.Connection"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        OracleConnection oracleConnection = (OracleConnection)this.dataSource.getConnection(string, string2);
        ConnectionContext connectionContext = null;
        try {
            connectionContext = (ConnectionContext)constructor.newInstance(oracleConnection);
        }
        catch (InstantiationException instantiationException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        catch (IllegalAccessException illegalAccessException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        catch (InvocationTargetException invocationTargetException) {
            RuntimeErrors.raise_GET_CONTEXT();
        }
        try {
            Class<?> clazz2 = oracleConnection.getClass();
            Method method = clazz2.getMethod("registerCloseCallback", OracleCloseCallback.class, Object.class);
            method.invoke((Object)oracleConnection, new OracleConnectionCloseCallback(), connectionContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return connectionContext;
    }
}

