/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.jpub.reflect.RClass;
import oracle.jpub.reflect.RObject;

public class RField {
    private boolean m_isDeclared;
    private RClass m_declaringClass;
    private RClass m_type;
    private int m_modifiers;
    private String m_name;
    private Field m_field;

    static RField newRField(RClass cls, Field field) throws ClassNotFoundException {
        String name = field.getName();
        RField f = cls.getCachedField(name);
        if (f == null) {
            f = new RField();
            f.m_field = field;
        }
        return f;
    }

    static RField newRField(RClass cls, String name, boolean isDeclared) {
        RField f = cls.getCachedField(name);
        if (f == null) {
            f = new RField();
            f.m_declaringClass = cls;
            f.m_name = name;
            f.m_isDeclared = isDeclared;
        }
        return f;
    }

    static RField newRField(RClass cls, int modif, String type, String name) throws ClassNotFoundException {
        RField f = cls.getCachedField(name);
        if (f == null) {
            f = new RField();
            f.m_declaringClass = cls;
            f.m_modifiers = modif;
            f.m_type = RClass.newRClass(cls, name);
            f.m_name = name;
            cls.putCachedField(name, f);
        }
        return f;
    }

    static RField[] map(RClass cls, int[] modif, String[] type, String[] name) throws ClassNotFoundException {
        RField[] fa = new RField[modif.length];
        for (int i = 0; i < fa.length; ++i) {
            fa[i] = RField.newRField(cls, modif[i], type[i], name[i]);
        }
        return fa;
    }

    static RField[] map(RClass cls, Field[] f) throws ClassNotFoundException {
        RField[] fa = new RField[f.length];
        for (int i = 0; i < fa.length; ++i) {
            fa[i] = RField.newRField(cls, f[i]);
        }
        return fa;
    }

    private RField() {
    }

    public RClass getDeclaringClass() {
        return this.m_field == null ? this.m_declaringClass : RClass.newRClass(this.m_field.getDeclaringClass());
    }

    public String getName() {
        return this.m_field == null ? this.m_name : this.m_field.getName();
    }

    public int getModifiers() {
        return this.m_field == null ? this.m_modifiers : this.m_field.getModifiers();
    }

    public RClass getType() {
        return this.m_field == null ? this.m_type : RClass.newRClass(this.m_field.getType());
    }

    public String toString() {
        return this.m_field == null ? Modifier.toString(this.m_modifiers) + " " + this.m_type.toString() + " " + this.m_name : this.m_field.toString();
    }

    public RObject get(Object o) throws IllegalAccessException {
        if (this.m_field == null || o != null && o instanceof RObject) {
            return new RObject(this.m_declaringClass.getDefaultContext(), this.m_declaringClass.getName(), this.m_name, o, this.m_isDeclared);
        }
        return new RObject(this.m_field.get(o), true, true);
    }

    public RObject set(Object o, Object v) {
        if (this.m_field == null || o != null && o instanceof RObject || v != null && v instanceof RObject) {
            return new RObject(this.m_declaringClass.getDefaultContext(), this.m_declaringClass.getName(), this.m_name, o, v, this.m_isDeclared);
        }
        try {
            this.m_field.set(o, v);
            return new RObject(null, false, false);
        }
        catch (Throwable t) {
            return new RObject(t, false, false);
        }
    }
}

