/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.viewBuilder.ColumnLinkPort;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;

public class RelationshipLink
extends ViewBuilderLink {
    public static final String PROPERTY_INCLUDED = "included";
    public static final String PROPERTY_DOUBLE_CLICK = "doubleClick";
    public static final String PROPERTY_SOURCE_OUTER_JOIN = "sourceOuterJoin";
    public static final String PROPERTY_DESTINATION_OUTER_JOIN = "destinationOuterJoin";
    private Relationship _relationship;
    private boolean _included;
    private boolean _userDoubleClick;
    private boolean _sourceOuterJoin;
    private boolean _destinationOuterJoin;

    public RelationshipLink(ColumnLinkPort source, ColumnLinkPort destination, Relationship relationship) {
        super(source, destination);
        if (relationship == null) {
            throw new IllegalArgumentException();
        }
        this._relationship = relationship;
    }

    public RelationshipLink(ColumnLinkPort[] sources, ColumnLinkPort[] destinations, Relationship relationship) {
        super(sources, destinations);
        if (relationship == null) {
            throw new IllegalArgumentException();
        }
        this._relationship = relationship;
    }

    public Relationship getRelationship() {
        return this._relationship;
    }

    public void setIncluded(boolean included) {
        if (this.getSourcePort(0).getViewBuilderComponent() == this.getDestinationPort(0).getViewBuilderComponent()) {
            return;
        }
        if (this._included != included) {
            this._included = included;
            this.fireBooleanPropertyChange(PROPERTY_INCLUDED, this._included);
        }
    }

    public boolean isIncluded() {
        return this._included;
    }

    public boolean isUserDoubleClick() {
        return this._userDoubleClick;
    }

    public void setUserDoubleClick(boolean click) {
        if (this._userDoubleClick != click) {
            this._userDoubleClick = click;
            this.fireBooleanPropertyChange(PROPERTY_DOUBLE_CLICK, this._userDoubleClick);
        }
    }

    public void setSourceOuterJoin(boolean sourceOuterJoin) {
        if (this._sourceOuterJoin != sourceOuterJoin) {
            this._sourceOuterJoin = sourceOuterJoin;
            this.fireBooleanPropertyChange(PROPERTY_SOURCE_OUTER_JOIN, this._sourceOuterJoin);
        }
    }

    public boolean isSourceOuterJoin() {
        return this._sourceOuterJoin;
    }

    public void setDestinationOuterJoin(boolean destinationOuterJoin) {
        if (this._destinationOuterJoin != destinationOuterJoin) {
            this._destinationOuterJoin = destinationOuterJoin;
            this.fireBooleanPropertyChange(PROPERTY_DESTINATION_OUTER_JOIN, this._destinationOuterJoin);
        }
    }

    public boolean isDestinationOuterJoin() {
        return this._destinationOuterJoin;
    }
}

