/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.bali.dbUI.queryBuilder.QueryBuilder;
import oracle.bali.dbUI.util.jdbc.JDBCDatabase;
import oracle.bali.dbUI.util.jdbc.JDBCModelFactory;

public class JDBCQueryBuilder
extends QueryBuilder {
    private Connection _connection;

    public JDBCQueryBuilder() {
    }

    public JDBCQueryBuilder(String url) throws SQLException {
        super(null);
        this.connect(url);
    }

    public JDBCQueryBuilder(String url, String user, String password) throws SQLException {
        super(null);
        this.connect(url, user, password);
    }

    public final void connect(String url) throws SQLException {
        this.disconnect();
        Connection connection = DriverManager.getConnection(url);
        this.setConnection(connection);
    }

    public final void connect(String url, String user, String password) throws SQLException {
        this.disconnect();
        Connection connection = DriverManager.getConnection(url, user, password);
        this.setConnection(connection);
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection connection) {
        if (this._connection != null) {
            try {
                this._connection.close();
            }
            catch (SQLException se) {
                System.err.println("couldn't close connection " + this._connection);
            }
            this._connection = null;
        }
        this._connection = connection;
        if (this._connection == null) {
            this.setDatabase(null);
            this.setModelFactory(null);
        } else {
            this.setDatabase(new JDBCDatabase(this._connection));
            this.setModelFactory(new JDBCModelFactory(this._connection));
        }
    }

    public final void disconnect() {
        this.setConnection(null);
    }
}

