/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.propertyTable.PropertyTable;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.beans.JavaIntrospector;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.Comparator;

class PTModel
implements TwoDModel,
OneDModel,
Sortable {
    private PropertyTable _parent;
    private PropertyDescriptor[] _desc;
    private int _columnCount;
    private ListenerManager _twoDDSManager;
    private ListenerManager _oneDDSManager;
    private SortableTwoDModel _store;

    public PTModel(PropertyTable parent) {
        this._parent = parent;
    }

    public void setObjects(Object[] rows) {
        int oldRowCount = this._store == null ? 0 : this._store.getRowCount();
        int newRowCount = rows == null ? 0 : rows.length;
        int rowDiff = newRowCount - oldRowCount;
        int oldColumnCount = this._columnCount;
        this._columnCount = this._analizeColumns(rows);
        int columnDiff = this._columnCount - oldColumnCount;
        this._store = new SortableTwoDModel(this._columnCount + 1, newRowCount);
        for (int i = 0; i < newRowCount; ++i) {
            this._store.setData(this._columnCount, i, rows[i]);
        }
        this._sendRowsChangedEvent(newRowCount - oldRowCount);
        this._sendColumnsChangedEvent(columnDiff);
        this._sendItemsChangedEvent(columnDiff);
    }

    public PropertyDescriptor getDescriptor(int index) {
        return this._desc == null ? null : this._desc[index];
    }

    public int getIndex(PropertyDescriptor desc) {
        if (this._desc == null) {
            return -1;
        }
        for (int i = 0; i < this._desc.length; ++i) {
            if (!this._desc[i].equals(desc)) continue;
            return i;
        }
        return -1;
    }

    public Comparator getComparator(int index) {
        return this._store == null ? null : this._store.getColumnComparator(index);
    }

    public void setComparator(int index, Comparator c) {
        if (this._store != null) {
            this._store.setColumnComparator(index, c);
        }
    }

    public Object[] getObjects() {
        int size = this.getRowCount();
        if (size == 0) {
            return null;
        }
        int index = this.getColumnCount();
        Object[] objects = new Object[size];
        for (int i = 0; i < size; ++i) {
            objects[i] = this._store.getData(index, i);
        }
        return objects;
    }

    public int getRowCount() {
        return this._store == null ? 0 : this._store.getRowCount();
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public Object getData(int column, int row) {
        if (this._store == null) {
            return null;
        }
        Object data = this._store.getData(column, row);
        if (data == null) {
            data = this._getData(column, row);
            this._store.setData(column, row, data);
        }
        return data;
    }

    public void setData(int column, int row, Object data) {
        Method write;
        if (this._store == null) {
            throw new IllegalStateException("There are no columns");
        }
        if (!this._isEditable(column)) {
            throw new IllegalArgumentException("Column " + column + " is not editable");
        }
        if (this._desc != null && (write = this._desc[column].getWriteMethod()) != null) {
            try {
                Object o = this._store.getData(this.getColumnCount(), row);
                write.invoke(o, data);
                this._store.setData(column, row, data);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        this._invalidateCells(column, 1, row, 1);
    }

    public void addModelListener(TwoDModelListener listener) {
        if (this._twoDDSManager == null) {
            this._twoDDSManager = new ListenerManager();
        }
        this._twoDDSManager.addListener((EventListener)listener);
    }

    public void removeModelListener(TwoDModelListener listener) {
        if (this._twoDDSManager != null) {
            this._twoDDSManager.removeListener((EventListener)listener);
        }
    }

    public int getItemCount() {
        return this._columnCount;
    }

    public Object getData(int index) {
        String data = null;
        if (this._desc != null) {
            data = this._parent.getPropertyDisplayName(this._desc[index]);
        }
        return data;
    }

    public void setData(int index, Object data) {
    }

    public void addModelListener(OneDModelListener listener) {
        if (this._oneDDSManager == null) {
            this._oneDDSManager = new ListenerManager();
        }
        this._oneDDSManager.addListener((EventListener)listener);
    }

    public void removeModelListener(OneDModelListener listener) {
        if (this._oneDDSManager != null) {
            this._oneDDSManager.removeListener((EventListener)listener);
        }
    }

    public void sort(int index, boolean ascending) {
        if (this._store == null || this.getComparator(index) == null) {
            return;
        }
        this._parent.freezeRepaints();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object data = this._getData(index, i);
            this._store.setData(index, i, data);
            this._parent.setRowVisibleIndex(i, i);
        }
        this._store.sort(index, ascending);
        this._invalidateCells(0, this.getColumnCount(), 0, rowCount);
        this._parent.unfreezeRepaints();
        this._parent.repaint();
    }

    private Object _getData(int column, int row) {
        Method read;
        Object data = null;
        if (this._desc != null && (read = this._desc[column].getReadMethod()) != null) {
            try {
                Object o = this._store.getData(this.getColumnCount(), row);
                data = read.invoke(o, (Object[])null);
            }
            catch (Exception e) {
                data = null;
            }
        }
        return data;
    }

    private void _sendItemsChangedEvent(int diff) {
        if (diff == 0 || this._oneDDSManager == null) {
            return;
        }
        Enumeration e = this._oneDDSManager.getListeners();
        if (e == null) {
            return;
        }
        if (diff > 0) {
            OneDModelEvent event = new OneDModelEvent((Object)this, 2001, 0, diff);
            while (e.hasMoreElements()) {
                OneDModelListener listener = (OneDModelListener)e.nextElement();
                listener.itemsAdded(event);
            }
        } else {
            OneDModelEvent event = new OneDModelEvent((Object)this, 2002, 0, -diff);
            while (e.hasMoreElements()) {
                OneDModelListener listener = (OneDModelListener)e.nextElement();
                listener.itemsRemoved(event);
            }
        }
    }

    private void _sendRowsChangedEvent(int diff) {
        if (diff == 0 || this._twoDDSManager == null) {
            return;
        }
        Enumeration e = this._twoDDSManager.getListeners();
        if (e == null) {
            return;
        }
        if (diff > 0) {
            TwoDModelEvent event = new TwoDModelEvent((Object)this, 2004, 0, diff);
            while (e.hasMoreElements()) {
                TwoDModelListener listener = (TwoDModelListener)e.nextElement();
                listener.rowsAdded(event);
            }
        } else {
            TwoDModelEvent event = new TwoDModelEvent((Object)this, 2005, 0, -diff);
            while (e.hasMoreElements()) {
                TwoDModelListener listener = (TwoDModelListener)e.nextElement();
                listener.rowsRemoved(event);
            }
        }
    }

    private void _sendColumnsChangedEvent(int diff) {
        if (diff == 0 || this._twoDDSManager == null) {
            return;
        }
        Enumeration e = this._twoDDSManager.getListeners();
        if (e == null) {
            return;
        }
        if (diff > 0) {
            TwoDModelEvent event = new TwoDModelEvent((Object)this, 2001, 0, diff);
            while (e.hasMoreElements()) {
                TwoDModelListener listener = (TwoDModelListener)e.nextElement();
                listener.columnsAdded(event);
            }
        } else {
            TwoDModelEvent event = new TwoDModelEvent((Object)this, 2002, 0, -diff);
            while (e.hasMoreElements()) {
                TwoDModelListener listener = (TwoDModelListener)e.nextElement();
                listener.columnsRemoved(event);
            }
        }
    }

    private void _invalidateCells(int startColumn, int columnCount, int startRow, int rowCount) {
        if (this._twoDDSManager == null) {
            return;
        }
        Enumeration e = this._twoDDSManager.getListeners();
        if (e == null) {
            return;
        }
        TwoDModelEvent event = new TwoDModelEvent((Object)this, 2007, startColumn, columnCount, startRow, rowCount);
        while (e.hasMoreElements()) {
            TwoDModelListener listener = (TwoDModelListener)e.nextElement();
            listener.invalidateCells(event);
        }
    }

    private boolean _isEditable(int index) {
        boolean editable = false;
        if (this._desc != null) {
            Method write = this._desc[index].getWriteMethod();
            editable = write != null;
        }
        return editable;
    }

    private int _analizeColumns(Object[] rows) {
        if (rows == null || rows.length == 0) {
            return 0;
        }
        Object o = rows[0];
        BeanInfo info = null;
        try {
            info = JavaIntrospector.getBeanInfo(o.getClass());
        }
        catch (IntrospectionException e) {
            info = null;
        }
        this._desc = info == null ? null : info.getPropertyDescriptors();
        return this._desc == null ? 0 : this._desc.length;
    }
}

