/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.scrolling;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.dbUI.graph.scrolling.MiddleLayout;
import oracle.bali.dbUI.graph.scrolling.ScrollAreaLayout;
import oracle.bali.dbUI.graph.scrolling.ScrollToolbar;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.layout.MaximumBorderLayout;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.share.util.IntegerUtils;

public class ScrollArea
extends LWComponent
implements Accessible {
    private static Image _sTOP = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_top.gif");
    private static Image _sTOP_HALF = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_tophalf.gif");
    private static Image _sMIDDLE = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_middle.gif");
    private static Image _sBOTTOM_HALF = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_bottomhalf.gif");
    private static Image _sBOTTOM = ImageUtils.getImageResource(ScrollToolbar.class, (String)"/oracle/bali/dbUI/graph/scrolling/images/scroll_bottom.gif");
    private static final String _TOOLTIP_KEY = "SCROLLAREA.TOOLTIP";
    private static final String _KEY_TOP = "top";
    private static final String _KEY_BOTTOM = "bottom";
    private JViewport _viewPort;
    private SpreadTable _table;
    private ScrollToolbar _topScroll;
    private ScrollToolbar _bottomScroll;
    private Indicator _topIndicator;
    private Indicator _bottomIndicator;
    private JPanel _middle;

    public ScrollArea(SpreadTable table) {
        this.setLayout((LayoutManager)new MaximumBorderLayout(0, 1));
        this._viewPort = new JViewport();
        this._bottomScroll = new ScrollToolbar(this._viewPort, (Scrollable)table);
        this._bottomIndicator = new Indicator(this._bottomScroll);
        Container bottom = this._createScrollButtonArea(this._bottomScroll, (Component)((Object)this._bottomIndicator));
        this.add("South", bottom);
        this._topScroll = new ScrollToolbar(this._viewPort, (Scrollable)table);
        this._topIndicator = new Indicator(this._topScroll);
        Container top = this._createScrollButtonArea(this._topScroll, (Component)((Object)this._topIndicator));
        this.add("North", top);
        this._middle = new JPanel(new MiddleLayout());
        this._middle.setBorder(new BP());
        this._middle.add("center", this._viewPort);
        this.add("Center", this._middle);
        this._table = table;
        Listener listener = new Listener();
        this._topScroll.addAdjustmentListener(listener);
        this._bottomScroll.addAdjustmentListener(listener);
        this._viewPort.addChangeListener(listener);
        this._middle.add("north", (Component)this._table.getColumnHeader());
        this._viewPort.setView((Component)this._table.getGrid());
    }

    public void addVAdjustmentListener(AdjustmentListener listener) {
        this._topScroll.addAdjustmentListener(listener);
        this._bottomScroll.addAdjustmentListener(listener);
    }

    public void removeVAdjustmentListener(AdjustmentListener listener) {
        this._topScroll.removeAdjustmentListener(listener);
        this._bottomScroll.removeAdjustmentListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._topScroll.setEnabled(enabled);
        this._bottomScroll.setEnabled(enabled);
        this._bottomIndicator.setEnabled(enabled);
        this._topIndicator.setEnabled(enabled);
        this._table.setEnabled(enabled);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    public void addNotify() {
        super.addNotify();
        this._middle.add("north", (Component)this._table.getColumnHeader());
        this._viewPort.setView((Component)this._table.getGrid());
    }

    private void _syncScrollBarsWithViewport() {
        JViewport viewport = this._viewPort;
        ScrollToolbar top = this._topScroll;
        ScrollToolbar bottom = this._bottomScroll;
        Dimension extentSize = viewport.getExtentSize();
        Dimension viewSize = viewport.getViewSize();
        Point viewPosition = viewport.getViewPosition();
        int extent = extentSize.height;
        int max = viewSize.height;
        int value = Math.max(0, Math.min(viewPosition.y, max - extent));
        top.setValues(value, extent, 0, max);
        bottom.setValues(value, extent, 0, max);
    }

    private Container _createScrollButtonArea(Component center, Component east) {
        LWComponent area = new LWComponent();
        area.setLayout((LayoutManager)new ScrollAreaLayout());
        area.setOpaque(true);
        area.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        area.add("center", center);
        area.add("east", east);
        return area;
    }

    private class BP
    implements Border {
        private BP() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int right = x + width - 1;
            int bottom = y + height - 1;
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawLine(x, y, right, y);
            g.drawLine(x, bottom, right, bottom);
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class IPainter
    extends ImagePainter {
        private Adjustable _adjustable;

        public IPainter(Adjustable a) {
            super(0);
            this._adjustable = a;
        }

        protected Image getImageData(PaintContext context) {
            int value = this._adjustable.getValue();
            int min = this._adjustable.getMinimum();
            int max = this._adjustable.getMaximum();
            int visible = this._adjustable.getVisibleAmount();
            int bottom = max - visible - value;
            if (value <= min) {
                return _sTOP;
            }
            if (bottom <= min) {
                return _sBOTTOM;
            }
            return _sMIDDLE;
        }
    }

    private class Indicator
    extends PainterComponent
    implements AdjustmentListener {
        private Painter _painter;
        private ScrollToolbar _bar;

        public Indicator(ScrollToolbar bar) {
            this._painter = new FixedBorderPainter((Painter)new IPainter(bar), 0, 3, 0, 3);
            this._bar = bar;
            this._bar.addAdjustmentListener(this);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        }

        public String getToolTipText() {
            float unitIncrement = this._bar.getUnitIncrement();
            int value = Math.round((float)this._bar.getValue() / unitIncrement);
            int visible = Math.round((float)this._bar.getVisibleAmount() / unitIncrement);
            int max = Math.round((float)this._bar.getMaximum() / unitIncrement);
            Number[] args = new Number[]{IntegerUtils.getInteger((int)value), IntegerUtils.getInteger((int)(value + visible)), IntegerUtils.getInteger((int)max)};
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.GraphBundle", this.getLocale());
            String pattern = b.getString(ScrollArea._TOOLTIP_KEY);
            return MessageFormat.format(pattern, args);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            ScrollArea.this.repaint();
        }

        public Painter getPainter() {
            return this._painter;
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        public Access() {
            super((JComponent)((Object)ScrollArea.this));
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    private class Listener
    implements ChangeListener,
    AdjustmentListener {
        private Listener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            JViewport viewport = ScrollArea.this._viewPort;
            Point p = viewport.getViewPosition();
            p.y = e.getValue();
            viewport.setViewPosition(p);
            if (e.getSource() == ScrollArea.this._topScroll) {
                ScrollArea.this._bottomScroll.setValue(e.getValue());
            } else {
                ScrollArea.this._topScroll.setValue(e.getValue());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScrollArea.this._syncScrollBarsWithViewport();
        }
    }
}

