/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.SwingUtilities;

class AccessibleComponentImpl
extends AccessibleContext
implements AccessibleComponent {
    private Component _component;
    private ContainerListener _accessibleContainerHandler;

    public AccessibleComponentImpl(Component component) {
        this._component = component;
        if (this._component instanceof Container) {
            this._accessibleContainerHandler = new AccessibleContainerHandler();
            ((Container)this._component).addContainerListener(this._accessibleContainerHandler);
        }
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.AWT_COMPONENT;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        return SwingUtilities.getAccessibleStateSet(this.getComponent());
    }

    @Override
    public Accessible getAccessibleParent() {
        if (this.accessibleParent != null) {
            return this.accessibleParent;
        }
        Container parent = this._component.getParent();
        if (parent instanceof Accessible) {
            return (Accessible)((Object)parent);
        }
        return null;
    }

    @Override
    public int getAccessibleIndexInParent() {
        return SwingUtilities.getAccessibleIndexInParent(this.getComponent());
    }

    @Override
    public int getAccessibleChildrenCount() {
        return SwingUtilities.getAccessibleChildrenCount(this.getComponent());
    }

    @Override
    public Accessible getAccessibleChild(int i) {
        return SwingUtilities.getAccessibleChild(this.getComponent(), i);
    }

    @Override
    public Locale getLocale() {
        return this._component.getLocale();
    }

    @Override
    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    @Override
    public Color getBackground() {
        return this._component.getBackground();
    }

    @Override
    public void setBackground(Color c) {
        this._component.setBackground(c);
    }

    @Override
    public Color getForeground() {
        return this._component.getForeground();
    }

    @Override
    public void setForeground(Color c) {
        this._component.setForeground(c);
    }

    @Override
    public Cursor getCursor() {
        Cursor cursor = this._component.getCursor();
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        return cursor;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    @Override
    public Font getFont() {
        return this._component.getFont();
    }

    @Override
    public void setFont(Font f) {
        this._component.setFont(f);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this._component.getFontMetrics(f);
    }

    @Override
    public boolean isEnabled() {
        return this._component.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        boolean old = this.isEnabled();
        this._component.setEnabled(b);
        if (b != old) {
            this._firePropertyChange(b, AccessibleState.ENABLED);
        }
    }

    @Override
    public boolean isVisible() {
        return this._component.isVisible();
    }

    @Override
    public void setVisible(boolean b) {
        boolean old = this.isVisible();
        this._component.setVisible(b);
        if (b != old) {
            this._firePropertyChange(b, AccessibleState.VISIBLE);
        }
    }

    @Override
    public boolean isShowing() {
        return this._component.isShowing();
    }

    @Override
    public boolean contains(Point p) {
        return this._component.contains(p);
    }

    @Override
    public Point getLocationOnScreen() {
        if (this._component.isShowing()) {
            return this._component.getLocationOnScreen();
        }
        return null;
    }

    @Override
    public Point getLocation() {
        return this._component.getLocation();
    }

    @Override
    public void setLocation(Point p) {
        this._component.setLocation(p);
    }

    @Override
    public Rectangle getBounds() {
        return this._component.getBounds();
    }

    @Override
    public void setBounds(Rectangle r) {
        this._component.setBounds(r);
    }

    @Override
    public Dimension getSize() {
        return this._component.getSize();
    }

    @Override
    public void setSize(Dimension d) {
        this._component.setSize(d);
    }

    @Override
    public Accessible getAccessibleAt(Point p) {
        return SwingUtilities.getAccessibleAt(this.getComponent(), p);
    }

    @Override
    public boolean isFocusTraversable() {
        return this._component.isFocusTraversable();
    }

    @Override
    public void requestFocus() {
        this._component.requestFocus();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this._component.addFocusListener(l);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this._component.removeFocusListener(l);
    }

    protected Component getComponent() {
        return this._component;
    }

    private void _firePropertyChange(boolean on, Object state) {
        this.firePropertyChange("AccessibleState", on ? null : state, on ? state : null);
    }

    private class AccessibleContainerHandler
    implements ContainerListener {
        private AccessibleContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof Accessible) {
                AccessibleComponentImpl.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof Accessible) {
                AccessibleComponentImpl.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
            }
        }
    }
}

