/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.Sortable;

class SortInputHandler
extends StandardHeaderKeyHandler
implements HeaderItemInputHandler {
    private Sortable _ds;
    private int _item = -1;
    private boolean _inside;
    private boolean[] _order;
    private int _lastColumn = -1;

    public SortInputHandler(Sortable ds) {
        this._ds = ds;
        this._order = new boolean[6];
    }

    public void handleKeyEvent(Header header, KeyEvent e) {
        if (e.getID() == 402 && e.getKeyCode() == 32) {
            this.sort(header.getFocusItem());
        }
        super.handleKeyEvent(header, e);
    }

    public void sort(int index) {
        this.sort(index, this._order[index]);
    }

    public void sort(int index, boolean order) {
        this._lastColumn = index;
        this._ds.sort(index, order);
        this._order[index] = !order;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public boolean getColumnAscending(int column) {
        return this._order[column];
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        this._inside = true;
        this._item = itemIndex;
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
        if (this._item == -1) {
            return;
        }
        if (this._inside && this._item == itemIndex) {
            this.sort(itemIndex);
        }
        this._item = -1;
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
        this._inside = itemIndex == this._item;
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
        this._inside = itemIndex != this._item;
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }
}

