/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db;

import java.util.Locale;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;

public class TableAlias
extends Table {
    private Table _table;
    private String _displayName;
    private String _name;
    private Column[] _columns;

    public TableAlias(Table table, String name, String displayName) {
        if (table == null || table instanceof DynamicTable) {
            throw new IllegalArgumentException();
        }
        this._table = table;
        this._name = name;
        this._displayName = displayName;
    }

    public Table getTable() {
        return this._table;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this._displayName;
    }

    @Override
    public Schema getSchema() {
        return this.getTable().getSchema();
    }

    @Override
    public int getColumnCount() {
        return this.getTable().getColumnCount();
    }

    @Override
    public Column getColumn(int index) {
        Column c = this.getTable().getColumn(index);
        if (this._columns == null) {
            this._columns = new Column[this.getColumnCount()];
        }
        if (this._columns[index] == null) {
            this._columns[index] = new ColumnImpl(c.getName(), c.getDisplayName(Locale.getDefault()), c.getDataType(), c.isNullAllowed(), c.getDefaultValue(), this);
        }
        return this._columns[index];
    }

    @Override
    public int getPrimaryKeyCount() {
        return this.getTable().getPrimaryKeyCount();
    }

    @Override
    public Column getPrimaryKey(int primaryKeyIndex) {
        return this.getTable().getPrimaryKey(primaryKeyIndex);
    }

    @Override
    public int getUniqueKeyCount() {
        return this.getTable().getUniqueKeyCount();
    }

    @Override
    public Column getUniqueKey(int uniqueKeyIndex) {
        return this.getTable().getUniqueKey(uniqueKeyIndex);
    }

    @Override
    public int getForeignKeyCount() {
        return this.getTable().getForeignKeyCount();
    }

    @Override
    public Relationship getForeignKey(int foreignKeyIndex) {
        return this.getTable().getForeignKey(foreignKeyIndex);
    }

    @Override
    public int getExportedKeyCount() {
        return this.getTable().getExportedKeyCount();
    }

    @Override
    public Relationship getExportedKey(int exportedKeyIndex) {
        return this.getTable().getExportedKey(exportedKeyIndex);
    }
}

