/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.db;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.event.DynamicRelationshipEvent;
import oracle.bali.dbUI.db.event.DynamicRelationshipListener;
import oracle.bali.share.event.ListenerManager;

public abstract class DynamicRelationship
extends Relationship {
    public static final String PROPERTY_TYPE = "relationshipType";
    private PropertyChangeSupport _support;
    private ListenerManager _listener;

    public abstract void setRelationshipType(int var1);

    public abstract void addColumn(Column var1, Column var2, int var3);

    public abstract void removeColumn(Column var1, Column var2);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(listener);
        }
    }

    public void addRelationshipListener(DynamicRelationshipListener listener) {
        if (this._listener == null) {
            this._listener = new ListenerManager();
        }
        this._listener.addListener((EventListener)listener);
    }

    public void removeRelationshipListener(DynamicRelationshipListener listener) {
        if (this._listener != null) {
            this._listener.removeListener((EventListener)listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void fireRelationshipEvent(int id, Column childColumn, Column parentColumn, int index) {
        DynamicRelationshipEvent e = new DynamicRelationshipEvent(this, id, childColumn, parentColumn, index);
        this.processRelationshipEvent(e);
    }

    protected void processRelationshipEvent(DynamicRelationshipEvent e) {
        if (this._listener == null) {
            return;
        }
        Enumeration enumer = this._listener.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getID()) {
            case 100: {
                while (enumer.hasMoreElements()) {
                    ((DynamicRelationshipListener)enumer.nextElement()).columnAdded(e);
                }
                break;
            }
            case 101: {
                while (enumer.hasMoreElements()) {
                    ((DynamicRelationshipListener)enumer.nextElement()).columnRemoved(e);
                }
                break;
            }
        }
    }
}

