/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import oracle.bali.dbUI.constraintComponent.MultiDescriptorComponent;

public final class MultiLayoutManager
implements LayoutManager {
    public static final String ITEM = "item";
    public static final String COMPONENT = "component";
    public static final int HINSET = 2;
    private static final int _VINSET = 0;
    private Component _item;
    private Component _component;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (ITEM.equals(name)) {
            this._item = comp;
        } else if (COMPONENT.equals(name)) {
            this._component = comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this._item) {
            this._item = null;
        } else if (comp == this._component) {
            this._component = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        MultiDescriptorComponent c = (MultiDescriptorComponent)((Object)parent);
        int width = 0;
        int height = 0;
        Dimension itemSize = this._item.getPreferredSize();
        itemSize.width = c.getItemWidth();
        Dimension componentSize = this._component.isVisible() ? this._component.getPreferredSize() : new Dimension(0, 0);
        height = itemSize.height + 0;
        width = itemSize.width + 2 + componentSize.width;
        return new Dimension(width, height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        MultiDescriptorComponent c = (MultiDescriptorComponent)((Object)parent);
        int x = 0;
        int y = 0;
        Dimension itemSize = this._item.getPreferredSize();
        itemSize.width = c.getItemWidth();
        int height = itemSize.height;
        this._item.setBounds(x, y, itemSize.width, height);
        Dimension compSize = this._component.getPreferredSize();
        Dimension size = c.getSize();
        if ((x += itemSize.width + 2) + compSize.width < size.width) {
            compSize.width = size.width - x;
        }
        this._component.setBounds(x, y, compSize.width, height);
    }
}

