/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import oracle.bali.dbUI.constraintComponent.BaseConstraintComponent;

public final class BaseLayoutManager
implements LayoutManager {
    public static final String CONDITION = "condition";
    public static final String VALUE = "value";
    public static final String BETWEEN = "between";
    public static final int HINSET = 2;
    private static final int _VINSET = 0;
    private Component _condition;
    private Component _value;
    private Component _between;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (CONDITION.equals(name)) {
            this._condition = comp;
        } else if (VALUE.equals(name)) {
            this._value = comp;
        } else if (BETWEEN.equals(name)) {
            this._between = comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this._condition) {
            this._condition = null;
        } else if (comp == this._value) {
            this._value = null;
        } else if (comp == this._between) {
            this._between = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        BaseConstraintComponent c = (BaseConstraintComponent)((Object)parent);
        int width = 0;
        int height = 0;
        Dimension conditionSize = this._condition.getPreferredSize();
        conditionSize.width = c.getConditionWidth();
        height = conditionSize.height + 0;
        width = conditionSize.width + 2 + c.getValueWidth();
        return new Dimension(width, height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        BaseConstraintComponent c = (BaseConstraintComponent)((Object)parent);
        int x = 0;
        int y = 0;
        Dimension conditionSize = this._condition.getPreferredSize();
        conditionSize.width = c.getConditionWidth();
        this._condition.setBounds(x, y, conditionSize.width, conditionSize.height);
        x += conditionSize.width + 2;
        int height = conditionSize.height;
        int width = c.getValueWidth();
        if (width == 0) {
            return;
        }
        Dimension d = c.getSize();
        if (x + width < d.width) {
            width = d.width - x;
        }
        boolean between = c.isBetweenAllowed() && this._between != null && this._between.isVisible();
        int betweenSize = between ? this._between.getPreferredSize().width : 0;
        int valueWidth = width - betweenSize;
        this._value.setBounds(x, y, valueWidth, height);
        if (between) {
            this._between.setBounds(x += valueWidth + 2, y, betweenSize, height);
        }
    }
}

