/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.text.ParsePosition;
import oracle.i18n.text.OraDefaultDecimalFormatPattern;
import oracle.i18n.util.GDKOracleMetaData;

final class OraDecimalFormatPattern
implements Cloneable,
Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int NUMBER_MAP = 1;
    static final int SIGN_MAP = 2;
    static final int SPACE_MAP = 3;
    static final int CURRENCY_MAP = 4;
    static final int PARENTHESIS_MAP = 5;
    static final int ANGLE_BRACKET_MAP = 6;
    static final int MAX_BITS_MAP = 12;
    static final int BITS_PER_COMP_MAP = 3;
    static final int NUMBER_OF_COMP_MAP = 4;
    static final int COMP_MASK_MAP = 7;
    String pattern;
    String groupingSizes;
    int internalFormat;
    int outputStringSize;
    int numberOfDigitsLHS;
    int numberOfDigitsRHS;
    int numberOfLeadingZeros;
    int numberOfTrailingZeros;
    int numberOfGroups;
    int[] groupingSeparatorPositions = new int[1];
    boolean isGroupingSeparatorOn;
    boolean isSignOn;
    boolean isDecimalSeparatorOn;
    boolean isFmOn;
    boolean isBOn;
    boolean isTmOn;
    boolean isVOn;
    boolean useScientificNotation;
    boolean usePeriod;
    boolean useComma;
    boolean useDollar;
    boolean useIntlCurrency;
    boolean useDualCurrency;

    OraDecimalFormatPattern(OraDefaultDecimalFormatPattern oraDefaultDecimalFormatPattern) {
        this.pattern = oraDefaultDecimalFormatPattern.pattern;
        this.internalFormat = oraDefaultDecimalFormatPattern.internalFormat;
        this.numberOfDigitsRHS = oraDefaultDecimalFormatPattern.numberFractionDigits;
        this.numberOfLeadingZeros = oraDefaultDecimalFormatPattern.keepLeadingZero ? 1 : 0;
        this.numberOfTrailingZeros = oraDefaultDecimalFormatPattern.keepTrailingZero ? 1 : 0;
        this.groupingSizes = oraDefaultDecimalFormatPattern.groupingSizes;
    }

    OraDecimalFormatPattern(String string, boolean bl, ParsePosition parsePosition) {
        this.pattern = string;
        this.groupingSeparatorPositions = new int[string.length() >> 1];
        int n = this.toInternalPattern(bl);
        if (n <= string.length()) {
            parsePosition.setErrorIndex(n);
        } else {
            parsePosition.setIndex(n);
        }
    }

    int getNthComponent(int n) {
        return this.internalFormat >> (4 - n) * 3 & 7;
    }

    public Object clone() {
        try {
            OraDecimalFormatPattern oraDecimalFormatPattern = (OraDecimalFormatPattern)super.clone();
            if (this.groupingSizes == null) {
                int[] nArray = new int[this.pattern.length() >> 1];
                System.arraycopy(this.groupingSeparatorPositions, 0, nArray, 0, this.numberOfGroups);
                oraDecimalFormatPattern.groupingSeparatorPositions = nArray;
            }
            return oraDecimalFormatPattern;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDecimalFormatPattern)) {
            return false;
        }
        OraDecimalFormatPattern oraDecimalFormatPattern = (OraDecimalFormatPattern)object;
        return this.pattern.equals(oraDecimalFormatPattern.pattern) && (this.groupingSizes == null && this.numberOfGroups == oraDecimalFormatPattern.numberOfGroups && this.isEqual(this.groupingSeparatorPositions, oraDecimalFormatPattern.groupingSeparatorPositions, this.numberOfGroups) || this.groupingSizes != null && this.groupingSizes.equals(oraDecimalFormatPattern.groupingSizes));
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private int toInternalPattern(boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 12;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        StringBuffer stringBuffer = new StringBuffer(3);
        this.outputStringSize = 1;
        this.numberOfDigitsLHS = 0;
        this.numberOfDigitsRHS = 0;
        this.numberOfLeadingZeros = 0;
        this.numberOfTrailingZeros = 0;
        this.numberOfGroups = 0;
        this.isGroupingSeparatorOn = false;
        this.isSignOn = false;
        this.isDecimalSeparatorOn = false;
        this.isFmOn = false;
        this.isBOn = false;
        this.isTmOn = false;
        this.isVOn = false;
        this.useScientificNotation = false;
        this.usePeriod = false;
        this.useComma = false;
        this.useDollar = false;
        this.useIntlCurrency = false;
        this.useDualCurrency = false;
        int n6 = 0;
        int n7 = this.pattern.length();
        block21: for (n = 0; n < n7; ++n) {
            char c = this.pattern.charAt(n);
            switch (c) {
                case '.': 
                case '0': 
                case '9': 
                case 'D': 
                case 'd': {
                    if (bl3) {
                        return n;
                    }
                    block22: do {
                        c = this.pattern.charAt(n);
                        switch (c) {
                            case '9': {
                                ++n4;
                                break;
                            }
                            case '0': {
                                ++n4;
                                if (!bl2 && n6 != 0) continue block22;
                                n6 = n4;
                                break;
                            }
                            case ',': 
                            case 'G': 
                            case 'g': {
                                if (bl2 || this.isVOn) {
                                    return n;
                                }
                                if (c == ',') {
                                    this.useComma = true;
                                }
                                this.isGroupingSeparatorOn = true;
                                this.groupingSeparatorPositions[this.numberOfGroups++] = n4;
                                if (bl && n5 != 0) {
                                    stringBuffer.insert(0, n4 - n5);
                                }
                                n5 = n4;
                                ++this.outputStringSize;
                                break;
                            }
                            case 'V': 
                            case 'v': {
                                if (this.isVOn) {
                                    return n;
                                }
                                this.isVOn = true;
                                bl2 = true;
                                this.numberOfDigitsLHS = n4;
                                if (n6 != 0) {
                                    this.numberOfLeadingZeros = n4 - n6 + 1;
                                    n6 = 0;
                                }
                                n4 = 0;
                                break;
                            }
                            case '.': 
                            case 'D': 
                            case 'd': {
                                if (c == '.') {
                                    this.usePeriod = true;
                                }
                                if (this.isDecimalSeparatorOn) {
                                    return n;
                                }
                                this.isDecimalSeparatorOn = true;
                                bl2 = true;
                                ++this.outputStringSize;
                                if (bl && this.isGroupingSeparatorOn) {
                                    stringBuffer.insert(0, n4 - n5);
                                }
                                this.numberOfDigitsLHS = n4;
                                if (n6 != 0) {
                                    this.numberOfLeadingZeros = n4 - n6 + 1;
                                    n6 = 0;
                                }
                                n4 = 0;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                this.useScientificNotation = true;
                                if (n + 4 > n7 || this.pattern.charAt(++n) != c || this.pattern.charAt(++n) != c || this.pattern.charAt(++n) != c) {
                                    return n;
                                }
                                this.outputStringSize += 5;
                                break;
                            }
                            default: {
                                bl3 = true;
                            }
                        }
                    } while (!bl3 && ++n < n7);
                    if (n3 >= 3) {
                        n2 = n2 << 3 | 1;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    if (!bl3) {
                        bl3 = true;
                    }
                    --n;
                    continue block21;
                }
                case '$': 
                case 'C': 
                case 'L': 
                case 'U': 
                case 'c': 
                case 'l': 
                case 'u': {
                    if (bl5) {
                        return n;
                    }
                    if (c == 'L' || c == 'l') {
                        this.outputStringSize += 10;
                    } else if (c == '$') {
                        this.useDollar = true;
                        ++this.outputStringSize;
                    } else if (c == 'C' || c == 'c') {
                        this.useIntlCurrency = true;
                        this.outputStringSize += 7;
                    } else {
                        this.useDualCurrency = true;
                        this.outputStringSize += 10;
                    }
                    if (n3 >= 3) {
                        n2 = n2 << 3 | 4;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    bl5 = true;
                    continue block21;
                }
                case 'M': 
                case 'm': {
                    if (++n < n7) {
                        c = this.pattern.charAt(n);
                        if (c != 'I' && c != 'i') {
                            return n;
                        }
                    } else {
                        return n;
                    }
                }
                case 'S': 
                case 's': {
                    if (bl4 || bl8 || bl7) {
                        return n;
                    }
                    if (c == 'S' || c == 's') {
                        this.isSignOn = true;
                    }
                    if (n3 >= 3) {
                        n2 = n2 << 3 | 2;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    bl4 = true;
                    continue block21;
                }
                case '(': {
                    if (bl9 || bl4 || bl8 || bl7) {
                        return n;
                    }
                    if (n3 >= 3) {
                        n2 = n2 << 3 | 5;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    bl9 = true;
                    continue block21;
                }
                case ')': {
                    if (!bl9) {
                        return n;
                    }
                    bl8 = true;
                    ++this.outputStringSize;
                    continue block21;
                }
                case ' ': {
                    if (bl6) {
                        return n;
                    }
                    if (n == 0 || n + 1 == n7) {
                        return n;
                    }
                    if (n3 >= 3) {
                        n2 = n2 << 3 | 3;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    bl6 = true;
                    ++this.outputStringSize;
                    continue block21;
                }
                case 'F': 
                case 'f': {
                    if (n != 0) {
                        return n;
                    }
                    if (++n < n7) {
                        c = this.pattern.charAt(n);
                        if (c != 'M' && c != 'm') {
                            return n;
                        }
                        this.isFmOn = true;
                        continue block21;
                    }
                    return n;
                }
                case 'T': 
                case 't': {
                    if (n != 0 || n7 != 3) {
                        return n;
                    }
                    c = this.pattern.charAt(n += 2);
                    if (this.pattern.charAt(n - 1) != 'M' && this.pattern.charAt(n - 1) != 'm' || c != '9' && c != 'E' && c != 'e') {
                        return n;
                    }
                    this.isTmOn = true;
                    if (c != '9') {
                        this.useScientificNotation = true;
                        n4 = 1;
                    }
                    if (n3 >= 3) {
                        n2 = n2 << 3 | 1;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    bl3 = true;
                    continue block21;
                }
                case 'P': 
                case 'p': {
                    if (bl4 || bl8 || bl7 || ++n != n7 - 1) {
                        return n;
                    }
                    c = this.pattern.charAt(n);
                    if (c != 'R' && c != 'r') {
                        return n;
                    }
                    if (n3 >= 3) {
                        n2 |= 0xC00;
                        n3 -= 3;
                    } else {
                        return n;
                    }
                    bl7 = true;
                    ++this.outputStringSize;
                    continue block21;
                }
                case 'B': 
                case 'b': {
                    if (this.isBOn) {
                        return n;
                    }
                    this.isBOn = true;
                    continue block21;
                }
                default: {
                    return n;
                }
            }
        }
        if (bl9 && !bl8) {
            return n;
        }
        if (!bl2) {
            this.numberOfDigitsLHS = n4;
            if (n6 != 0) {
                this.numberOfLeadingZeros = n4 - n6 + 1;
            }
            if (bl && this.isGroupingSeparatorOn) {
                stringBuffer.insert(0, n4 - n5);
            }
        } else {
            this.numberOfDigitsRHS = n4;
            this.numberOfTrailingZeros = n6;
        }
        if (this.useScientificNotation) {
            if (this.numberOfDigitsLHS <= 1) {
                if (this.numberOfDigitsLHS == 0) {
                    return n;
                }
            } else {
                this.numberOfDigitsLHS = 1;
            }
            if (this.numberOfLeadingZeros > 1) {
                this.numberOfLeadingZeros = 1;
            }
        }
        this.outputStringSize += this.numberOfDigitsLHS + this.numberOfDigitsRHS;
        this.internalFormat = n2;
        this.groupingSizes = !bl ? null : stringBuffer.toString();
        return ++n;
    }

    private boolean isEqual(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void printInternalFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 1; i <= 4; ++i) {
            switch (this.getNthComponent(i)) {
                case 1: {
                    stringBuffer.append("<NUMBER>");
                    continue block8;
                }
                case 2: {
                    stringBuffer.append("<SIGN>");
                    continue block8;
                }
                case 4: {
                    stringBuffer.append("<CURRENCY>");
                    continue block8;
                }
                case 3: {
                    stringBuffer.append("<SPACE>");
                    continue block8;
                }
                case 5: {
                    stringBuffer.append("<PARENTHESIS>");
                    continue block8;
                }
                case 6: {
                    stringBuffer.append("<ANGLE_BRACKET>");
                    continue block8;
                }
                default: {
                    stringBuffer.append("<NOTHING>");
                }
            }
        }
        System.out.println("Pattern: |" + this.pattern + "| ==> Internal Format: " + stringBuffer);
    }
}

