/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SourceValidationException;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class TriggerValidator
extends PlSqlValidator<Trigger> {
    public TriggerValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"baseType"})
    public void validateBaseType(Trigger trigger, Trigger trigger2) throws ValidationException {
        if (this.isSyntaxOK(trigger2) && trigger2.getBaseType() == null) {
            throw new ValidationException((DBObject)trigger2, APIBundle.get((String)"TRIGGER_BASE_TYPE_INVALID"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"baseObjectID"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"baseType"})
    public void validateBaseObjectID(Trigger trigger, Trigger trigger2) throws ValidationException {
        if (this.isSyntaxOK(trigger2) && !this.isBaseObjectIDOK(trigger2)) {
            throw new ValidationException((DBObject)trigger2, "baseObjectID", APIBundle.get((String)"TRIGGER_TABLE_OR_VIEW_INVALID"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columnIDs"})
    @DBObjectValidator.PropertyDependency(value={"baseObjectID"})
    public void validateColumnIDs(Trigger trigger, Trigger trigger2) throws ValidationException {
        if (this.isSyntaxOK(trigger2) && this.isBaseObjectIDOK(trigger2)) {
            String string = DBUtil.getDBObjectName((DBObjectID)trigger2.getBaseObjectID());
            ValidationException validationException = null;
            for (DBObjectID dBObjectID : trigger2.getColumnIDs()) {
                if (!(dBObjectID instanceof ReferenceID)) continue;
                validationException = (ValidationException)((Object)ValidationException.append(validationException, (DBException)((Object)new ValidationException((DBObject)trigger2, "columnIDs", APIBundle.format((String)"TRIGGER_COLUMN_INVALID", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)dBObjectID), string})))));
            }
            if (validationException != null) {
                throw validationException;
            }
        }
    }

    private boolean isBaseObjectIDOK(Trigger trigger) {
        boolean bl = true;
        if (trigger.getBaseType() != null) {
            DBObject dBObject;
            String string = trigger.getBaseType() == Trigger.BaseType.TABLE ? "TABLE" : (trigger.getBaseType() == Trigger.BaseType.VIEW ? "VIEW" : (trigger.getBaseType() == Trigger.BaseType.SCHEMA ? "SCHEMA" : null));
            DBObjectID dBObjectID = trigger.getBaseObjectID();
            String string2 = dBObjectID == null ? null : (dBObjectID instanceof BaseObjectID ? (dBObjectID instanceof ReferenceID && !(trigger.getID() instanceof TemporaryObjectID) ? "UNSPECIFIED_TYPE" : dBObjectID.getType()) : (dBObjectID instanceof TemporaryObjectID ? ((dBObject = ((TemporaryObjectID)dBObjectID).getDBObject()) == null ? null : dBObject.getType()) : null));
            if (ModelUtil.areDifferent((Object)string, string2)) {
                bl = false;
            }
        }
        return bl;
    }

    @DBObjectValidator.PropertyValidator(value={"timing"})
    public void validateTiming(Trigger trigger, Trigger trigger2) throws ValidationException {
        List list;
        if (this.isSyntaxOK(trigger2) && (list = Trigger.getEvents((Trigger.BaseType)trigger2.getBaseType(), (Trigger.Timing)trigger2.getTiming())).size() == 0) {
            throw new ValidationException((DBObject)trigger2, APIBundle.get((String)"TRIGGER_TIMING_INVALID"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"events"})
    @DBObjectValidator.PropertyDependency(value={"baseType", "timing"})
    public void validateEvents(ValidationContext<Trigger> validationContext) throws ValidationException {
        Trigger trigger = (Trigger)validationContext.getUpdatedObject();
        if (this.isSyntaxOK(trigger)) {
            List list;
            String[] stringArray = trigger.getEvents();
            if (stringArray == null || stringArray.length == 0) {
                throw new ValidationException((DBObject)trigger, APIBundle.get((String)"TRIGGER_NO_EVENTS_ERROR"));
            }
            if (validationContext.getLevel() == ValidationLevel.FULL && (list = Trigger.getEvents((Trigger.BaseType)trigger.getBaseType(), (Trigger.Timing)trigger.getTiming())).size() > 0) {
                for (String string : stringArray) {
                    if (list.contains(string)) continue;
                    throw new ValidationException((DBObject)trigger, APIBundle.format((String)"TRIGGER_EVENT_INVALID", (Object[])new Object[]{string}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"referencingNewAs", "referencingOldAs"}, path=false, level=ValidationLevel.FULL)
    public void validateReferencingAs(Trigger trigger, Trigger trigger2) throws ValidationException {
        if (trigger2 != null && this.isSyntaxOK(trigger2)) {
            String string;
            String string2 = trigger2.getReferencingNewAs();
            if (string2 == null) {
                string2 = "NEW";
            }
            if ((string = trigger2.getReferencingOldAs()) == null) {
                string = "OLD";
            }
            if (string.equals(string2)) {
                throw new ValidationException((DBObject)trigger2, APIBundle.format((String)"TRIGGER_DUPLICATE_REFERENCING", (Object[])new Object[]{string2}));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DBObjectValidator.PropertyValidator(value={"source"}, level=ValidationLevel.FULL)
    public void validateSource(Trigger trigger, Trigger trigger2) throws ValidationException {
        super.validateSource(trigger, trigger2);
        ValidationException validationException = null;
        if (trigger2.getBaseType() == Trigger.BaseType.TABLE && trigger2.getBaseObjectID() != null) {
            Table table = null;
            try {
                table = (Table)trigger2.getBaseObjectID().resolveID();
            }
            catch (DBException dBException) {
                table = null;
                this.logException(dBException, Level.WARNING);
            }
            if (table != null) {
                ArrayList<Column> arrayList = new ArrayList<Column>();
                ArrayList<Column> arrayList2 = new ArrayList<Column>();
                DBObjectID dBObjectID = trigger2.getID();
                for (Column column : table.getColumns()) {
                    if (!dBObjectID.equals(column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER"))) continue;
                    arrayList.add(column);
                }
                List<ColumnSequenceProcessor.ColumnInfo> list = ColumnSequenceProcessor.getColumnInfos(trigger2.getSource(), this.getProvider());
                if (list.size() > 0 || arrayList.size() > 0) {
                    if (trigger2.isStatementLevel()) {
                        validationException = this.addColSeqException(validationException, trigger2, 0, 0, APIBundle.get((String)"COLSEQ_TRIGGER_VALIDATION_ROW_LEVEL"));
                    }
                    int n = 0;
                    for (String object : trigger2.getEvents()) {
                        if (!"INSERT".equals(object)) continue;
                        n = 1;
                        break;
                    }
                    if (n == 0) {
                        validationException = this.addColSeqException(validationException, trigger2, 0, 0, APIBundle.get((String)"COLSEQ_TRIGGER_VALIDATION_INSERT"));
                    }
                    for (Column column : arrayList) {
                        ColumnSequenceProcessor.ColumnInfo columnInfo2 = null;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ColumnSequenceProcessor.ColumnInfo columnInfo = (ColumnSequenceProcessor.ColumnInfo)iterator.next();
                            if (!column.getName().equals(columnInfo.getColumnName())) continue;
                            columnInfo2 = columnInfo;
                            break;
                        }
                        if (columnInfo2 == null) {
                            validationException = this.addColSeqException(validationException, trigger2, 0, 0, APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_COLUMN_NOT_SET", (Object[])new Object[]{column.getName()}));
                            continue;
                        }
                        arrayList2.add(column);
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ColumnSequenceProcessor.ColumnInfo columnInfo3 = (ColumnSequenceProcessor.ColumnInfo)iterator.next();
                        Column columnInfo4 = null;
                        for (Column column : arrayList) {
                            if (!column.getName().equals(columnInfo3.getColumnName())) continue;
                            columnInfo4 = column;
                            break;
                        }
                        if (columnInfo4 != null) continue;
                        validationException = this.addColSeqException(validationException, trigger2, columnInfo3.getColumnStart(), columnInfo3.getColumnEnd(), APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_COLUMN_SET", (Object[])new Object[]{columnInfo3.getColumnName()}));
                    }
                    for (Column column : arrayList2) {
                        void var14_34;
                        DBObjectID dBObjectID2 = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
                        boolean bl = Boolean.TRUE.equals(column.getProperty("ColumnSequenceExpander.TriggerNullCheck"));
                        Object var14_32 = null;
                        Iterator iterator2 = list.iterator();
                        while (iterator2.hasNext()) {
                            ColumnSequenceProcessor.ColumnInfo columnInfo = (ColumnSequenceProcessor.ColumnInfo)iterator2.next();
                            if (!column.getName().equals(columnInfo.getColumnName())) continue;
                            ColumnSequenceProcessor.ColumnInfo columnInfo2 = columnInfo;
                            break;
                        }
                        if (bl != var14_34.isCheckForNull()) {
                            validationException = this.addColSeqException(validationException, trigger2, var14_34.getNullCheckStart(), var14_34.getNullCheckEnd(), APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_NULL_CHECK_MISMATCH", (Object[])new Object[]{column.getName()}));
                        }
                        if (var14_34.getSequenceName().equals(DBUtil.getDBObjectName((DBObjectID)dBObjectID2))) continue;
                        validationException = this.addColSeqException(validationException, trigger2, var14_34.getSequenceStart(), var14_34.getSequenceEnd(), APIBundle.format((String)"COLSEQ_TRIGGER_VALIDATION_SEQUENCE_MISMATCH", (Object[])new Object[]{column.getName()}));
                    }
                }
            }
        }
        if (validationException != null) {
            throw validationException;
        }
    }

    private ValidationException addColSeqException(ValidationException validationException, Trigger trigger, int n, int n2, String string) {
        return this.addException(validationException, trigger, SourceValidationException.ErrorType.COLSEQ, n, n2, string);
    }

    @Override
    public CascadeAction cascadeDelete(DBObject dBObject, Trigger trigger) throws DBException {
        CascadeAction cascadeAction;
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObject instanceof Column) {
            boolean bl = false;
            for (DBObjectID dBObjectID2 : trigger.getColumnIDs()) {
                if (!dBObjectID2.equals(dBObject.getID(), true)) continue;
                bl = true;
                break;
            }
            cascadeAction = bl ? this.cascadeDelete(dBObjectID, (DBObject)trigger, (DBObject)trigger) : super.cascadeDelete(dBObject, trigger);
        } else {
            cascadeAction = ModelUtil.areEqual((Object)dBObjectID, (Object)trigger.getBaseObjectID()) ? CascadeAction.DELETE : super.cascadeDelete(dBObject, trigger);
        }
        return cascadeAction;
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    @Override
    public Collection<String> listAlwaysValidProperties() {
        HashSet<String> hashSet = new HashSet<String>(super.listAlwaysValidProperties());
        hashSet.add("enabled");
        hashSet.add("statementLevel");
        hashSet.add("referencingOldAs");
        hashSet.add("referencingNewAs");
        hashSet.add("whenClause");
        return hashSet;
    }
}

