/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.RelationValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;

public class TableValidator<T extends Table>
extends RelationValidator<T> {
    public TableValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"TableType"})
    public void validateTableType(ValidationContext<T> validationContext) throws ValidationException {
        Table table = (Table)validationContext.getUpdatedObject();
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
        if (tableType != Table.TableType.NORMAL) {
            Collection collection;
            boolean bl = true;
            if (this.supportsOtherTableTypes() && (collection = this.getProvider().getPropertyManager().getAllowedPropertyValues(validationContext.getOriginalObject(), (DBObject)table, "TableType")) != null) {
                boolean bl2 = bl = !collection.contains(tableType);
            }
            if (bl) {
                throw new ValidationException((DBObject)table, APIBundle.format((String)"UNSUPPORTED_TABLE_TYPE", (Object[])new Object[]{tableType == null ? "" : tableType.toString()}));
            }
        }
    }

    protected boolean supportsOtherTableTypes() {
        return false;
    }

    protected CascadeAction removeReference(DBObjectID dBObjectID, DBObject dBObject, PropertyInfo propertyInfo) throws DBException {
        CascadeAction cascadeAction = CascadeAction.NONE;
        String string = propertyInfo.getPropertyName();
        if (dBObject instanceof Column && ColumnSequenceProcessor.isColumnSequenceProp(string)) {
            cascadeAction = CascadeAction.UPDATE;
            ColumnSequenceProcessor.clearColumnSequenceProps((Column)dBObject);
        } else {
            cascadeAction = super.removeReference(dBObjectID, dBObject, propertyInfo);
        }
        return cascadeAction;
    }

    @Override
    public CascadeAction cascadeDelete(DBObject dBObject, T t) throws DBException {
        CascadeAction cascadeAction;
        CascadeAction cascadeAction2 = CascadeAction.NONE;
        if (dBObject instanceof Column) {
            cascadeAction = t.getIndexes();
            int n = ((Index[])cascadeAction).length;
            for (int i = 0; i < n; ++i) {
                CascadeAction cascadeAction3 = cascadeAction[i];
                boolean bl = false;
                ArrayList<IndexObject> arrayList = new ArrayList<IndexObject>();
                for (IndexObject indexObject : cascadeAction3.getColumnExpressions()) {
                    if (DBUtil.findUsagesIn((DBObject)dBObject, (DBObject)indexObject).isEmpty()) {
                        arrayList.add(indexObject);
                        continue;
                    }
                    bl = true;
                }
                if (!bl) continue;
                cascadeAction2 = CascadeAction.UPDATE;
                if (arrayList.isEmpty()) {
                    t.removeIndex((Index)cascadeAction3);
                    continue;
                }
                cascadeAction3.setColumnExpressions(arrayList.toArray(new IndexObject[arrayList.size()]));
            }
        }
        return (cascadeAction = super.cascadeDelete(dBObject, t)).compareTo((Enum)cascadeAction2) > 0 ? cascadeAction : cascadeAction2;
    }

    @Override
    protected CascadeAction cascadePropertyChange(Difference difference, String string, Object object, Object object2, T t) throws DBException {
        DBObject dBObject;
        CascadeAction cascadeAction = super.cascadePropertyChange(difference, string, object, object2, t);
        if ("columnIDs".equals(string) && (dBObject = (DBObject)difference.getOriginalObject()) instanceof UniqueConstraint) {
            Difference difference2 = difference.getChildDifference("columnIDs");
            if (difference2 == null) {
                this.getLogger().warning("No difference found for columnIDs on updated UK");
            } else {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
                TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
                DBObjectID[] dBObjectIDArray = (DBObjectID[])difference2.getUpdatedObject();
                for (Object object3 : difference2.getChildren()) {
                    int n = object3.getIndexOfOriginalObject();
                    int n2 = object3.getIndexOfUpdatedObject();
                    if (n2 < 0) {
                        treeSet2.add(n);
                        continue;
                    }
                    if (n < 0) {
                        treeSet.add(n2);
                        continue;
                    }
                    if (n == n2) continue;
                    treeMap.put(n2, n);
                }
                treeSet2.removeAll(treeSet);
                treeSet.removeAll(treeSet2);
                if (!treeMap.isEmpty() || !treeSet2.isEmpty()) {
                    Object object3;
                    Collection collection = DBUtil.findUsagesIn((DBObject)dBObject, t);
                    object3 = collection.iterator();
                    while (object3.hasNext()) {
                        DBObject dBObject2 = (DBObject)object3.next();
                        if (!(dBObject2 instanceof FKConstraint)) continue;
                        DBObjectID[] dBObjectIDArray2 = ((FKConstraint)dBObject2).getColumnIDs();
                        DBObjectID[] dBObjectIDArray3 = new DBObjectID[dBObjectIDArray.length];
                        for (int i = 0; i < dBObjectIDArray.length; ++i) {
                            int n = i;
                            if (treeMap.containsKey(i)) {
                                n = (Integer)treeMap.get(i);
                            } else if (treeSet.contains(i)) {
                                n = -1;
                            }
                            if (n < 0 || n >= dBObjectIDArray2.length) continue;
                            dBObjectIDArray3[i] = dBObjectIDArray2[n];
                        }
                        ((FKConstraint)dBObject2).setColumnIDs(dBObjectIDArray3);
                        cascadeAction = CascadeAction.UPDATE;
                    }
                }
            }
        }
        return cascadeAction;
    }

    @Override
    protected boolean cascadeColumnRename(Column column, T t) {
        boolean bl = super.cascadeColumnRename(column, t);
        for (Index index : t.getIndexes()) {
            for (IndexObject indexObject : index.getColumnExpressions()) {
                SQLFragment sQLFragment = indexObject.getExpression();
                if (DBUtil.findUsagesIn((DBObject)column, (DBObject)sQLFragment).isEmpty()) continue;
                indexObject.setExpressionSource(sQLFragment.getSQLText());
                indexObject.setExpression(sQLFragment);
                bl = true;
            }
        }
        return bl;
    }

    public Set<String> getCascadeProperties() {
        Set set = super.getCascadeProperties();
        set.add("columnIDs");
        return set;
    }
}

