/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class IndexValidator
extends SchemaObjectValidator<Index> {
    public IndexValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"table"})
    public void validateTable(Index index, Index index2) throws ValidationException {
        if (index2.getTable() == null) {
            throw new ValidationException((DBObject)index2, APIBundle.get((String)"INDEX_ERROR_ORPHANED_INDEX"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columnExpressions"})
    public void validateExpressions(ValidationContext<Index> validationContext) throws ValidationException {
        Index index = (Index)validationContext.getUpdatedObject();
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        if (indexObjectArray.length <= 0) {
            throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_NO_COLUMN_EXPR"));
        }
        ValidationException validationException = null;
        for (IndexObject indexObject : indexObjectArray) {
            String string = indexObject.getExpressionSource();
            if (ModelUtil.hasLength((String)string)) continue;
            validationException = (ValidationException)((Object)ValidationException.append(validationException, (DBException)((Object)new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_INVALID_COLUMN_EXPRESSION", (Object[])new Object[]{index.getName(), ""})))));
        }
        if (validationException != null) {
            throw validationException;
        }
        if (validationContext.getLevel() == ValidationLevel.FULL) {
            this.checkColumnExpressions(index);
            this.checkDefinitionIsUnique(index);
        }
    }

    protected void validateColumnType(Index index, Column column) throws ValidationException {
    }

    protected void checkColumnExpressions(Index index) throws ValidationException {
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        Table table = index.getTable();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < indexObjectArray.length; ++i) {
            String string = indexObjectArray[i].getExpressionSource();
            if (!ModelUtil.hasLength((String)string)) continue;
            this.validateIndexExpression(index, indexObjectArray[i], string);
            if (!this.columnMustBeUnique(table, index, indexObjectArray[i])) continue;
            String string2 = this.getProvider().getInternalName(string);
            if (hashSet.contains(string2)) {
                throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_DUPLICATE_COLUMN", (Object[])new Object[]{string2, index.getName()}));
            }
            hashSet.add(string2);
        }
    }

    protected void validateIndexExpression(Index index, IndexObject indexObject, String string) throws ValidationException {
        boolean bl;
        Table table = index.getTable();
        SQLFragment sQLFragment = null;
        try {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)indexObject);
            DBUtil.ensureObjectBuilt((DBObject)indexObject, (String[])new String[]{"expression"});
            sQLFragment = indexObject.getExpression();
        }
        catch (DBException dBException) {
            throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_INVALID_COLUMN_EXPRESSION_PARSER_ERROR", (Object[])new Object[]{string, dBException.getMessage()}));
        }
        boolean bl2 = bl = table instanceof MaterializedView && table.getColumns().length == 0;
        if (!bl && sQLFragment != null) {
            DBObjectProvider dBObjectProvider = this.getProvider();
            for (String[] stringArray : ParserUtils.getColumnNames((SQLFragment)sQLFragment)) {
                Column column = null;
                String string2 = null;
                if (stringArray.length > 0) {
                    string2 = dBObjectProvider.getInternalName(stringArray[0]);
                    column = (Column)DBUtil.findChildByName((DBObject)table, (String)"columns", (String)string2, (DBObjectProvider)dBObjectProvider);
                }
                if (column == null) {
                    throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_COLUMN_NOT_IN_TABLE", (Object[])new Object[]{string2, table.getName()}));
                }
                this.validateColumnType(index, column);
            }
        }
    }

    protected boolean columnMustBeUnique(Table table, Index index, IndexObject indexObject) {
        return true;
    }

    protected void checkDefinitionIsUnique(Index index) throws ValidationException {
        if (index.getIndexType() != Index.IndexType.DOMAIN) {
            Table table = index.getTable();
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            Index index2 = (Index)TemporaryObjectID.findOriginalObject((DBObject)index);
            if (index2 == null) {
                index2 = index;
            }
            for (Index index3 : table.getIndexes()) {
                IndexObject[] indexObjectArray2;
                Index index4 = (Index)TemporaryObjectID.findOriginalObject((DBObject)index3);
                if (index4 == null) {
                    index4 = index3;
                }
                if (index3 == index || index4 == index2 || index3.getIndexType() == Index.IndexType.DOMAIN || indexObjectArray.length != (indexObjectArray2 = index3.getColumnExpressions()).length) continue;
                boolean bl = false;
                for (int i = 0; i < indexObjectArray.length; ++i) {
                    if (this.areEqual(indexObjectArray[i], indexObjectArray2[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new ValidationException((DBObject)index, APIBundle.format((String)"INDEX_ERROR_DUPLICATE_INDEX_DEFINITION", (Object[])new Object[]{index.getName(), index3.getName()}));
            }
        }
    }

    private boolean areEqual(IndexObject indexObject, IndexObject indexObject2) {
        String string;
        String string2;
        boolean bl;
        boolean bl2 = !IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType());
        boolean bl3 = bl = !IndexObject.OrderType.DESC.equals((Object)indexObject2.getOrderType());
        boolean bl4 = bl2 != bl ? false : ((string2 = indexObject.getExpressionSource()) == (string = indexObject2.getExpressionSource()) ? true : (string2 == null || string == null ? false : string2.replaceAll("\\s", "").toUpperCase().equals(string.replaceAll("\\s", "").toUpperCase())));
        return bl4;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("keyCompression");
        collection.add("parallelDegree");
        collection.add("reverse");
        collection.add("domainIndextype");
        collection.add("domainIndextypeOpStatus");
        collection.add("domainIndextypeParameters");
        return collection;
    }
}

