/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sybase.AdaptiveServerDDLGenerator;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15DatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabase;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseImpl;

public class AdaptiveServerEnterpriseDescriptor
extends JdbcDatabaseDescriptor {
    private static final String YEN = "00a5";
    private static List s_compatibleTypesLists;
    public static final int MAX_NAME_LENGTH = 30;
    public static final int MAX_TEMP_NAME_LENGTH = 13;
    public static final Set RESERVED_WORDS;

    public AdaptiveServerEnterpriseDescriptor(Class<? extends AdaptiveServerEnterpriseDatabase> clazz) {
        super(clazz);
    }

    @Override
    public int getCasePolicy() {
        return 3;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 30;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        boolean bl = true;
        String string3 = "";
        try {
            AdaptiveServerEnterpriseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)30, (String)"_#@?$00a5", (boolean)false, (Set)((Set)this.getReservedWords()), (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        }
        catch (InvalidNameException invalidNameException) {
            bl = false;
            string3 = invalidNameException.getMessage();
        }
        if (bl) {
            char c = string2.charAt(0);
            if (c == '\"') {
                if (string2.length() > 30) {
                    throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_TOO_LONG"));
                }
                if (string2.charAt(1) == '#') {
                    throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
                }
            } else {
                if (!Character.isAlphabetic(string2.codePointAt(0)) && c != '_' && c != '#' && c != '@' || string2.startsWith("@@")) {
                    throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
                }
                if (c == '#') {
                    int n = string2.codePointCount(0, string2.length());
                    if (n < 2) {
                        throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_NO_NAME"));
                    }
                    if (n > 13) {
                        throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_TOO_LONG"));
                    }
                }
            }
        }
        if (!bl) {
            throw new InvalidNameException(null, string3);
        }
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new AdaptiveServerDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    private static void initialiseCompatibleTypes() {
        s_compatibleTypesLists = new ArrayList();
        String[] stringArray = new String[]{"CHAR", "NCHAR", "VARCHAR", "NVARCHAR"};
        String[] stringArray2 = new String[]{"UNICHAR", "UNIVARCHAR"};
        s_compatibleTypesLists.add(new ArrayList<String>(Arrays.asList(stringArray)));
        s_compatibleTypesLists.add(new ArrayList<String>(Arrays.asList(stringArray2)));
    }

    protected boolean isValidFKDataTypeImpl(DataType dataType, DataType dataType2) {
        boolean bl = super.isValidFKDataTypeImpl(dataType, dataType2);
        if (!bl) {
            if (s_compatibleTypesLists == null) {
                AdaptiveServerEnterpriseDescriptor.initialiseCompatibleTypes();
            }
            for (List list : s_compatibleTypesLists) {
                if (list == null || !list.contains(dataType.getName()) || !list.contains(dataType2.getName())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public int getDatabaseVersion() {
        Class clazz = this.getDatabaseClass();
        int n = AdaptiveServerEnterprise15DatabaseImpl.class.isAssignableFrom(clazz) ? 150 : (AdaptiveServerEnterpriseDatabaseImpl.class.isAssignableFrom(clazz) ? 120 : 0);
        return n;
    }

    @Override
    public String getDatabaseType() {
        return "Sybase";
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        int n = this.getDatabaseVersion();
        if (n == 120) {
            dataTypeCache.registerDataType("BINARY");
            dataTypeCache.registerDataType("BIT");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DATETIME");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("DOUBLE PRECISION");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("IMAGE");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("MONEY");
            dataTypeCache.registerDataType("NCHAR");
            dataTypeCache.registerDataType("NUMERIC");
            dataTypeCache.registerDataType("NVARCHAR");
            dataTypeCache.registerDataType("REAL");
            dataTypeCache.registerDataType("SMALLDATETIME");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("SMALLMONEY");
            dataTypeCache.registerDataType("SYSNAME");
            dataTypeCache.registerDataType("TEXT");
            dataTypeCache.registerDataType("TIME");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("TINYINT");
            dataTypeCache.registerDataType("UNICHAR");
            dataTypeCache.registerDataType("UNIVARCHAR");
            dataTypeCache.registerDataType("VARBINARY");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataTypeSynonym("DEC", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("INTEGER", "INT");
            dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR", "NCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER", "NCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR");
        }
    }

    static {
        RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "ARITH_OVERFLOW", "AS", "ASC", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHAR_CONVERT", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COMMIT", "COMPUTE", "CONFIRM", "CONNECT", "CONSTRAINT", "CONTINUE", "CONTROLROW", "CONVERT", "COUNT", "CREATE", "CURRENT", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DESC", "DETERMINISTIC", "DISK", "DISTINCT", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ENDTRAN", "ERRLVL", "ERRORDATA", "ERROREXIT", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXP_ROW_SIZE", "EXTERNAL", "FETCH", "FILLFACTOR", "FOR", "FOREIGN", "FROM", "FUNC", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_GAP", "IDENTITY_INSERT", "IDENTITY_START", "IF", "IN", "INDEX", "INOUT", "INSERT", "INSTALL", "INTERSECT", "INTO", "IS", "ISOLATION", "JAR", "JOIN", "KEY", "KILL", "LEVEL", "LIKE", "LINENO", "LOAD", "LOCK", "MAX", "MAX_ROWS_PER_PAGE", "MIN", "MIRROR", "MIRROREXIT", "MODIFY", "NATIONAL", "NOHOLDLOCK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "NUMERIC_TRUNCATION", "OF", "OFF", "OFFSETS", "ON", "ONCE", "ONLINE", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OVER", "PARTITION", "PERCENT", "PERM", "PERMANENT", "PLAN", "PRECISION", "PREPARE", "PRIMARY", "PRINT", "PRIVILEGES", "PROC", "PROCEDURE", "PROCESSEXIT", "PROXY_TABLE", "PUBLIC", "QUIESCE", "RAISERROR", "READ", "READPAST", "READTEXT", "RECONFIGURE", "REFERENCES", "REMOVE", "REORG", "REPLACE", "REPLICATION", "RESERVEPAGEGAP", "RETURN", "RETURNS", "REVOKE", "ROLE", "ROLLBACK", "ROWCOUNT", "ROWS", "RULE", "SAVE", "SCHEMA", "SELECT", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "STRINGSIZE", "STRIPE", "SUM", "SYB_IDENTITY", "SYB_RESTREE", "SYB_TERMINATE", "TABLE", "TEMP", "TEMPORARY", "TEXTSIZE", "TO", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UNPARTITION", "UPDATE", "USE", "USER", "USER_OPTION", "USING", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WORK", "WRITETEXT"));
    }
}

