/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.sqlite.SQLiteDDLSupport;
import oracle.javatools.db.sqlite.SQLiteDDLType;
import oracle.javatools.db.sqlite.SQLiteDatabase;

final class SQLiteDDLGenerator
extends BundleDDLGenerator<SQLiteDDLType> {
    SQLiteDDLGenerator(Class<? extends SQLiteDatabase> clazz, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider, new String[]{"/oracle/javatools/db/sqlite/SQLiteDDL.properties"});
        this.registerTokens();
    }

    protected void registerTokens() {
        for (Map.Entry<String, TokenGenerator> entry : SQLiteDDLSupport.getInstance().getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator(entry.getKey(), entry.getValue());
        }
    }

    protected SQLiteDDLType getDDLType(String string) {
        return SQLiteDDLType.getDDLType(string);
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        if (dBObject2 instanceof Trigger && "baseType".equals(string)) {
            ArrayList<Trigger.BaseType> arrayList = new ArrayList<Trigger.BaseType>();
            arrayList.add(Trigger.BaseType.TABLE);
            arrayList.add(Trigger.BaseType.VIEW);
            return arrayList;
        }
        if (dBObject2 instanceof Index && "indexType".equals(string)) {
            ArrayList<Index.IndexType> arrayList = new ArrayList<Index.IndexType>();
            arrayList.add(Index.IndexType.NORMAL);
            arrayList.add(Index.IndexType.UNIQUE);
            return arrayList;
        }
        if ("deferrableState".equals(string) && dBObject2 instanceof Constraint && !(dBObject2 instanceof FKConstraint)) {
            return Collections.emptyList();
        }
        return super.getAllowedPropertyValues(dBObject, dBObject2, string);
    }
}

