/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlSourceObjectBuilder;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Tuple;

public class TriggerBuilder
extends PlSqlSourceObjectBuilder<Trigger> {
    private String m_triggerNew;
    private String m_triggerOld;

    public TriggerBuilder(AbstractDBObjectProvider abstractDBObjectProvider) {
        super(abstractDBObjectProvider, "TRIGGER");
    }

    @Override
    protected void buildObjectProperties(Trigger trigger, PlSqlParser plSqlParser) throws CancelledException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PlSqlToken plSqlToken;
        Object object5;
        Object object6;
        Object object7 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "timing");
        if (object7 != null) {
            object6 = plSqlParser.getTokenAtOffset(plSqlParser.getStartOffset(object7));
            if (object6.matches("before")) {
                trigger.setTiming(Trigger.Timing.BEFORE);
            } else if (object6.matches("after")) {
                trigger.setTiming(Trigger.Timing.AFTER);
            } else if (object6.matches("instead")) {
                trigger.setTiming(Trigger.Timing.INSTEAD_OF);
            }
        }
        if ((object6 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "events")) != null) {
            object5 = new ArrayList();
            int n = plSqlParser.getEndOffset(object6);
            object4 = plSqlToken = plSqlParser.getTokenAtOffset(plSqlParser.getStartOffset(object6));
            object3 = plSqlToken;
            while (plSqlToken != null && plSqlToken.getType() != Token.Type.END_MARKER) {
                if (object4 == null) {
                    object4 = plSqlToken;
                }
                if (plSqlToken.matches("or") || plSqlToken.matches("on") || plSqlToken.getStart() > n) {
                    if (object4.matches("UPDATE") && object3 != object4 && ((PlSqlToken)object4.getNextCodeToken()).matches("OF")) {
                        object3 = object4;
                    }
                    object5.add(object4.getSource(true, (Token)object3));
                    if (!plSqlToken.matches("or")) break;
                    object4 = null;
                }
                object3 = plSqlToken;
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            }
            trigger.setEvents(object5.toArray(new String[object5.size()]));
        }
        if ((object5 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "baseObjectID")) != null) {
            Object object8;
            Trigger.BaseType baseType = null;
            plSqlToken = null;
            object4 = null;
            object3 = new ArrayList();
            object2 = null;
            Relation relation = null;
            Tuple tuple = new ArrayList();
            String string = null;
            baseType = null;
            PlSqlToken plSqlToken2 = plSqlParser.getTokenAtOffset(plSqlParser.getStartOffset(object5));
            if (plSqlToken2.matches("ON")) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
            }
            if (plSqlToken2.matches("NESTED")) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken(2);
                string = this.getProvider().getInternalName(plSqlToken2.getSource());
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken(2);
            }
            if (plSqlToken2.getNextCodeToken() != null && ((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(".")) {
                object8 = this.getProvider().getInternalName(plSqlToken2.getSource());
                try {
                    plSqlToken = this.getProvider().getSchema((String)object8);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (plSqlToken == null) {
                    plSqlToken = new Schema((String)object8);
                    plSqlToken.setID((DBObjectID)new ReferenceID((DBObject)plSqlToken));
                }
                tuple.add(plSqlToken.getName());
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken(2);
            } else {
                plSqlToken = trigger.getSchema();
            }
            if (plSqlToken2.matches("SCHEMA")) {
                baseType = Trigger.BaseType.SCHEMA;
                object4 = plSqlToken == null ? null : plSqlToken.getID();
                this.buildReference(plSqlParser, (PlSqlCodeFragment)trigger, (List<String>)tuple, plSqlToken2.getStart(), plSqlToken2.getEnd(), true);
            } else if (plSqlToken2.matches("DATABASE")) {
                baseType = Trigger.BaseType.DATABASE;
                object4 = null;
            } else {
                object2 = this.getProvider().getInternalName(plSqlToken2.getSource());
                try {
                    relation = (Relation)this.getProvider().getObject("TABLE", (Schema)plSqlToken, (String)object2);
                    if (relation == null) {
                        relation = (Relation)this.getProvider().getObject("VIEW", (Schema)plSqlToken, (String)object2);
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (relation == null && trigger.getBaseObjectID() instanceof TemporaryObjectID) {
                    object8 = null;
                    try {
                        object8 = trigger.getBaseObjectID().resolveID();
                        if (object8 != null && object8.getName().equals(object2) && ("TABLE".equals(object8.getType()) || "VIEW".equals(object8.getType()))) {
                            relation = (Relation)object8;
                        }
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                if (relation == null) {
                    if (trigger.getTiming() == Trigger.Timing.INSTEAD_OF) {
                        baseType = Trigger.BaseType.VIEW;
                        object8 = "VIEW";
                    } else {
                        baseType = Trigger.BaseType.TABLE;
                        object8 = "TABLE";
                    }
                    object4 = new ReferenceID((String)object8, (Schema)plSqlToken, (String)object2);
                } else {
                    object4 = relation.getID();
                    baseType = relation instanceof Table ? Trigger.BaseType.TABLE : Trigger.BaseType.VIEW;
                }
                tuple.add(object2);
                this.buildReference(plSqlParser, (PlSqlCodeFragment)trigger, (List<String>)tuple, plSqlToken2.getStart(), plSqlToken2.getEnd(), true);
                object8 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "columnIDs");
                if (object8 != null) {
                    String string2 = ",";
                    PlSqlToken plSqlToken3 = plSqlParser.getTokenAtOffset(plSqlParser.getStartOffset(object8));
                    int n = plSqlParser.getEndOffset(object8);
                    while (plSqlToken3.getStart() <= n) {
                        if (string2.equals(",")) {
                            Column column;
                            String string3 = this.getProvider().getInternalName(plSqlToken3.getSource());
                            ReferenceID referenceID = null;
                            if (relation != null && (column = (Column)DBUtil.findChildByName((DBObject)relation, (String)"columns", (String)string3, (DBObjectProvider)this.getProvider())) != null) {
                                referenceID = column.getID();
                                tuple.clear();
                                tuple.add(object2);
                                tuple.add(column.getName());
                                this.buildReference(plSqlParser, (PlSqlCodeFragment)trigger, (List<String>)tuple, plSqlToken3.getStart(), plSqlToken3.getEnd(), true);
                            }
                            if (referenceID == null) {
                                referenceID = new ReferenceID("COLUMN", (DBObjectID)object4, string3, null, null);
                            }
                            object3.add(referenceID);
                        }
                        string2 = plSqlToken3.getSource();
                        plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                    }
                }
            }
            trigger.setBaseType(baseType);
            trigger.setBaseObjectID((DBObjectID)object4);
            trigger.setColumnIDs(object3.toArray(new DBObjectID[object3.size()]));
        }
        this.m_triggerOld = "OLD";
        this.m_triggerNew = "NEW";
        Object object9 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "referencingNewAs");
        if (object9 != null) {
            int n = plSqlParser.getEndOffset(object9);
            object4 = plSqlParser.getTokenAtOffset(plSqlParser.getStartOffset(object9));
            while (object4.getStart() <= n && object4.getNextCodeToken(2) != null) {
                if (object4.matches("OLD") && ((PlSqlToken)object4.getNextCodeToken()).matches("AS")) {
                    object4 = (PlSqlToken)((PlSqlToken)object4.getNextCodeToken()).getNextCodeToken();
                    object3 = this.getProvider().getInternalName(object4.getSource());
                    trigger.setReferencingOldAs((String)object3);
                    this.m_triggerOld = object3;
                } else if (object4.matches("NEW") && ((PlSqlToken)object4.getNextCodeToken()).matches("AS")) {
                    object4 = (PlSqlToken)((PlSqlToken)object4.getNextCodeToken()).getNextCodeToken();
                    object3 = this.getProvider().getInternalName(object4.getSource());
                    trigger.setReferencingNewAs((String)object3);
                    this.m_triggerNew = object3;
                }
                object4 = (PlSqlToken)object4.getNextCodeToken();
            }
        }
        trigger.setStatementLevel((object = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "statementLevel")) == null);
        object4 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "whenClause");
        if (object4 != null) {
            object3 = plSqlParser.getTokenAtOffset(plSqlParser.getStartOffset(object4));
            if (object3.matches("WHEN")) {
                object3 = (PlSqlToken)object3.getNextCodeToken();
            }
            object2 = plSqlParser.getTokenAtOffset(plSqlParser.getEndOffset(object4));
            if (this.getProvider().getDescriptor().getDatabaseType().equals("Oracle Database") && object3.matches("(") && object2.matches(")") && object3.getNextCodeToken() != object2) {
                object3 = (PlSqlToken)object3.getNextCodeToken();
                object2 = (PlSqlToken)object2.getPrevCodeToken();
            }
            trigger.setWhenClause(object3.getSource(false, (Token)object2));
        }
        if ((object3 = plSqlParser.getPropertyNode((DBObjectPlSqlFragment)trigger, "code")) != null) {
            object2 = trigger.getSource().substring(plSqlParser.getStartOffset(object3));
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
            trigger.setCode((String)object2);
        }
        object2 = new PlSqlSearch("alter trigger ?. <state {enable|disable}>");
        for (Tuple tuple : plSqlParser.getAlterStatements()) {
            if (!object2.matches((PlSqlToken)tuple.getFirst())) continue;
            trigger.setEnabled(object2.getNamedMatchStartToken("state").matches("enabled"));
        }
    }
}

