/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.Function;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class PlSqlSourceObjectBuilder<T extends PlSqlBlock>
extends AbstractPlSqlBuilder<T> {
    private PlSqlParser m_parser;
    private final Holder<Boolean> m_deferredHolder = new Holder((Object)Boolean.FALSE);
    private PlSqlSourceObject m_deferredPSO;

    public PlSqlSourceObjectBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        super(abstractDBObjectProvider, string);
    }

    @Override
    public PlSqlParser getParser(T t) throws CancelledException {
        SchemaObject schemaObject;
        this.checkInterruptOrCancel(t);
        final Holder holder = new Holder((Object)this.m_parser);
        if (holder.get() == null && (schemaObject = DBUtil.getSchemaObject(t)) instanceof PlSqlSourceObject) {
            Runnable runnable = new Runnable((DBObject)schemaObject){
                final /* synthetic */ DBObject val$top;
                {
                    this.val$top = dBObject;
                }

                @Override
                public void run() {
                    holder.set((Object)PlSqlSourceObjectBuilder.this.m_parser);
                    if (holder.get() == null) {
                        AbstractDBObjectProvider abstractDBObjectProvider = PlSqlSourceObjectBuilder.this.getProvider();
                        PlSqlParserFactory plSqlParserFactory = abstractDBObjectProvider.getDescriptor().getPlSqlParserFactory((DBObjectProvider)abstractDBObjectProvider);
                        holder.set((Object)plSqlParserFactory.createParser((PlSqlSourceObject)this.val$top));
                        PlSqlSourceObjectBuilder.this.m_parser = (PlSqlParser)holder.get();
                    }
                }
            };
            DBUtil.invokeCompoundChange((DBObject)schemaObject, (Runnable)runnable, (boolean)false);
        }
        return (PlSqlParser)holder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferRebuildSource() {
        Holder<Boolean> holder = this.m_deferredHolder;
        synchronized (holder) {
            this.m_deferredHolder.set((Object)Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRebuildSource() throws CancelledException {
        Holder<Boolean> holder = this.m_deferredHolder;
        synchronized (holder) {
            boolean bl = (Boolean)this.m_deferredHolder.get();
            PlSqlSourceObject plSqlSourceObject = this.m_deferredPSO;
            this.m_deferredPSO = null;
            this.m_deferredHolder.set((Object)Boolean.FALSE);
            if (bl && plSqlSourceObject != null && plSqlSourceObject.getSource() != null) {
                PlSqlUtil.rebuildSource((DBObjectProvider)this.getProvider(), plSqlSourceObject);
            }
        }
    }

    public boolean isClearDerivedPropertiesRequired(T t, DBObjectChange dBObjectChange, Collection<String> collection) {
        boolean bl = super.isClearDerivedPropertiesRequired(t, dBObjectChange, collection);
        if (!bl) {
            boolean bl2 = bl = dBObjectChange.getPropertyChange("name") != null || dBObjectChange.getPropertyChange("schema") != null;
        }
        if (dBObjectChange.getPropertyChange("source") != null) {
            this.m_parser = null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> clearDerivedProperties(T t, DBObjectChange dBObjectChange) {
        Holder<Boolean> holder = this.m_deferredHolder;
        synchronized (holder) {
            Collection<String> collection;
            boolean bl = (Boolean)this.m_deferredHolder.get();
            if (!(t instanceof PlSqlSourceObject)) {
                Object var5_6 = null;
                throw new IllegalArgumentException("obj is expected to be a PlSqlSourceObject");
            }
            PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)t;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                block19: {
                    collection = dBObjectChange.getAllChangedProperties();
                    if (collection.contains("source")) {
                        if (bl) {
                            throw new IllegalStateException("Cannot set the source while source building is deferred");
                        }
                        bl2 = true;
                        for (String string : this.getDerivedProperties("source")) {
                            if (!collection.contains(string)) continue;
                            bl2 = false;
                            break;
                        }
                    } else if (this.m_deferredPSO == null) {
                        IdentityHashMap<DBObject, DBObjectChange> identityHashMap = new IdentityHashMap<DBObject, DBObjectChange>();
                        this.getFlattenedMap(dBObjectChange, identityHashMap);
                        for (Map.Entry entry : identityHashMap.entrySet()) {
                            DBObject dBObject = (DBObject)entry.getKey();
                            DBObjectChange dBObjectChange2 = (DBObjectChange)entry.getValue();
                            for (String string : dBObjectChange2.getAllChangedProperties()) {
                                PropertyChangeEvent propertyChangeEvent = dBObjectChange2.getPropertyChange(string);
                                if (propertyChangeEvent == null) continue;
                                Object object = propertyChangeEvent.getOldValue();
                                Object object2 = propertyChangeEvent.getNewValue();
                                if ("name".equals(string)) {
                                    if (object == null) continue;
                                    if (bl) {
                                        this.m_deferredPSO = plSqlSourceObject;
                                        break block19;
                                    }
                                    boolean bl4 = PlSqlUtil.updateSourceForRefactor(plSqlSourceObject, (DBObjectProvider)this.getProvider(), dBObject, string, object, object2);
                                    if (!bl4) continue;
                                    bl2 = true;
                                    continue;
                                }
                                if (!this.rebuildSourceSupported(plSqlSourceObject, dBObject, string, object, object2)) continue;
                                if (bl) {
                                    this.m_deferredPSO = plSqlSourceObject;
                                    break block19;
                                }
                                bl3 = true;
                            }
                        }
                    }
                }
                if (bl3) {
                    PlSqlUtil.rebuildSource((DBObjectProvider)this.getProvider(), plSqlSourceObject);
                    bl2 = true;
                }
            }
            catch (CancelledException cancelledException) {
                DBLog.getLogger((Object)((Object)this)).warning(cancelledException.getMessage());
            }
            if (bl2) {
                collection = super.clearDerivedProperties(t, "source", dBObjectChange);
                this.m_parser = null;
            } else {
                collection = Collections.emptyList();
            }
            return collection;
        }
    }

    private void getFlattenedMap(DBObjectChange dBObjectChange, Map<DBObject, DBObjectChange> map) {
        Map map2 = dBObjectChange.getOwnedObjectsUpdated();
        if (map2 == null || map2.isEmpty()) {
            map.put(dBObjectChange.getDBObject(), dBObjectChange);
        } else {
            for (DBObjectChange dBObjectChange2 : map2.values()) {
                this.getFlattenedMap(dBObjectChange2, map);
            }
        }
    }

    private boolean rebuildSourceSupported(PlSqlSourceObject plSqlSourceObject, DBObject dBObject, String string, Object object, Object object2) {
        boolean bl = false;
        if (plSqlSourceObject != null && ModelUtil.hasLength((String)plSqlSourceObject.getSource()) && ModelUtil.areDifferent((Object)object, (Object)object2)) {
            if (plSqlSourceObject == dBObject) {
                if (plSqlSourceObject instanceof Procedure && "parameters".equals(string)) {
                    bl = true;
                } else if (plSqlSourceObject instanceof Function && "returnTypeReference".equals(string)) {
                    bl = true;
                } else if (plSqlSourceObject instanceof Trigger && ("baseObjectID".equals(string) || "columnIDs".equals(string) || "events".equals(string) || "referencingNewAs".equals(string) || "referencingOldAs".equals(string) || "statementLevel".equals(string) || "timing".equals(string) || "whenClause".equals(string))) {
                    bl = true;
                }
            } else if (dBObject instanceof PlSqlParameter && dBObject.getParent() == plSqlSourceObject && ("dataTypeReference".equals(string) || "defaultValue".equals(string) || "mode".equals(string) || "noCopy".equals(string))) {
                bl = true;
            }
        }
        return bl;
    }

    protected void checkInterruptOrCancel(T t) throws CancelledException {
        super.checkInterruptOrCancel(t);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source"}, derived=true, depends={"startOffset"})
    public boolean buildSourceObjectProperties(T t) throws DBException {
        if (!(t instanceof PlSqlSourceObject)) {
            Object var2_3 = null;
            throw new IllegalArgumentException("obj is expected to be a PlSqlSourceObject");
        }
        PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)t;
        PlSqlParser plSqlParser = this.getParser(t);
        if (ModelUtil.hasLength((String)plSqlSourceObject.getSource())) {
            for (String string : this.getBuiltProperties("propertyReferences")) {
                plSqlSourceObject.setProperty(string, null);
            }
            DBObjectPlSqlFragment dBObjectPlSqlFragment = (DBObjectPlSqlFragment)plSqlSourceObject;
            PlSqlUtil.TypeAndNameInfo typeAndNameInfo = PlSqlUtil.getTypeAndNameFromSource(plSqlSourceObject, this.getProvider().getDescriptor());
            if (ModelUtil.hasLength((String)typeAndNameInfo.getName())) {
                this.addNameProperties(t, plSqlParser, typeAndNameInfo);
            }
            if (!plSqlParser.isWrapped()) {
                this.buildObjectProperties(t, plSqlParser);
                Object object = plSqlParser.getParseNode(dBObjectPlSqlFragment);
                this.addChildren(object, t, plSqlParser);
            }
        }
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"startOffset", "endOffset"})
    public boolean buildOffsets(T t) throws DBException {
        String string = t == null ? null : t.getSource();
        t.setStartOffset(Integer.valueOf(0));
        if (ModelUtil.hasLength((String)string)) {
            PlSqlParser plSqlParser = this.getParser(t);
            PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(string.length() - 1);
            if (!plSqlToken.isCode()) {
                plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
            }
            t.setEndOffset(Integer.valueOf(plSqlToken.getEnd()));
        }
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"comments"})
    public boolean buildComments(T t) throws DBException {
        String string;
        String string2 = string = t == null ? null : t.getSource();
        if (ModelUtil.hasLength((String)string)) {
            PlSqlParser plSqlParser = this.getParser(t);
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            for (int i = 0; i < n - 1; ++i) {
                int n2;
                PlSqlToken plSqlToken;
                if ((byArray[i] != 45 || byArray[i + 1] != 45) && (byArray[i] != 47 || byArray[i + 1] != 42) || (plSqlToken = plSqlParser.getTokenAtOffset(i)) == null || !plSqlToken.isComment()) continue;
                PlSqlToken plSqlToken2 = plSqlToken;
                int n3 = plSqlToken.getStart();
                if (plSqlToken.getType() == Token.Type.SINGLE_LINE_COMMENT) {
                    plSqlToken2 = (PlSqlToken)plSqlToken.getNextToken();
                    while (plSqlToken2.getType() == Token.Type.WHITESPACE || plSqlToken2.getType() == Token.Type.SINGLE_LINE_COMMENT) {
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
                    }
                    while (plSqlToken2.getType() != Token.Type.SINGLE_LINE_COMMENT) {
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevToken();
                    }
                    n2 = plSqlToken2.getEnd();
                } else {
                    n2 = plSqlToken.getEnd();
                }
                PlSqlComment plSqlComment = PlSqlSourceObjectBuilder.createFragment(PlSqlComment.class);
                plSqlComment.setText(plSqlToken.getSource(false, (Token)plSqlToken2));
                t.addComment(plSqlComment);
                this.setCommon(plSqlParser, (DBObjectPlSqlFragment)plSqlComment, n3, n2, "comments." + n3, null);
                i = n2;
            }
        }
        return true;
    }

    protected void addNameProperties(T t, PlSqlParser plSqlParser, PlSqlUtil.TypeAndNameInfo typeAndNameInfo) throws CancelledException {
        String string = typeAndNameInfo.getName();
        if (ModelUtil.hasLength((String)string)) {
            String string2;
            String string3 = t.getName();
            if (!ModelUtil.hasLength((String)string3)) {
                t.setName(string);
            }
            List<String> list = Collections.singletonList(string);
            this.buildReference(plSqlParser, (PlSqlCodeFragment)t, list, typeAndNameInfo.getNameStart(), typeAndNameInfo.getNameEnd(), true);
            PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(t.getEndOffset().intValue());
            if (plSqlToken != null && !plSqlToken.isCode()) {
                plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
            }
            if (plSqlToken != null && plSqlToken.matches(";")) {
                plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
            }
            if (plSqlToken != null && ((PlSqlToken)plSqlToken.getPrevCodeToken()).matches("end") && ((string2 = this.getProvider().getInternalName(plSqlToken.getSource())).equals(string3) || string2.equals(string))) {
                this.buildReference(plSqlParser, (PlSqlCodeFragment)t, list, plSqlToken.getStart(), plSqlToken.getEnd(), true);
            }
        }
    }

    protected void buildObjectProperties(T t, PlSqlParser plSqlParser) throws CancelledException {
    }
}

