/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractPlSqlBuilder<T extends PlSqlCodeFragment>
extends DerivedPropertyBuilder<T> {
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private final SqlAliasExpander m_sqlAliasExpander;

    public AbstractPlSqlBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        super(abstractDBObjectProvider, string);
        Schema schema = null;
        try {
            schema = abstractDBObjectProvider.getDefaultSchema();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.m_sqlAliasExpander = abstractDBObjectProvider.getDescriptor().getSqlAliasExpander((DBObjectProvider)abstractDBObjectProvider, schema);
    }

    public abstract PlSqlParser getParser(T var1) throws CancelledException;

    @AbstractDBObjectBuilder.PropertyBuilder(value={"references"}, depends={"propertyReferences"})
    public boolean buildObjectReferences(T t) throws DBException {
        this.checkInterruptOrCancel((AbstractBuildableObject)t);
        PlSqlParser plSqlParser = this.getParser(t);
        PlSqlToken plSqlToken = null;
        PlSqlToken plSqlToken2 = null;
        PlSqlStatement plSqlStatement = null;
        if (plSqlParser != null && t.getStartOffset() != null) {
            if (t instanceof PlSqlDatum && t.getParent() instanceof PlSqlStatement) {
                plSqlStatement = (PlSqlStatement)t.getParent();
                plSqlToken = plSqlParser.getTokenAtOffset(t.getStartOffset().intValue());
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                plSqlToken2 = plSqlParser.getTokenAtOffset(t.getEndOffset().intValue());
            } else if (t instanceof PlSqlStatement) {
                plSqlStatement = (PlSqlStatement)t;
                PlSqlStatement.Type type = plSqlStatement.getStatementType();
                if (type == PlSqlStatement.Type.STATEMENT) {
                    plSqlToken = plSqlParser.getTokenAtOffset(plSqlStatement.getStartOffset().intValue());
                    plSqlToken2 = plSqlParser.getTokenAtOffset(plSqlStatement.getEndOffset().intValue());
                } else if (type == PlSqlStatement.Type.IF || type == PlSqlStatement.Type.ELSIF || type == PlSqlStatement.Type.EX_WHEN) {
                    plSqlToken = plSqlParser.getTokenAtOffset(plSqlStatement.getStartOffset().intValue());
                    plSqlToken2 = plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                    while (plSqlToken3.isCode() && !plSqlToken3.matches("THEN")) {
                        plSqlToken2 = plSqlToken3;
                        plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                    }
                } else if (type == PlSqlStatement.Type.FOR_LOOP || type == PlSqlStatement.Type.WHILE_LOOP) {
                    int n = type == PlSqlStatement.Type.FOR_LOOP ? 3 : 1;
                    plSqlToken = plSqlParser.getTokenAtOffset(plSqlStatement.getStartOffset().intValue());
                    PlSqlToken plSqlToken4 = plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(n);
                    while (plSqlToken4.isCode() && !plSqlToken4.matches("LOOP")) {
                        plSqlToken2 = plSqlToken4;
                        plSqlToken4 = (PlSqlToken)plSqlToken4.getNextCodeToken();
                    }
                }
            }
            while (plSqlToken != null && plSqlToken2 != null && plSqlToken.getStart() <= plSqlToken2.getStart()) {
                this.checkInterruptOrCancel((AbstractBuildableObject)t);
                plSqlToken = this.buildReferences(plSqlToken, plSqlToken2, (DBObjectPlSqlFragment)plSqlStatement, plSqlParser);
            }
        }
        return true;
    }

    protected void addChildren(Object object, T t, PlSqlParser plSqlParser) throws CancelledException {
        if (object != null && t != null) {
            for (Object e : plSqlParser.getChildParseNodes(t, object)) {
                this.checkInterruptOrCancel((AbstractBuildableObject)t);
                DBObjectPlSqlFragment dBObjectPlSqlFragment = plSqlParser.createFragment(t, object, e);
                if (dBObjectPlSqlFragment != null) {
                    PlSqlToken plSqlToken = null;
                    if (dBObjectPlSqlFragment instanceof PlSqlParameter && t instanceof PlSqlSubProgram) {
                        ((PlSqlSubProgram)t).addParameter((PlSqlParameter)dBObjectPlSqlFragment);
                    } else if (dBObjectPlSqlFragment instanceof PlSqlVariable && t instanceof PlSqlBlock) {
                        ((PlSqlBlock)t).addVariable((PlSqlVariable)dBObjectPlSqlFragment);
                    } else if (dBObjectPlSqlFragment instanceof PlSqlVariable) {
                        boolean bl = false;
                    } else if (dBObjectPlSqlFragment instanceof PlSqlDatatype && t instanceof PlSqlBlock) {
                        ((PlSqlBlock)t).addDatatype((PlSqlDatatype)dBObjectPlSqlFragment);
                    } else if (dBObjectPlSqlFragment instanceof PlSqlSubProgram && t instanceof PlSqlBlock) {
                        ((PlSqlBlock)t).addSubProgram((PlSqlSubProgram)dBObjectPlSqlFragment);
                        plSqlToken = this.getNameToken(plSqlParser, dBObjectPlSqlFragment);
                        dBObjectPlSqlFragment.setName(this.getSubProgramName(plSqlToken, (PlSqlSubProgram)dBObjectPlSqlFragment));
                    } else if (dBObjectPlSqlFragment instanceof PlSqlStatement && t instanceof PlSqlStatement) {
                        ((PlSqlStatement)t).addStatement((PlSqlStatement)dBObjectPlSqlFragment);
                        plSqlToken = this.getNameToken(plSqlParser, dBObjectPlSqlFragment);
                        if (plSqlToken == null) {
                            dBObjectPlSqlFragment.setName(String.valueOf(((PlSqlStatement)t).getStatements().length));
                        }
                    }
                    this.setCommon(plSqlParser, dBObjectPlSqlFragment, plSqlParser.getStartOffset(e), plSqlParser.getEndOffset(e), dBObjectPlSqlFragment.getName(), plSqlToken);
                    continue;
                }
                if (!(t instanceof PlSqlStatement)) continue;
                this.addChildren(e, t, plSqlParser);
            }
        }
    }

    protected final void buildReference(PlSqlParser plSqlParser, PlSqlCodeFragment plSqlCodeFragment, List<String> list, int n, int n2) throws CancelledException {
        this.buildReference(plSqlParser, plSqlCodeFragment, list, n, n2, false);
    }

    protected final void buildReference(PlSqlParser plSqlParser, PlSqlCodeFragment plSqlCodeFragment, List<String> list, int n, int n2, boolean bl) throws CancelledException {
        int n3 = list.size();
        if (n3 > 0) {
            PlSqlReference plSqlReference = AbstractPlSqlBuilder.createFragment(PlSqlReference.class);
            plSqlReference.setReferenceNames(list.toArray(new String[list.size()]));
            if (bl) {
                plSqlCodeFragment.addPropertyReference(plSqlReference);
                int n4 = plSqlCodeFragment.getPropertyReferences().length;
                String string = "propertyReferences." + n4;
                this.setCommon(plSqlParser, (DBObjectPlSqlFragment)plSqlReference, n, n2, string, null);
            } else {
                plSqlCodeFragment.addReference(plSqlReference);
                int n5 = plSqlCodeFragment.getReferences().length;
                String string = "references." + n5;
                this.setCommon(plSqlParser, (DBObjectPlSqlFragment)plSqlReference, n, n2, string, null);
            }
        }
    }

    protected final void setCommon(PlSqlParser plSqlParser, DBObjectPlSqlFragment dBObjectPlSqlFragment, int n, int n2, String string, PlSqlToken plSqlToken) throws CancelledException {
        DBObject dBObject = dBObjectPlSqlFragment.getParent();
        dBObjectPlSqlFragment.setStartOffset(Integer.valueOf(n));
        dBObjectPlSqlFragment.setEndOffset(Integer.valueOf(n2));
        if (plSqlToken == null) {
            plSqlToken = this.getNameToken(plSqlParser, dBObjectPlSqlFragment);
        }
        if (string == null && plSqlToken != null) {
            string = this.getProvider().getInternalName(plSqlToken.getSource());
        }
        dBObjectPlSqlFragment.setName(string);
        if (dBObject != null && dBObject.getID() instanceof BaseObjectID) {
            NameBasedID nameBasedID = new NameBasedID((DBObject)dBObjectPlSqlFragment, this.getProvider());
            dBObjectPlSqlFragment.setID((DBObjectID)nameBasedID);
        } else {
            dBObjectPlSqlFragment.setID(TemporaryObjectID.createID((DBObject)dBObjectPlSqlFragment));
        }
        if (plSqlToken != null && dBObjectPlSqlFragment instanceof PlSqlCodeFragment) {
            this.buildReference(plSqlParser, (PlSqlCodeFragment)dBObjectPlSqlFragment, Collections.singletonList(string), plSqlToken.getStart(), plSqlToken.getEnd(), true);
        }
        this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)dBObjectPlSqlFragment);
    }

    protected final PlSqlReference findDataTypeReference(PlSqlToken plSqlToken, PlSqlToken plSqlToken2, String string, PlSqlParser plSqlParser) throws CancelledException {
        TokenPattern.PatternResult patternResult;
        PlSqlTokenPattern plSqlTokenPattern;
        PlSqlReference plSqlReference = AbstractPlSqlBuilder.createFragment(PlSqlReference.class);
        PlSqlReference.ReferenceType referenceType = PlSqlReference.ReferenceType.DIRECT;
        if (plSqlToken.matches("ref") && !((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            referenceType = PlSqlReference.ReferenceType.REF;
        }
        ArrayList<PlSqlToken> arrayList = new ArrayList<PlSqlToken>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.buildNameAndTokenLists(plSqlToken, plSqlToken2, false, arrayList, arrayList2, plSqlParser);
        if (arrayList2.size() > 0 && referenceType != PlSqlReference.ReferenceType.REF && (plSqlTokenPattern = (PlSqlToken)arrayList.get(arrayList.size() - 1)).getNextCodeToken() != null && ((PlSqlToken)plSqlTokenPattern.getNextCodeToken()).matches("%")) {
            if ((plSqlTokenPattern = (PlSqlToken)plSqlTokenPattern.getNextCodeToken()).getNextCodeToken() != null && ((PlSqlToken)plSqlTokenPattern.getNextCodeToken()).matches("type")) {
                referenceType = PlSqlReference.ReferenceType.PCT_TYPE;
            } else if (plSqlTokenPattern.getNextCodeToken() != null && ((PlSqlToken)plSqlTokenPattern.getNextCodeToken()).matches("rowtype")) {
                referenceType = PlSqlReference.ReferenceType.PCT_ROWTYPE;
            }
        }
        plSqlReference.setReferenceType(referenceType);
        plSqlTokenPattern = this.getSelfSearch();
        TokenPattern.PatternResult patternResult2 = patternResult = plSqlTokenPattern == null ? null : plSqlTokenPattern.getResult((Token)plSqlToken, (Token)plSqlToken2);
        if ((referenceType == PlSqlReference.ReferenceType.DIRECT || referenceType == PlSqlReference.ReferenceType.REF) && patternResult != null) {
            PlSqlSourceObject plSqlSourceObject = plSqlParser.getRoot();
            DBObjectID dBObjectID = plSqlSourceObject == null ? null : plSqlSourceObject.getID();
            plSqlReference.setReferences(new DBObjectID[]{dBObjectID});
        } else {
            if (referenceType == PlSqlReference.ReferenceType.DIRECT) {
                plSqlReference.setDataTypeUsageSource(plSqlToken.getSource(true, (Token)plSqlToken2));
            }
            plSqlReference.setReferenceNames(arrayList2.toArray(new String[arrayList2.size()]));
        }
        this.setCommon(plSqlParser, (DBObjectPlSqlFragment)plSqlReference, plSqlToken.getStart(), plSqlToken2.getEnd(), string, null);
        return plSqlReference;
    }

    protected PlSqlTokenPattern getSelfSearch() {
        return null;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"parameters"})
    public boolean buildParameters(T t) throws DBException {
        this.checkInterruptOrCancel((AbstractBuildableObject)t);
        if (t instanceof PlSqlSubProgram) {
            PlSqlSearch plSqlSearch;
            PlSqlSubProgram plSqlSubProgram = (PlSqlSubProgram)t;
            PlSqlParser plSqlParser = this.getParser(t);
            if (plSqlParser == null) {
                throw new CancelledException();
            }
            PlSqlSearch plSqlSearch2 = plSqlSubProgram instanceof PlSqlMethod ? new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]") : new PlSqlSearch("{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}");
            Integer n = plSqlSubProgram.getStartOffset();
            PlSqlToken plSqlToken = null;
            if (t instanceof Procedure) {
                plSqlToken = plSqlParser.getTokenAtOffset(n == null ? 0 : n);
                plSqlSearch = new PlSqlSearch("[CREATE [OR REPLACE]] <start {PROCEDURE|FUNCTION}>");
                if (plSqlToken != null && plSqlSearch.matches(plSqlToken)) {
                    plSqlToken = plSqlSearch.getNamedMatchStartToken("start");
                }
            } else if (n != null) {
                plSqlToken = plSqlParser.getTokenAtOffset(n.intValue());
            }
            if (plSqlToken != null && plSqlSearch2.matches(plSqlToken)) {
                Object object;
                Object object22;
                plSqlSearch = plSqlSearch2.getNamedMatchStartToken("pname");
                PlSqlToken plSqlToken2 = plSqlSearch2.getNamedMatchStartToken("fname");
                PlSqlSearch plSqlSearch3 = plSqlSearch != null ? plSqlSearch : plSqlToken2;
                String string = plSqlSearch3.getSource(true);
                plSqlSubProgram.setParameters(new PlSqlParameter[0]);
                for (Object object22 : plSqlParser.getPropertyNodes((DBObjectPlSqlFragment)plSqlSubProgram, "parameters")) {
                    this.checkInterruptOrCancel((AbstractBuildableObject)t);
                    object = AbstractPlSqlBuilder.createFragment(PlSqlParameter.class);
                    object.setStartOffset(Integer.valueOf(plSqlParser.getStartOffset(object22)));
                    object.setEndOffset(Integer.valueOf(plSqlParser.getEndOffset(object22)));
                    plSqlSubProgram.addParameter((PlSqlParameter)object);
                    this.setCommon(plSqlParser, (DBObjectPlSqlFragment)object, object.getStartOffset(), object.getEndOffset(), object.getName(), null);
                }
                String string2 = this.getSubProgramName((PlSqlToken)plSqlSearch3, plSqlSubProgram);
                PlSqlToken plSqlToken3 = plSqlParser.getTokenAtOffset(plSqlSubProgram.getEndOffset().intValue());
                PlSqlToken plSqlToken4 = (PlSqlToken)plSqlToken3.getPrevCodeToken();
                object22 = (PlSqlToken)plSqlToken4.getPrevCodeToken();
                if (object22.matches("END") && plSqlToken4.matches(string) && plSqlToken3.matches(";") && plSqlSubProgram.getParent() instanceof DBObjectPlSqlFragment) {
                    object = new ArrayList();
                    object.add(string2);
                    this.buildReference(plSqlParser, (PlSqlCodeFragment)plSqlSubProgram, (List<String>)object, plSqlToken4.getStart(), plSqlToken4.getEnd(), true);
                }
                object = null;
                if (plSqlToken2 != null && plSqlSearch2.getNamedMatchStartToken("datatype") != null) {
                    PlSqlToken plSqlToken5 = plSqlSearch2.getNamedMatchStartToken("datatype");
                    PlSqlToken plSqlToken6 = plSqlSearch2.getNamedMatchEndToken("datatype");
                    object = this.findDataTypeReference(plSqlToken5, plSqlToken6, "returnTypeReference", plSqlParser);
                }
                plSqlSubProgram.setReturnTypeReference((PlSqlReference)object);
            }
        }
        return true;
    }

    protected final void buildPlSqlSubProgram(PlSqlSubProgram plSqlSubProgram, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlToken plSqlToken;
        PlSqlSearch plSqlSearch = plSqlSubProgram instanceof PlSqlMethod ? new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]") : new PlSqlSearch("{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}");
        if (plSqlSearch.matches(plSqlToken = plSqlParser.getTokenAtOffset(plSqlSubProgram.getStartOffset().intValue()))) {
            PlSqlReference plSqlReference;
            PlSqlToken plSqlToken2 = plSqlSearch.getNamedMatchStartToken("pname");
            PlSqlToken plSqlToken3 = plSqlSearch.getNamedMatchStartToken("fname");
            PlSqlToken plSqlToken4 = plSqlToken2 != null ? plSqlToken2 : plSqlToken3;
            String string = plSqlToken4.getSource(true);
            String string2 = this.getSubProgramName(plSqlToken4, plSqlSubProgram);
            PlSqlToken plSqlToken5 = plSqlParser.getTokenAtOffset(plSqlSubProgram.getEndOffset().intValue());
            PlSqlToken plSqlToken6 = (PlSqlToken)plSqlToken5.getPrevCodeToken();
            PlSqlToken plSqlToken7 = (PlSqlToken)plSqlToken6.getPrevCodeToken();
            if (plSqlToken7.matches("END") && plSqlToken6.matches(string) && plSqlToken5.matches(";") && plSqlSubProgram.getParent() instanceof DBObjectPlSqlFragment) {
                plSqlReference = new ArrayList();
                plSqlReference.add(string2);
                this.buildReference(plSqlParser, (PlSqlCodeFragment)plSqlSubProgram, (List<String>)plSqlReference, plSqlToken6.getStart(), plSqlToken6.getEnd(), true);
            }
            plSqlReference = null;
            if (plSqlToken3 != null && plSqlSearch.getNamedMatchStartToken("datatype") != null) {
                PlSqlToken plSqlToken8 = plSqlSearch.getNamedMatchStartToken("datatype");
                PlSqlToken plSqlToken9 = plSqlSearch.getNamedMatchEndToken("datatype");
                plSqlReference = this.findDataTypeReference(plSqlToken8, plSqlToken9, "returnTypeReference", plSqlParser);
            }
            plSqlSubProgram.setReturnTypeReference(plSqlReference);
        }
    }

    protected final void buildPlSqlParameter(PlSqlParameter plSqlParameter, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlSearch plSqlSearch = new PlSqlSearch("<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?.[(...)]>]");
        PlSqlParameter.Mode mode = PlSqlParameter.Mode.IN;
        PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(plSqlParameter.getStartOffset().intValue());
        if (plSqlSearch.matches(plSqlToken)) {
            String string = plSqlSearch.getNamedMatch("mode");
            if (string != null) {
                if (string.equals("OUT")) {
                    mode = PlSqlParameter.Mode.OUT;
                } else if (string.equals("IN OUT")) {
                    mode = PlSqlParameter.Mode.INOUT;
                }
            }
            plSqlParameter.setMode(mode);
            String string2 = plSqlSearch.getNamedMatch("default");
            if (string2 != null) {
                plSqlParameter.setDefaultValue(string2);
            }
            plSqlParameter.setNoCopy(plSqlSearch.getNamedMatch("nocopy") != null);
            PlSqlToken plSqlToken2 = plSqlSearch.getNamedMatchStartToken("datatype");
            PlSqlToken plSqlToken3 = plSqlSearch.getNamedMatchEndToken("datatype");
            PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken2, plSqlToken3, "dataTypeReference", plSqlParser);
            plSqlParameter.setDataTypeReference(plSqlReference);
        }
    }

    protected final PlSqlToken buildReferences(PlSqlToken plSqlToken, PlSqlToken plSqlToken2, DBObjectPlSqlFragment dBObjectPlSqlFragment, PlSqlParser plSqlParser) throws CancelledException {
        DBObjectPlSqlFragment dBObjectPlSqlFragment2;
        for (dBObjectPlSqlFragment2 = dBObjectPlSqlFragment; dBObjectPlSqlFragment2 != null && !(dBObjectPlSqlFragment2 instanceof PlSqlCodeFragment); dBObjectPlSqlFragment2 = dBObjectPlSqlFragment2.getParent()) {
        }
        PlSqlCodeFragment plSqlCodeFragment = (PlSqlCodeFragment)dBObjectPlSqlFragment2;
        PlSqlToken plSqlToken3 = plSqlToken;
        PlSqlToken plSqlToken4 = plSqlToken2;
        if (plSqlToken4.matches(";")) {
            plSqlToken4 = (PlSqlToken)plSqlToken4.getPrevCodeToken();
        }
        if (plSqlToken3.matches("select")) {
            if (((PlSqlToken)plSqlToken.getPrevCodeToken()).matches(LPAREN)) {
                plSqlToken4 = plSqlToken;
                int n = 1;
                while (n > 0) {
                    if (plSqlToken4.matches(LPAREN)) {
                        ++n;
                    } else if (plSqlToken4.matches(RPAREN)) {
                        --n;
                    }
                    plSqlToken4 = (PlSqlToken)plSqlToken4.getNextCodeToken();
                }
                plSqlToken4 = (PlSqlToken)plSqlToken4.getPrevCodeToken();
                plSqlToken4 = (PlSqlToken)plSqlToken4.getPrevCodeToken();
            } else {
                PlSqlSearch plSqlSearch = new PlSqlSearch("select {^{into|from}}... into <intoClause {^from}...>");
                if (plSqlSearch.matches(plSqlToken, plSqlToken2)) {
                    PlSqlToken plSqlToken5 = plSqlSearch.getNamedMatchStartToken("intoClause");
                    PlSqlToken plSqlToken6 = plSqlSearch.getNamedMatchEndToken("intoClause");
                    PlSqlToken plSqlToken7 = plSqlToken5;
                    while (plSqlToken7.isCode() && plSqlToken7.getStart() < plSqlToken6.getEnd()) {
                        plSqlToken7 = this.buildReferences(plSqlToken7, plSqlToken6, dBObjectPlSqlFragment, plSqlParser);
                        plSqlToken7 = (PlSqlToken)plSqlToken7.getNextCodeToken();
                    }
                }
            }
            plSqlToken3 = this.buildReferencesInSQL(plSqlToken3, plSqlToken4, plSqlCodeFragment, plSqlParser);
        } else if (plSqlToken3.matches("insert")) {
            plSqlToken3 = this.buildReferencesInSQL(plSqlToken3, plSqlToken4, plSqlCodeFragment, plSqlParser);
        } else if (plSqlToken3.matches("update")) {
            plSqlToken3 = this.buildReferencesInSQL(plSqlToken3, plSqlToken4, plSqlCodeFragment, plSqlParser);
        } else if (plSqlToken3.matches("delete")) {
            plSqlToken3 = this.buildReferencesInSQL(plSqlToken3, plSqlToken4, plSqlCodeFragment, plSqlParser);
        } else {
            if (plSqlToken3.getType() != Token.Type.ALPHANUMERIC && plSqlToken3.getType() != Token.Type.DOUBLE_QUOTED_STRING && !plSqlToken3.matches(":")) {
                return (PlSqlToken)plSqlToken3.getNextCodeToken();
            }
            if (((PlSqlToken)plSqlToken3.getNextCodeToken()).matches("=>")) {
                return (PlSqlToken)plSqlToken3.getNextCodeToken(2);
            }
            ArrayList<PlSqlToken> arrayList = new ArrayList<PlSqlToken>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            plSqlToken3 = this.buildNameAndTokenLists(plSqlToken3, plSqlToken2, true, arrayList, arrayList2, plSqlParser);
            if (arrayList2.size() > 0 && plSqlCodeFragment != null) {
                int n = arrayList.size() - 1;
                boolean bl = false;
                if (((String)arrayList2.get(arrayList2.size() - 1)).startsWith(LPAREN)) {
                    n = arrayList2.size() - 2;
                    bl = true;
                }
                this.buildReference(plSqlParser, plSqlCodeFragment, arrayList2, ((PlSqlToken)arrayList.get(0)).getStart(), ((PlSqlToken)arrayList.get(n)).getEnd());
                if (bl) {
                    for (int i = n + 1; i < arrayList.size(); ++i) {
                        if (arrayList.get(i) == null) continue;
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        arrayList3.addAll(arrayList2);
                        arrayList3.add(((PlSqlToken)arrayList.get(i)).getSource(true));
                        this.buildReference(plSqlParser, plSqlCodeFragment, arrayList3, ((PlSqlToken)arrayList.get(i)).getStart(), ((PlSqlToken)arrayList.get(i)).getEnd());
                    }
                }
            }
        }
        return plSqlToken3;
    }

    private PlSqlToken buildReferencesInSQL(PlSqlToken plSqlToken, PlSqlToken plSqlToken2, PlSqlCodeFragment plSqlCodeFragment, PlSqlParser plSqlParser) throws CancelledException {
        for (SqlAliasExpander.Usage usage : this.m_sqlAliasExpander.getUsages(plSqlToken, plSqlToken2)) {
            List list = usage.getTokens();
            if (list.size() > 0 && plSqlParser.getRoot() instanceof Trigger) {
                PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken.getTokenAt(usage.getStartOffset());
                plSqlToken3 = (PlSqlToken)plSqlToken3.getPrevCodeToken();
                while (plSqlToken3.matches(".")) {
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getPrevCodeToken();
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getPrevCodeToken();
                }
                if (this.isTriggerColonNewOrOld(plSqlToken3, plSqlParser)) {
                    list.remove(0);
                    list.add(0, DBUtil.getDBObjectName((DBObjectID)((Trigger)plSqlParser.getRoot()).getBaseObjectID()));
                }
            }
            this.buildReference(plSqlParser, plSqlCodeFragment, list, usage.getStartOffset(), usage.getEndOffset());
        }
        return (PlSqlToken)plSqlToken2.getNextCodeToken();
    }

    protected PlSqlToken buildNameAndTokenLists(PlSqlToken plSqlToken, PlSqlToken plSqlToken2, boolean bl, List<PlSqlToken> list, List<String> list2, PlSqlParser plSqlParser) {
        PlSqlToken plSqlToken3 = plSqlToken;
        if (!plSqlToken3.isCode()) {
            plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
        }
        String string = null;
        if (list2.size() == 0 && this.isTriggerColonNewOrOld(plSqlToken3, plSqlParser)) {
            plSqlToken3 = (PlSqlToken)plSqlToken3.getNextToken();
            string = DBUtil.getDBObjectName((DBObjectID)((Trigger)plSqlParser.getRoot()).getBaseObjectID());
        } else if (plSqlToken3.getType() == Token.Type.ALPHANUMERIC) {
            try {
                Float.valueOf(plSqlToken3.getSource());
            }
            catch (NumberFormatException numberFormatException) {
                string = plSqlToken3.getSource(true);
            }
        } else if (plSqlToken3.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
            string = plSqlToken3.getSource(false);
            string = string.substring(1, string.length() - 1);
        }
        if (string != null) {
            list.add(plSqlToken3);
            list2.add(string);
            plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
            if (plSqlToken3.getStart() <= plSqlToken2.getEnd()) {
                if (plSqlToken3.matches(".")) {
                    plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                    plSqlToken3 = this.buildNameAndTokenLists(plSqlToken3, plSqlToken2, bl, list, list2, plSqlParser);
                } else if (plSqlToken3.matches(LPAREN) && bl) {
                    String string2 = LPAREN;
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 1;
                    PlSqlToken plSqlToken4 = (PlSqlToken)plSqlToken3.getNextCodeToken();
                    if (plSqlToken4.matches(RPAREN)) {
                        --n;
                    }
                    boolean bl2 = true;
                    while (n > 0) {
                        if (n == 1 && bl2) {
                            stringBuilder.append(string2);
                            string2 = ",";
                            if (((PlSqlToken)plSqlToken4.getNextCodeToken()).matches("=>")) {
                                stringBuilder.append(plSqlToken4.getSource(true));
                                list.add(plSqlToken4);
                                plSqlToken4 = (PlSqlToken)plSqlToken4.getNextCodeToken(2);
                            } else {
                                stringBuilder.append("?");
                                list.add(null);
                            }
                            bl2 = plSqlToken4.matches(",");
                        } else if (n == 1 && plSqlToken4.matches(",")) {
                            bl2 = true;
                        } else if (plSqlToken4.matches(LPAREN)) {
                            ++n;
                        }
                        if (plSqlToken4.matches(RPAREN) && --n == 0) {
                            stringBuilder.append(RPAREN);
                            list2.add(stringBuilder.toString());
                        }
                        if (!(plSqlToken4 = (PlSqlToken)plSqlToken4.getNextCodeToken()).isEndMarker() && plSqlToken4.getStart() <= plSqlToken2.getEnd()) continue;
                        if (n > 0) {
                            stringBuilder.append(RPAREN);
                            list2.add(stringBuilder.toString());
                        }
                        break;
                    }
                }
            }
        } else {
            plSqlToken3 = (PlSqlToken)plSqlToken3.getNextCodeToken();
        }
        return plSqlToken3;
    }

    private PlSqlToken getNameToken(PlSqlParser plSqlParser, DBObjectPlSqlFragment dBObjectPlSqlFragment) throws CancelledException {
        PlSqlToken plSqlToken = null;
        if (dBObjectPlSqlFragment != null && !(dBObjectPlSqlFragment instanceof PlSqlComment) && !(dBObjectPlSqlFragment instanceof PlSqlReference)) {
            String string = dBObjectPlSqlFragment.getType();
            PlSqlToken plSqlToken2 = plSqlParser.getTokenAtOffset(dBObjectPlSqlFragment.getStartOffset().intValue());
            if (dBObjectPlSqlFragment instanceof PlSqlSubProgram || dBObjectPlSqlFragment instanceof PlSqlDatatype) {
                plSqlToken = (PlSqlToken)plSqlToken2.getNextCodeToken();
            } else if ("STATEMENT".equals(string) || "BLOCK".equals(string)) {
                PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
                PlSqlToken plSqlToken4 = null;
                if (plSqlToken3.matches(">>") && (plSqlToken3 = (PlSqlToken)(plSqlToken4 = (PlSqlToken)plSqlToken3.getPrevCodeToken()).getPrevCodeToken()).matches("<<")) {
                    plSqlToken = plSqlToken4;
                }
            } else {
                plSqlToken = plSqlToken2;
            }
        }
        return plSqlToken;
    }

    private boolean isTriggerColonNewOrOld(PlSqlToken plSqlToken, PlSqlParser plSqlParser) {
        PlSqlSourceObject plSqlSourceObject = plSqlParser.getRoot();
        if (plSqlToken.matches(":") && plSqlSourceObject instanceof Trigger) {
            PlSqlToken plSqlToken2;
            String string;
            String string2 = ((Trigger)plSqlSourceObject).getReferencingNewAs();
            if (!ModelUtil.hasLength((String)string2)) {
                string2 = "NEW";
            }
            if (!ModelUtil.hasLength((String)(string = ((Trigger)plSqlSourceObject).getReferencingOldAs()))) {
                string = "OLD";
            }
            if ((plSqlToken2 = (PlSqlToken)plSqlToken.getNextCodeToken()) != null && (plSqlToken2.matches(string2) || plSqlToken2.matches(string))) {
                return true;
            }
        }
        return false;
    }

    protected String getSubProgramName(PlSqlToken plSqlToken, PlSqlSubProgram plSqlSubProgram) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProvider().getInternalName(plSqlToken.getSource(true)));
        if (!(plSqlSubProgram instanceof PlSqlSourceObject)) {
            String string = LPAREN;
            PlSqlSearch plSqlSearch = new PlSqlSearch("? (...)");
            if (plSqlSearch.matches(plSqlToken)) {
                int n = plSqlSearch.getEndToken().getStart();
                int n2 = 0;
                boolean bl = false;
                PlSqlToken plSqlToken2 = (PlSqlToken)plSqlToken.getNextCodeToken();
                while (plSqlToken2.getStart() < n) {
                    if (plSqlToken2.matches(string) && n2 == 0) {
                        stringBuffer.append(string);
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        stringBuffer.append(this.getProvider().getInternalName(plSqlToken2.getSource(true)));
                        if (((PlSqlToken)plSqlToken2.getNextCodeToken()).matches("IN")) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        if (((PlSqlToken)plSqlToken2.getNextCodeToken()).matches("OUT")) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        if (((PlSqlToken)plSqlToken2.getNextCodeToken()).matches("NOCOPY")) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        bl = true;
                        string = ",";
                    } else if (bl) {
                        if (plSqlToken2.matches("DEFAULT") || plSqlToken2.matches(":=")) {
                            bl = false;
                        } else {
                            if (plSqlToken2.matches(LPAREN)) {
                                ++n2;
                            } else if (plSqlToken2.matches(RPAREN)) {
                                --n2;
                            }
                            if (plSqlToken2.getType() != Token.Type.PUNCTUATION) {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append(this.getProvider().getInternalName(plSqlToken2.getSource(true)));
                        }
                    }
                    plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                }
                stringBuffer.append(RPAREN);
            }
        }
        return stringBuffer.toString();
    }

    protected boolean isSourcePropertyValueEqual(T t, T t2, String string) {
        if ("source".equals(string) && !(t instanceof PlSqlSourceObject)) {
            return t.getStartOffset() == t2.getStartOffset() && t.getEndOffset() == t2.getEndOffset();
        }
        return super.isSourcePropertyValueEqual(t, t2, string);
    }

    protected static final <T extends DBObjectPlSqlFragment> T createFragment(Class<T> clazz) {
        if (SwingUtilities.isEventDispatchThread()) {
            DBLog.logIllegalState((String)"Building PL/SQL derived properties on EDT");
        }
        DBObjectPlSqlFragment dBObjectPlSqlFragment = null;
        try {
            dBObjectPlSqlFragment = (DBObjectPlSqlFragment)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return (T)dBObjectPlSqlFragment;
    }

    protected static final PlSqlSubProgram createPlSqlSubProgram(PlSqlSourceObject plSqlSourceObject) {
        if (plSqlSourceObject instanceof TypeBody) {
            return (PlSqlSubProgram)AbstractPlSqlBuilder.createFragment(PlSqlMethod.class);
        }
        return AbstractPlSqlBuilder.createFragment(PlSqlSubProgram.class);
    }
}

