/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class LOBDescriptorValidator
extends AbstractChildDBObjectValidator<LOBDescriptor> {
    public LOBDescriptorValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("LOBCache");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"storageInRow"}, level=ValidationLevel.FULL)
    public void validateStorageEnabledInRow(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties;
        Table table;
        if (Boolean.TRUE.equals(lOBDescriptor2.getStorageInRow()) && (table = (Table)DBUtil.findParentOfType((DBObject)lOBDescriptor2, Table.class)) != null && (oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null && !oracleIndexOrganizedTableProperties.isOverflowable()) {
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_STORAGE_IN_IOT"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"LOBCache"}, level=ValidationLevel.FULL)
    public void validateCache(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        OracleStorageProperties oracleStorageProperties;
        if (lOBDescriptor2.getLOBCache() == LOBDescriptor.LOBCache.CACHE && (oracleStorageProperties = lOBDescriptor2.getStorage()) != null && Boolean.FALSE.equals(oracleStorageProperties.getLogging())) {
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_CACHE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"chunk"}, level=ValidationLevel.FULL)
    public void validateChunk(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        Integer n = lOBDescriptor2.getChunk();
        if (n != null) {
            if (n < 1 || n > 32768) {
                throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_CHUNK1"));
            }
            OracleStorageProperties oracleStorageProperties = lOBDescriptor2.getStorage();
            if (oracleStorageProperties != null && oracleStorageProperties.getNextExtent() != null && oracleStorageProperties.getNextExtent().compareTo(BigInteger.valueOf(n.longValue())) < 0) {
                throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.format((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_CHUNK2", (Object[])new Object[]{oracleStorageProperties.getNextExtent()}));
            }
        }
        this.validateNonNullableProperty((DBObject)lOBDescriptor, (DBObject)lOBDescriptor2, "chunk");
    }

    @DBObjectValidator.PropertyValidator(value={"freepools"}, level=ValidationLevel.FULL)
    public void validateFreepools(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        Integer n = lOBDescriptor2.getFreepools();
        if (n != null) {
            if (n < 0) {
                throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_FREEPOOLS"));
            }
            OracleStorageProperties oracleStorageProperties = lOBDescriptor2.getStorage();
            if (oracleStorageProperties != null && oracleStorageProperties.getFreelistGroups() != null) {
                throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_FREEPOOLS_AND_FREELIST_GROUPS"));
            }
        }
        this.validateNonNullableProperty((DBObject)lOBDescriptor, (DBObject)lOBDescriptor2, "freepools");
    }

    @DBObjectValidator.PropertyValidator(value={"pctVersion"}, level=ValidationLevel.FULL)
    public void validatePctVersion(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        Integer n = lOBDescriptor2.getPctVersion();
        if (n != null && (n < 0 || n > 100)) {
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_PCTVERSION"));
        }
        this.validateNonNullableProperty((DBObject)lOBDescriptor, (DBObject)lOBDescriptor2, "pctVersion");
    }

    @DBObjectValidator.PropertyValidator(value={"retention"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"pctVersion"})
    public void validateRetention(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        Integer n = lOBDescriptor2.getPctVersion();
        boolean bl = lOBDescriptor2.isRetention();
        if (bl && n != null) {
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_PCTVERSION_AND_RETENTION"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columns", "LOBSegName"}, level=ValidationLevel.FULL)
    public void validateColumns(LOBDescriptor lOBDescriptor, LOBDescriptor lOBDescriptor2) throws ValidationException {
        DBObjectID[] dBObjectIDArray = lOBDescriptor2.getColumns();
        if (!(lOBDescriptor2.getParent() instanceof OracleColumnProperties) && dBObjectIDArray.length < 1) {
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INCOMPLETE"));
        }
        String string = lOBDescriptor2.getLOBSegName();
        if (string != null && dBObjectIDArray.length > 1) {
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_TOO_MANY_COLUMNS"));
        }
        for (int i = 0; i < dBObjectIDArray.length; ++i) {
            DBObjectID dBObjectID = dBObjectIDArray[i];
            boolean bl = LOBDescriptor.isVARRAYColumn((DBObjectID)dBObjectID, (DBObject)lOBDescriptor2);
            if (!LOBDescriptor.isLOBColumn((DBObjectID)dBObjectID, (DBObject)lOBDescriptor2) && !bl || bl && i > 0) {
                throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INCOMPLETE"));
            }
            if (!bl || string != null) continue;
            throw new ValidationException((DBObject)lOBDescriptor2, APIBundle.get((String)"TABLE_PARTITION_STORAGE_ERROR_MISSING_LOB_SEGNAME"));
        }
    }
}

