/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class ExternalTablePropsValidator
extends AbstractChildDBObjectValidator<OracleExternalTableProperties> {
    public ExternalTablePropsValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("projectColumn");
        collection.add("accessUsingClob");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"defaultDirectory"})
    public void validateDefaultDirectory(OracleExternalTableProperties oracleExternalTableProperties, OracleExternalTableProperties oracleExternalTableProperties2) throws ValidationException {
        DBObjectID dBObjectID;
        String string;
        if (this.isKnownAccessDriverType(oracleExternalTableProperties2) && !ModelUtil.hasLength((String)(string = DBUtil.getDBObjectName((DBObjectID)(dBObjectID = oracleExternalTableProperties2.getDefaultDirectory()))))) {
            throw new ValidationException((DBObject)oracleExternalTableProperties2, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_DEFAULT_DIR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"locationSpecifiers"})
    public void validateLocationSpecifiers(OracleExternalTableProperties oracleExternalTableProperties, OracleExternalTableProperties oracleExternalTableProperties2) throws ValidationException {
        OracleExternalTableProperties.LocationSpecifier[] locationSpecifierArray;
        if (this.isKnownAccessDriverType(oracleExternalTableProperties2) && (locationSpecifierArray = oracleExternalTableProperties2.getLocationSpecifiers()).length == 0) {
            throw new ValidationException((DBObject)oracleExternalTableProperties2, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_LOCATION"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"accessDriverType"}, level=ValidationLevel.FULL)
    public void validateAccessDriverType(OracleExternalTableProperties oracleExternalTableProperties, OracleExternalTableProperties oracleExternalTableProperties2) throws ValidationException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (!(dBObjectProvider != null && dBObjectProvider.getDescriptor().getDatabaseVersion() >= 120 || this.isKnownAccessDriverType(oracleExternalTableProperties2))) {
            throw new ValidationException((DBObject)oracleExternalTableProperties2, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_ACCESS_DRIVER_TYPE"));
        }
    }

    private boolean isKnownAccessDriverType(OracleExternalTableProperties oracleExternalTableProperties) {
        String string = oracleExternalTableProperties.getAccessDriverType();
        return string == null || string.equals("ORACLE_LOADER") || string.equals("ORACLE_DATAPUMP");
    }

    @DBObjectValidator.PropertyValidator(value={"accessParameters"})
    @DBObjectValidator.PropertyDependency(value={"accessUsingClob", "accessDriverType"})
    public void validateAccessParameters(ValidationContext<OracleExternalTableProperties> validationContext) throws ValidationException {
        String string;
        OracleExternalTableProperties oracleExternalTableProperties = (OracleExternalTableProperties)validationContext.getUpdatedObject();
        String string2 = oracleExternalTableProperties.getAccessParameters();
        if (!ModelUtil.hasLength((String)string2)) {
            if (oracleExternalTableProperties.isAccessUsingClob()) {
                throw new ValidationException((DBObject)oracleExternalTableProperties, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MUST_BE_SUBQUERY"));
            }
        } else if (validationContext.getLevel() == ValidationLevel.FULL && BigDataAccessParameterMetadata.isBigDataAccessDriver((String)(string = oracleExternalTableProperties.getAccessDriverType()))) {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)oracleExternalTableProperties);
            SQLFragment sQLFragment = oracleExternalTableProperties.getAccessParametersFragment();
            if (sQLFragment instanceof BigDataAccessParameters) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Collection collection = BigDataAccessParameterMetadata.getAllowedParameterNames((String)string);
                for (BigDataAccessParameter bigDataAccessParameter : ((BigDataAccessParameters)sQLFragment).getBigDataAccessParameters()) {
                    String string3 = bigDataAccessParameter.getName();
                    if (collection.contains(string3) || BigDataAccessParameterMetadata.isAdditionalAccessParameter((String)string3)) continue;
                    arrayList.add(string3);
                }
                if (!arrayList.isEmpty()) {
                    throw new ValidationException((DBObject)oracleExternalTableProperties, APIBundle.format((String)"EXTERNAL_TABLE_PROPERTY_INVALID_PARAMS", (Object[])new Object[]{string, arrayList}));
                }
            } else {
                throw new ValidationException((DBObject)oracleExternalTableProperties, APIBundle.format((String)"EXTERNAL_TABLE_PROPERTY_INVALID_PARAM_FORMAT", (Object[])new Object[]{string}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"rejectLimit"}, level=ValidationLevel.FULL)
    public void validateRejectLimit(OracleExternalTableProperties oracleExternalTableProperties, OracleExternalTableProperties oracleExternalTableProperties2) throws ValidationException {
        Integer n = oracleExternalTableProperties2.getRejectLimit();
        if (n != null && n < 0 && n != -1) {
            throw new ValidationException((DBObject)oracleExternalTableProperties2, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_REJECT_LIMIT"));
        }
    }
}

