/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class DatabaseLinkValidator
extends SchemaObjectValidator<DatabaseLink> {
    public DatabaseLinkValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("host");
        collection.add("shared");
        collection.add("public");
        collection.add("connectToUser");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"username"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"connectToUser"})
    public void validateUsername(DatabaseLink databaseLink, DatabaseLink databaseLink2) throws ValidationException {
        String string;
        if (Boolean.FALSE.equals(databaseLink2.getConnectToUser()) && !ModelUtil.hasLength((String)(string = databaseLink2.getUsername()))) {
            throw new ValidationException((DBObject)databaseLink2, APIBundle.get((String)"DBLV_NO_USERNAME"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"password"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"connectToUser"})
    public void validatePassword(DatabaseLink databaseLink, DatabaseLink databaseLink2) throws ValidationException {
        if (Boolean.FALSE.equals(databaseLink2.getConnectToUser()) && this.getProvider() instanceof Database) {
            String string = databaseLink2.getPassword();
            String string2 = databaseLink2.getPasswordX();
            if (!ModelUtil.hasLength((String)string) && !ModelUtil.hasLength((String)string2)) {
                throw new ValidationException((DBObject)databaseLink2, APIBundle.get((String)"DBLV_NO_PASSWORD"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"authentificationPassword"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"shared"})
    public void validateAuthentificationPassword(DatabaseLink databaseLink, DatabaseLink databaseLink2) throws ValidationException {
        if (databaseLink2.isShared() && this.getProvider() instanceof Database) {
            String string = databaseLink2.getAuthentificationPassword();
            String string2 = databaseLink2.getAuthentificationPasswordX();
            if (!ModelUtil.hasLength((String)string) && !ModelUtil.hasLength((String)string2)) {
                throw new ValidationException((DBObject)databaseLink2, APIBundle.get((String)"DBLV_NO_AUTHENTIFICATION_PASSWORD"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"authentificationUsername"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"shared"})
    public void validateAuthentificationUsername(DatabaseLink databaseLink, DatabaseLink databaseLink2) throws ValidationException {
        String string;
        if (databaseLink2.isShared() && !ModelUtil.hasLength((String)(string = databaseLink2.getAuthentificationUsername()))) {
            throw new ValidationException((DBObject)databaseLink2, APIBundle.get((String)"DBLV_NO_AUTHENTIFICATION_USERNAME"));
        }
    }
}

