/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.Iterator;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ora.sxml.SXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class SXMLFragmentGenerator {
    public static final String SXML_NAMESPACE = "http://xmlns.oracle.com/ku";
    private SXMLFragmentGenerator m_parentGen;
    private SXMLMappings m_mappings;
    private PropertyHelper m_propHelper = new PropertyHelper();

    protected SXMLFragmentGenerator() {
    }

    void setParentGenerator(SXMLFragmentGenerator sXMLFragmentGenerator) {
        this.m_parentGen = sXMLFragmentGenerator;
    }

    SXMLFragmentGenerator getParentGenerator() {
        return this.m_parentGen;
    }

    protected abstract void populateNode(Node var1, Document var2, Object var3);

    protected boolean supportsType(String string) {
        return true;
    }

    protected abstract void readNode(Node var1, Object var2) throws SXMLReaderException;

    protected final SXMLMappings getMappings() {
        return this.m_mappings;
    }

    protected final void setMappings(SXMLMappings sXMLMappings) {
        this.m_mappings = sXMLMappings;
    }

    protected final String getType(Object object) {
        if (object instanceof DBObject) {
            return ((DBObject)object).getType();
        }
        return object.getClass().getSimpleName();
    }

    final void removeFromParentIfEmpty(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string) || (nodeList2 = node2.getChildNodes()) != null && nodeList2.getLength() != 0) continue;
            node.removeChild(node2);
        }
    }

    protected final Node findOrCreateNode(Document document, Node node, String string) {
        return this.nodeCreateImpl(document, node, string, true, null, null);
    }

    protected final Node createNode(Document document, Node node, String string) {
        return this.nodeCreateImpl(document, node, string, false, null, null);
    }

    protected final Node findOrCreateNodeAfter(Document document, Node node, String string, String string2) {
        return this.nodeCreateImpl(document, node, string, true, string2, null);
    }

    protected final Node findOrCreateNodeBefore(Document document, Node node, String string, String string2) {
        return this.nodeCreateImpl(document, node, string, true, null, string2);
    }

    private Node nodeCreateImpl(Document document, Node node, String string, boolean bl, String string2, String string3) {
        Object object;
        int n = string.indexOf("/");
        String string4 = null;
        if (n > -1) {
            string4 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if (string.equals("")) {
            return node;
        }
        Node node2 = null;
        if (bl && node != null) {
            object = node.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node3 = object.item(i);
                if (!node3.getNodeName().equals(string)) continue;
                node2 = node3;
            }
        }
        if (node2 == null) {
            node2 = document.createElementNS(SXML_NAMESPACE, string);
            if (node != null) {
                if (string2 == null && string3 == null) {
                    node.appendChild(node2);
                } else {
                    object = null;
                    if (ModelUtil.areEqual((Object)string2, (Object)"/")) {
                        object = node.getFirstChild();
                    } else {
                        NodeList nodeList = node.getChildNodes();
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node4 = nodeList.item(i);
                            if (string2 != null && node4.getNodeName().equals(string2)) {
                                if (nodeList.getLength() <= i + 1) break;
                                object = nodeList.item(i + 1);
                                break;
                            }
                            if (string3 == null || !node4.getNodeName().equals(string3)) continue;
                            object = node4;
                            break;
                        }
                    }
                    if (object == null) {
                        node.appendChild(node2);
                    } else {
                        node.insertBefore(node2, (Node)object);
                    }
                }
            }
        }
        if (string4 == null) {
            return node2;
        }
        return this.nodeCreateImpl(document, node2, string4, bl, string2, string3);
    }

    final DBObject resolveID(DBObjectID dBObjectID, DBObject dBObject) {
        DBObject dBObject2;
        if (dBObject != null && (dBObject2 = dBObject.findOwnedObject(dBObjectID)) != null) {
            return dBObject2;
        }
        try {
            dBObject2 = dBObjectID.resolveID();
            return dBObject2;
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
            return null;
        }
    }

    final String toString(Object object, DBObject dBObject) {
        if (!(object instanceof Enum) || !this.m_mappings.useToString(object.getClass())) {
            DBObject dBObject2;
            if (ToStringManager.converterAvailable((Object)object)) {
                return ToStringManager.toString((Object)object);
            }
            if (object instanceof BaseObjectID && ((BaseObjectID)object).getName() != null) {
                return ((BaseObjectID)object).getName();
            }
            if (object instanceof DBObjectID && (dBObject2 = this.resolveID((DBObjectID)object, dBObject)) != null) {
                return dBObject2.getName();
            }
        }
        return object.toString();
    }

    final void processPropertyMapping(Node node, Document document, Object object, String string, String string2) {
        this.processPropertyMapping(node, document, object, string, string2, null);
    }

    final void processPropertyMapping(Node node, Document document, Object object, String string, String string2, SXMLValueConverter sXMLValueConverter) {
        SXMLMappings.Mapping mapping = new SXMLMappings.Mapping(string, string2, sXMLValueConverter);
        this.processPropertyMapping(node, document, object, mapping);
    }

    final void processPropertyMapping(Node node, Document document, Object object, SXMLMappings.Mapping mapping) {
        DBObject dBObject = object instanceof DBObject ? (DBObject)object : null;
        String string = mapping.getPropertyPath();
        Object object2 = string == null ? Boolean.valueOf(true) : this.getPropertyValue(object, string);
        SXMLValueConverter sXMLValueConverter = mapping.getConverter();
        if (sXMLValueConverter != null) {
            object2 = sXMLValueConverter.getXMLValue(object, object2);
        }
        if (object2 != null && object2 instanceof Object[] && ((Object[])object2).length == 0) {
            object2 = null;
        }
        if (object2 != null) {
            String string2 = mapping.getElementPath();
            int n = string2.lastIndexOf("//");
            if (object2 instanceof Object[]) {
                if (n == -1) {
                    throw new IllegalStateException("array property found but no matching list in the SXML");
                }
                String string3 = string2.substring(n + 2);
                string2 = string2.substring(0, n);
                Object[] objectArray = (Object[])object2;
                Node node2 = this.findOrCreateNode(document, node, string2);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    Node node3 = this.createNode(document, node2, string3);
                    this.processPropertyNode(node3, document, objectArray[i], dBObject);
                }
            } else {
                if (n > -1) {
                    throw new IllegalStateException("array marker found in element path (//) but property isn't an array.");
                }
                if (object2 instanceof Boolean) {
                    if (((Boolean)object2).booleanValue()) {
                        this.findOrCreateNode(document, node, string2);
                    }
                } else {
                    Node node4 = this.findOrCreateNode(document, node, string2);
                    this.processPropertyNode(node4, document, object2, dBObject);
                }
            }
        }
    }

    protected final boolean canRecurse(Object object) {
        return object instanceof Copyable && !(object instanceof DBObjectID);
    }

    private void processPropertyNode(Node node, Document document, Object object, DBObject dBObject) {
        if (this.canRecurse(object)) {
            this.populateNode(node, document, object);
        } else {
            Text text = document.createTextNode(this.toString(object, dBObject));
            if (node.getChildNodes().getLength() != 0) {
                Node node2 = node.getFirstChild();
                DBLog.getLogger((Object)this).log(Level.FINEST, "duplicate value {0} for property {1} was {2}", new Object[]{object, node.getNodeName(), node2.getTextContent()});
                node.replaceChild(text, node2);
            } else {
                node.appendChild(text);
            }
        }
    }

    private Object getPropertyValue(Object object, String string) {
        Object object2 = null;
        if (string.equals("!schema")) {
            SXMLFragmentGenerator sXMLFragmentGenerator;
            for (sXMLFragmentGenerator = this; sXMLFragmentGenerator != null && !(sXMLFragmentGenerator instanceof SXMLGenerator); sXMLFragmentGenerator = sXMLFragmentGenerator.getParentGenerator()) {
            }
            if (sXMLFragmentGenerator != null) {
                object2 = ((SXMLGenerator)sXMLFragmentGenerator).getTopLevelObjectSchemaName();
            }
        } else {
            object2 = this.m_propHelper.getPropertyValue(object, string);
        }
        return object2;
    }

    protected final Node findNode(Node node, String string) {
        return this.findNode(node, string.split("/"));
    }

    private Node findNode(Node node, String ... stringArray) {
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!string.equals(node3.getLocalName())) continue;
            node2 = node3;
            break;
        }
        if (node2 != null && stringArray2.length == 0) {
            return node2;
        }
        if (node2 != null) {
            return this.findNode(node2, stringArray2);
        }
        return null;
    }

    protected final boolean nodeExists(Node node, String string) {
        return this.findNode(node, string) != null;
    }

    protected final String nodeText(Node node, String string) {
        String string2 = null;
        Node node2 = this.findNode(node, string);
        if (node2 != null && node2.getChildNodes().getLength() <= 1 && (string2 = node2.getTextContent()) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected static final class childXMLElementIterator
    implements Iterator<Node> {
        NodeList m_children;
        int m_index = -1;

        public childXMLElementIterator(Node node) {
            this.m_children = node.getChildNodes();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() != -1;
        }

        @Override
        public Node next() {
            int n = this.nextIndex();
            if (n != -1) {
                this.m_index = n;
                return this.m_children.item(this.m_index);
            }
            return null;
        }

        @Override
        public void remove() {
        }

        private int nextIndex() {
            int n = -1;
            for (int i = this.m_index + 1; i < this.m_children.getLength(); ++i) {
                if (!(this.m_children.item(i) instanceof XMLElement)) continue;
                n = i;
                break;
            }
            return n;
        }
    }
}

