/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.CaseStatement;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WindowFunction;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SQLFragmentSXMLGenerator
extends SXMLFragmentGenerator {
    private static Map<String, List<String>> s_elementTypeMap;
    private static Map<Comparison.Comparator, String> s_comparisonMap;
    private static Map<ArithmeticOperation.ArithmeticOperator, String> s_arithOpsMap;
    private static List<String> s_genericXsdTypes;
    private static List<String> s_compoundExpressionGroup;
    private String m_schemaName;
    private boolean m_buildParsedSQL = false;

    public SQLFragmentSXMLGenerator() {
        SQLFragmentSXMLGenerator.buildMaps();
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        if (!(object instanceof SQLFragment)) {
            this.m_schemaName = this.getSchemaName(object);
            if (this.getParentGenerator() instanceof SXMLGenerator) {
                this.m_buildParsedSQL = ((SXMLGenerator)this.getParentGenerator()).isBuildParsedSQL();
            }
            if (object instanceof SQLQueryOwner) {
                this.processSQLQueryOwner(node, document, (SQLQueryOwner)object);
            } else if (object instanceof Index) {
                this.processIndex(node, document, (Index)object);
            } else if (object instanceof CheckConstraint) {
                this.processCheckConstraint(node, document, (CheckConstraint)object);
            } else if (!(object instanceof Constraint)) {
                throw new IllegalArgumentException("SQLFragmentSXMLGenerator called with object of unexpected class: " + object.getClass().getCanonicalName());
            }
        } else {
            boolean bl = this.processSQLFragment(node, document, (SQLFragment)object);
            if (!bl) {
                if (object instanceof SimpleSQLFragment) {
                    bl = this.processSimpleSQLFragment(node, document, (SimpleSQLFragment)object);
                } else if (object instanceof SQLQuery) {
                    bl = this.processSQLQuery(node, document, (SQLQuery)object);
                } else if (object instanceof SelectObject) {
                    bl = this.processSelectObject(node, document, (SelectObject)object);
                } else if (object instanceof FromObject) {
                    bl = this.processFromObject(node, document, (FromObject)object);
                } else if (object instanceof WhereObject) {
                    bl = this.processWhereObject(node, document, (WhereObject)object);
                } else if (object instanceof RelationUsage) {
                    bl = this.processRelationUsage(node, document, (RelationUsage)object);
                } else if (object instanceof JoinObject) {
                    bl = this.processJoinObject(node, document, (JoinObject)object);
                } else if (object instanceof AbstractFromObjectUsage) {
                    bl = this.processAbstractFromObjectUsage(node, document, (AbstractFromObjectUsage)object);
                } else if (object instanceof WindowFunction) {
                    bl = this.processWindowFunction(node, document, (WindowFunction)object);
                } else if (object instanceof WindowFunction.WindowFunctionBound) {
                    bl = this.processWindowFunctionBound(node, document, (WindowFunction.WindowFunctionBound)object);
                } else if (object instanceof Function) {
                    bl = this.processFunction(node, document, (Function)object);
                } else if (object instanceof FunctionUsage) {
                    bl = this.processFunctionUsage(node, document, (FunctionUsage)object);
                } else if (object instanceof OrderByObject) {
                    bl = this.processOrderByObject(node, document, (OrderByObject)object);
                } else if (object instanceof SetOperation) {
                    bl = this.processSetOperation(node, document, (SetOperation)object);
                } else if (object instanceof ExpressionList) {
                    bl = this.processExpressionList(node, document, (ExpressionList)object);
                } else if (object instanceof GroupByExpression) {
                    bl = this.processGroupByExpression(node, document, (GroupByExpression)object);
                } else if (object instanceof CaseStatement) {
                    bl = this.processCaseStatement(node, document, (CaseStatement)object);
                } else if (object instanceof CaseStatement.WhenThen) {
                    bl = this.processCaseStatementWhenThen(node, document, (CaseStatement.WhenThen)object);
                } else if (object instanceof DataMiningFunction) {
                    throw new UnsupportedTypeForSXMLException("No support for DataMiningFunction yet...");
                }
            }
            if (!bl) {
                throw new UnsupportedTypeForSXMLException(((SQLFragment)object).getSQLText() + " not supported (" + object.getClass().getCanonicalName() + ")");
            }
        }
    }

    private void processSQLQueryOwner(Node node, Document document, SQLQueryOwner sQLQueryOwner) {
        SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
        if (sQLQuery != null) {
            Node node2 = null;
            if (this.m_buildParsedSQL && sQLQuery.isDeclarative()) {
                Node node3 = this.findOrCreateNodeBefore(document, node, "PARSED_SUBQUERY", "CUSTOMER_AREA");
                try {
                    this.populateNode(node3, document, sQLQuery);
                    Node node4 = this.findOrCreateNode(document, node, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
                    node2 = this.createNode(document, node4, "SUBQUERY");
                }
                catch (UnsupportedTypeForSXMLException unsupportedTypeForSXMLException) {
                    node.removeChild(node3);
                }
            }
            if (node2 == null) {
                node2 = this.findOrCreateNodeBefore(document, node, "SUBQUERY", "CUSTOMER_AREA");
            }
            node2.appendChild(document.createTextNode(sQLQuery.getSQLText()));
        }
    }

    private void processIndex(Node node, Document document, Index index) {
        Node node2;
        Node node3 = this.findOrCreateNodeAfter(document, node, "TABLE_INDEX", "NAME");
        Node node4 = this.findOrCreateNodeAfter(document, node3, "COL_LIST", "ON_TABLE");
        Node node5 = null;
        if (this.m_buildParsedSQL) {
            try {
                for (IndexObject indexObject : index.getColumnExpressions()) {
                    node2 = this.createNode(document, node4, "COL_LIST_ITEM");
                    this.processMapping(node2, document, (SQLFragment)indexObject, "COLUMN_EXPRESSION", "expression");
                    this.processMapping(node2, document, (SQLFragment)indexObject, "DESC", "order", new ValueCheckingConverter("DESC"));
                }
                Node unsupportedTypeForSXMLException = this.findOrCreateNode(document, node, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
                node5 = this.createNode(document, unsupportedTypeForSXMLException, "COL_LIST");
            }
            catch (UnsupportedTypeForSXMLException unsupportedTypeForSXMLException) {
                node.removeChild(node3);
                node5 = this.findOrCreateNodeAfter(document, node3, "COL_LIST", "ON_TABLE");
            }
        } else {
            node5 = node4;
        }
        for (IndexObject indexObject : index.getColumnExpressions()) {
            node2 = this.createNode(document, node5, "COL_LIST_ITEM");
            Node node6 = this.createNode(document, node2, "NAME");
            String string = indexObject.getExpressionSource();
            SQLFragment sQLFragment = indexObject.getExpression();
            if (!(sQLFragment == null || sQLFragment instanceof ColumnUsage && indexObject.getOrderType() != IndexObject.OrderType.DESC)) {
                sQLFragment = (SQLFragment)sQLFragment.copyTo(null);
                this.markColumnUsages(sQLFragment);
                string = sQLFragment.getSQLText();
            }
            node6.appendChild(document.createTextNode(string));
            this.processMapping(node2, document, (SQLFragment)indexObject, "DESC", "order", new ValueCheckingConverter("DESC"));
        }
    }

    private void processCheckConstraint(Node node, Document document, CheckConstraint checkConstraint) {
        SQLFragment sQLFragment;
        Node node2 = null;
        if (this.m_buildParsedSQL && !((sQLFragment = checkConstraint.getCheckConditionFragment()) instanceof SimpleSQLFragment)) {
            Node node3 = this.findOrCreateNodeAfter(document, node, "PARSED_CONDITION", "NAME");
            try {
                this.populateNode(node3, document, sQLFragment);
                Node node4 = this.findOrCreateNode(document, node, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
                node2 = this.createNode(document, node4, "CONDITION");
            }
            catch (UnsupportedTypeForSXMLException unsupportedTypeForSXMLException) {
                node.removeChild(node3);
            }
        }
        if (node2 == null) {
            node2 = this.findOrCreateNodeAfter(document, node, "CONDITION", "NAME");
        }
        node2.appendChild(document.createTextNode(checkConstraint.getCheckCondition()));
    }

    private boolean processSQLFragment(Node node, Document document, SQLFragment sQLFragment) {
        boolean bl = false;
        String string = this.getElementName(sQLFragment);
        if (s_elementTypeMap.containsKey(string)) {
            bl = true;
            for (String dBObjectArray : s_elementTypeMap.get(string)) {
                if (s_genericXsdTypes.contains(dBObjectArray)) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            Node node2 = this.createNode(document, node, string);
            for (DBObject dBObject : sQLFragment.getOwnedObjects(new String[]{"SQLFragment"})) {
                this.populateNode(node2, document, dBObject);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processSimpleSQLFragment(Node node, Document document, SimpleSQLFragment simpleSQLFragment) {
        String string = simpleSQLFragment.getSQLText();
        if (simpleSQLFragment.getParent() instanceof Function && "TRANSLATE".equals(((Function)simpleSQLFragment.getParent()).getFunction()) && !",".equals(((Function)simpleSQLFragment.getParent()).getSeparator().trim())) {
            this.processMapping(node, document, (SQLFragment)simpleSQLFragment, "USING_CS", "SQLText");
            return true;
        }
        if (string != null && (simpleSQLFragment.getParent() instanceof SelectObject || simpleSQLFragment.getParent() instanceof Operation || simpleSQLFragment.getParent() instanceof OrderByObject)) {
            Node node2 = null;
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)(string = string.trim()), (String[])new String[0]);
            if (((PlSqlToken)plSqlToken.getNextCodeToken()).getType() == Token.Type.END_MARKER && plSqlToken.getType() == Token.Type.SINGLE_QUOTED_STRING) {
                node2 = this.createNode(document, node, "STRING");
                string = string.substring(1, string.length() - 1);
                string = string.replaceAll("''", "'");
            } else {
                try {
                    Float f = new Float(string);
                    node2 = this.createNode(document, node, "LITERAL");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (node2 == null) return false;
            node2.appendChild(document.createTextNode(string));
            return true;
        }
        if (!(simpleSQLFragment.getParent() instanceof FromObject) || !string.toUpperCase().equals("DUAL")) return false;
        Node node3 = this.createNode(document, node, "TABLE");
        node3.appendChild(document.createTextNode("DUAL"));
        return true;
    }

    private boolean processSQLQuery(Node node, Document document, SQLQuery sQLQuery) {
        Node node2 = this.createNode(document, node, "QUERY");
        this.processMapping(node2, document, (SQLFragment)sQLQuery, "SELECT/SELECT_LIST//SELECT_LIST_ITEM", "selectObjects");
        this.processMapping(node2, document, (SQLFragment)sQLQuery, "FROM//FROM_ITEM", "fromObjects");
        this.processMapping(node2, document, (SQLFragment)sQLQuery, "WHERE", "whereObject");
        this.processMapping(node2, document, (SQLFragment)sQLQuery, "GROUP_BY/EXPRESSION_LIST//EXPRESSION_LIST_ITEM", "groupByObject/expressions");
        this.processMapping(node2, document, (SQLFragment)sQLQuery, "HAVING", "groupByObject/having");
        this.processMapping(node2, document, (SQLFragment)sQLQuery, "ORDER_BY/ORDER_BY_LIST//ORDER_BY_LIST_ITEM", "orderByObjects/expression");
        return true;
    }

    private boolean processSelectObject(Node node, Document document, SelectObject selectObject) {
        this.processMapping(node, document, (SQLFragment)selectObject, "", "expression");
        this.processMapping(node, document, (SQLFragment)selectObject, "COLUMN_ALIAS", "alias", new InternaliseAliasConverter());
        return true;
    }

    private boolean processFromObject(Node node, Document document, FromObject fromObject) {
        this.processMapping(node, document, (SQLFragment)fromObject, "", "expression");
        this.processMapping(node, document, (SQLFragment)fromObject, "TABLE_ALIAS", "alias", new InternaliseAliasConverter());
        return true;
    }

    private boolean processWhereObject(Node node, Document document, WhereObject whereObject) {
        Node node2 = node;
        if (whereObject instanceof OnJoinCondition) {
            node2 = this.createNode(document, node2, "ON");
        }
        if (whereObject.getArgumentCount() != 1) {
            node2 = this.createNode(document, node2, whereObject.getOperatorText());
        }
        this.processMapping(node2, document, (SQLFragment)whereObject, "//", "arguments");
        return true;
    }

    private boolean processRelationUsage(Node node, Document document, RelationUsage relationUsage) {
        this.processMapping(node, document, (SQLFragment)relationUsage, "SCHEMA", "objectID/schema/name", new OnlyIfDifferentConverter(this.m_schemaName));
        this.processMapping(node, document, (SQLFragment)relationUsage, "TABLE", "objectID/name");
        return true;
    }

    private boolean processJoinObject(Node node, Document document, JoinObject joinObject) {
        Node node2 = this.createNode(document, node, "JOIN");
        if (joinObject.isNatural() && !joinObject.isOuterJoin()) {
            this.processMapping(node2, document, (SQLFragment)joinObject, "NATURAL_INNER", "joinType", new ValueCheckingConverter("INNER"));
        } else {
            if (joinObject.isNatural() && !joinObject.isOuterJoin()) {
                this.processMapping(node2, document, (SQLFragment)joinObject, "NATURAL", "natural");
            }
            this.processMapping(node2, document, (SQLFragment)joinObject, "INNER", "joinType", new ValueCheckingConverter("INNER"));
            this.processMapping(node2, document, (SQLFragment)joinObject, "CROSS", "joinType", new ValueCheckingConverter("CROSS"));
            this.processMapping(node2, document, (SQLFragment)joinObject, "LEFT_OUTER_JOIN", "joinType", new ValueCheckingConverter("LEFT"));
            this.processMapping(node2, document, (SQLFragment)joinObject, "FULL_OUTER_JOIN", "joinType", new ValueCheckingConverter("FULL"));
            this.processMapping(node2, document, (SQLFragment)joinObject, "RIGHT_OUTER_JOIN", "joinType", new ValueCheckingConverter("RIGHT"));
        }
        this.processMapping(node2, document, (SQLFragment)joinObject, "JOIN_TABLE_1", "leftExpression");
        this.processMapping(node2, document, (SQLFragment)joinObject, "JOIN_TABLE_2", "rightExpression");
        if ("INNER".equals(joinObject.getJoinType()) && !joinObject.isNatural() || joinObject.isOuterJoin()) {
            if (joinObject.getCondition() instanceof OnJoinCondition) {
                this.processMapping(node2, document, (SQLFragment)joinObject, "", "condition");
            } else if (joinObject.getCondition() instanceof UsingJoinCondition) {
                this.processMapping(node2, document, (SQLFragment)joinObject, "USING//COLUMN", "condition/columns/objectID/name");
            }
        }
        return true;
    }

    private boolean processAbstractFromObjectUsage(Node node, Document document, AbstractFromObjectUsage abstractFromObjectUsage) {
        Node node2 = this.createNode(document, node, "COLUMN_REF");
        this.processMapping(node2, document, (SQLFragment)abstractFromObjectUsage, "SCHEMA", "objectID/parent/schemaName", new OnlyIfDifferentConverter(this.m_schemaName));
        this.processMapping(node2, document, (SQLFragment)abstractFromObjectUsage, "TABLE", "objectID/parent/name");
        if (abstractFromObjectUsage instanceof SelectObjectUsage) {
            SelectObjectUsage selectObjectUsage = (SelectObjectUsage)abstractFromObjectUsage;
            SelectObject selectObject = selectObjectUsage.resolveSelectObject();
            if (selectObject != null) {
                this.processMapping(node2, document, (SQLFragment)selectObject, "COLUMN", "name", new InternaliseAliasConverter());
            } else if (selectObjectUsage.getSelectObjectID() instanceof BaseObjectID) {
                String string = ((BaseObjectID)selectObjectUsage.getSelectObjectID()).getName();
                Node node3 = this.createNode(document, node2, "COLUMN");
                node3.appendChild(document.createTextNode(string));
            }
        } else {
            this.processMapping(node2, document, (SQLFragment)abstractFromObjectUsage, "COLUMN", "columnName");
        }
        this.processMapping(node2, document, (SQLFragment)abstractFromObjectUsage, "OUTER_JOIN_OP", "objectID/outerJoin");
        return true;
    }

    private boolean processOrderByObject(Node node, Document document, OrderByObject orderByObject) {
        Node node2 = node;
        if ("ASC".equals(orderByObject.getOrder()) && "NULLS FIRST".equals(orderByObject.getNullOrdering())) {
            node2 = this.createNode(document, node, "ASC_NULLS_FIRST");
        } else if ("DESC".equals(orderByObject.getOrder()) && "NULLS LAST".equals(orderByObject.getNullOrdering())) {
            node2 = this.createNode(document, node, "DESC_NULLS_LAST");
        } else if ("DESC".equals(orderByObject.getOrder())) {
            node2 = this.createNode(document, node, "DESC");
        }
        this.populateNode(node2, document, orderByObject.getExpression());
        return true;
    }

    private boolean processSetOperation(Node node, Document document, SetOperation setOperation) {
        block14: {
            SetOperation.Operator operator;
            block12: {
                block13: {
                    operator = setOperation.getOperator();
                    if (setOperation.getArgumentCount() != 2 || !(setOperation.getArguments()[1] instanceof SQLQuery)) break block12;
                    if (operator != SetOperation.Operator.IN) break block13;
                    Node node2 = this.createNode(document, node, "EQ");
                    this.populateNode(node2, document, setOperation.getArguments()[0]);
                    Node node3 = this.createNode(document, node2, "ANY");
                    this.populateNode(node3, document, setOperation.getArguments()[1]);
                    break block14;
                }
                if (operator != SetOperation.Operator.NOT_IN) break block14;
                Node node4 = this.createNode(document, node, "NE");
                this.populateNode(node4, document, setOperation.getArguments()[0]);
                Node node5 = this.createNode(document, node4, "ALL");
                this.populateNode(node5, document, setOperation.getArguments()[1]);
                break block14;
            }
            if (operator == SetOperation.Operator.IN) {
                Node node6 = this.createNode(document, node, "OR");
                for (int i = 1; i < setOperation.getArgumentCount(); ++i) {
                    Node node7 = this.createNode(document, node6, "EQ");
                    this.populateNode(node7, document, setOperation.getArguments()[0]);
                    this.populateNode(node7, document, setOperation.getArguments()[i]);
                }
            } else if (operator == SetOperation.Operator.NOT_IN) {
                Node node8 = this.createNode(document, node, "AND");
                for (int i = 1; i < setOperation.getArgumentCount(); ++i) {
                    Node node9 = this.createNode(document, node8, "NE");
                    this.populateNode(node9, document, setOperation.getArguments()[0]);
                    this.populateNode(node9, document, setOperation.getArguments()[i]);
                }
            } else if (operator == SetOperation.Operator.BETWEEN) {
                Node node10 = this.createNode(document, node, "AND");
                Node node11 = this.createNode(document, node10, "GE");
                this.populateNode(node11, document, setOperation.getArguments()[0]);
                this.populateNode(node11, document, setOperation.getArguments()[1]);
                Node node12 = this.createNode(document, node10, "LE");
                this.populateNode(node12, document, setOperation.getArguments()[0]);
                this.populateNode(node12, document, setOperation.getArguments()[2]);
            } else if (operator == SetOperation.Operator.NOT_BETWEEN) {
                Node node13 = this.createNode(document, node, "OR");
                Node node14 = this.createNode(document, node13, "LT");
                this.populateNode(node14, document, setOperation.getArguments()[0]);
                this.populateNode(node14, document, setOperation.getArguments()[1]);
                Node node15 = this.createNode(document, node13, "GT");
                this.populateNode(node15, document, setOperation.getArguments()[0]);
                this.populateNode(node15, document, setOperation.getArguments()[2]);
            } else if (operator == SetOperation.Operator.EQUALS_ANY) {
                Node node16 = this.createNode(document, node, "OR");
                for (int i = 1; i < setOperation.getArgumentCount(); ++i) {
                    Node node17 = this.createNode(document, node16, "EQ");
                    this.populateNode(node17, document, setOperation.getArguments()[0]);
                    this.populateNode(node17, document, setOperation.getArguments()[i]);
                }
            }
        }
        return true;
    }

    private boolean processCaseStatement(Node node, Document document, CaseStatement caseStatement) {
        Node node2 = this.createNode(document, node, "CASE");
        this.processMapping(node2, document, (SQLFragment)caseStatement, "//WHEN", "whenThens");
        this.processMapping(node2, document, (SQLFragment)caseStatement, "ELSE", "elseExpression");
        return true;
    }

    private boolean processCaseStatementWhenThen(Node node, Document document, CaseStatement.WhenThen whenThen) {
        this.processMapping(node, document, (SQLFragment)whenThen, "", "whenExpression");
        this.processMapping(node, document, (SQLFragment)whenThen, "THEN", "thenExpression");
        return true;
    }

    private boolean processExpressionList(Node node, Document document, ExpressionList expressionList) {
        Node node2 = this.createNode(document, node, "EXPRESSION_LIST");
        this.processMapping(node2, document, (SQLFragment)expressionList, "//EXPRESSION_LIST_ITEM", "arguments");
        return true;
    }

    private boolean processFunction(Node node, Document document, Function function) {
        boolean bl = false;
        if ("COUNT".equals(function.getFunction())) {
            Node node2 = this.createNode(document, node, "COUNT");
            if (function.isDistinct()) {
                node2 = this.createNode(document, node2, "DISTINCT");
            }
            boolean bl2 = false;
            if (function.getArgumentCount() == 1 && function.getArguments()[0] instanceof ColumnKeywordUsage && "*".equals(((ColumnKeywordUsage)function.getArguments()[0]).getColumnName())) {
                bl2 = true;
            }
            if (!bl2) {
                this.processMapping(node2, document, (SQLFragment)function, "//", "arguments");
            }
            bl = true;
        } else if ("CAST".equals(function.getFunction())) {
            Node node3 = this.createNode(document, node, "CAST");
            this.populateNode(node3, document, function.getArguments()[0]);
            Node node4 = this.createNode(document, node3, "AS_TYPE");
            DataTypeSXMLGenerator dataTypeSXMLGenerator = new DataTypeSXMLGenerator();
            dataTypeSXMLGenerator.setParentGenerator(this.getParentGenerator());
            dataTypeSXMLGenerator.populateNode(node4, document, function.getArguments()[1]);
            bl = true;
        } else if ("TRIM".equals(function.getFunction())) {
            String string = "TRIM";
            if (function.getTrimLeader() != null) {
                if (function.getTrimLeader().trim().startsWith("LEADING")) {
                    string = "LTRIM";
                } else if (function.getTrimLeader().trim().startsWith("TRAILING")) {
                    string = "RTRIM";
                }
            }
            Node node5 = this.createNode(document, node, string);
            for (int i = function.getArgumentCount(); i > 0; --i) {
                this.populateNode(node5, document, function.getArguments()[i - 1]);
            }
            bl = true;
        }
        return bl;
    }

    private boolean processFunctionUsage(Node node, Document document, FunctionUsage functionUsage) {
        DBObjectID dBObjectID = functionUsage.getObjectID();
        if (dBObjectID instanceof BaseObjectID) {
            Node node2;
            Object object;
            BaseObjectID baseObjectID = (BaseObjectID)dBObjectID;
            String string = baseObjectID.getSchemaName();
            String string2 = null;
            String string3 = null;
            if (baseObjectID.getParent() instanceof BaseObjectID) {
                object = (BaseObjectID)baseObjectID.getParent();
                string = object.getSchemaName();
                string2 = object.getType();
                string3 = object.getName();
            }
            object = this.createNode(document, node, "FUNCTION_EXPR");
            Node node3 = this.createNode(document, (Node)object, "FUNCTION_REF");
            if (string != null && !string.equals(this.m_schemaName)) {
                node2 = this.createNode(document, node3, "SCHEMA");
                node2.appendChild(document.createTextNode(string));
            }
            if (string2 != null && !"UNSPECIFIED_TYPE".equals(string2)) {
                node2 = this.createNode(document, node3, string2);
                node2.appendChild(document.createTextNode(string3));
            }
            this.processMapping(node3, document, (SQLFragment)functionUsage, "FUNCTION", "objectID/name");
            this.processMapping((Node)object, document, (SQLFragment)functionUsage, "ARG_LIST//ARG_LIST_ITEM", "arguments");
        }
        return true;
    }

    private boolean processGroupByExpression(Node node, Document document, GroupByExpression groupByExpression) {
        Node node2 = this.createNode(document, node, groupByExpression.getGroupByType().toString());
        this.processMapping(node2, document, (SQLFragment)groupByExpression, "EXPRESSION_LIST//EXPRESSION_LIST_ITEM", "arguments");
        return true;
    }

    private boolean processWindowFunction(Node node, Document document, WindowFunction windowFunction) {
        Object object;
        String string = windowFunction.getFunction();
        if ("COUNT".equals(string)) {
            this.processFunction(node, document, (Function)windowFunction);
        } else {
            object = this.createNode(document, node, string);
            for (SQLFragment sQLFragment : windowFunction.getArguments()) {
                this.populateNode((Node)object, document, sQLFragment);
            }
        }
        this.processMapping(node, document, (SQLFragment)windowFunction, string + "/OVER/PARTITION_BY//PARTITION_BY_ITEM", "partitionBy");
        this.processMapping(node, document, (SQLFragment)windowFunction, string + "/OVER/ORDER_BY/ORDER_BY_LIST//ORDER_BY_LIST_ITEM", "orderBy");
        object = "RANGE";
        if (windowFunction.getClauseType() == WindowFunction.ClauseType.ROWS) {
            object = "ROWS";
        }
        SQLFragment[] sQLFragmentArray = windowFunction.getBounds();
        SQLFragment[] sQLFragmentArray2 = null;
        if (sQLFragmentArray != null && sQLFragmentArray.length == 1) {
            sQLFragmentArray2 = new SQLFragment[2];
            sQLFragmentArray2[0] = (SQLFragment)sQLFragmentArray[0].copyTo(null);
            WindowFunction.WindowFunctionBound windowFunctionBound = new WindowFunction.WindowFunctionBound();
            windowFunctionBound.setBoundType(WindowFunction.BoundType.CURRENT_ROW);
            sQLFragmentArray2[1] = windowFunctionBound;
            windowFunction.setBounds(sQLFragmentArray2);
        }
        this.processMapping(node, document, (SQLFragment)windowFunction, string + "/OVER/ORDER_BY/" + (String)object + "/BETWEEN//BETWEEN_ITEM", "bounds");
        if (sQLFragmentArray2 != null) {
            windowFunction.setBounds(sQLFragmentArray);
        }
        return true;
    }

    private boolean processWindowFunctionBound(Node node, Document document, WindowFunction.WindowFunctionBound windowFunctionBound) {
        if (windowFunctionBound.getBoundExpr() == null || windowFunctionBound.getBoundExpr().length == 0) {
            if (!"CURRENT_ROW".equals(windowFunctionBound.getBoundType().toString())) {
                this.createNode(document, node, "UNBOUNDED");
            }
        } else {
            this.processMapping(node, document, (SQLFragment)windowFunctionBound, "//", "boundExpr");
        }
        this.createNode(document, node, windowFunctionBound.getBoundType().toString());
        return true;
    }

    private String getElementName(SQLFragment sQLFragment) {
        ArithmeticOperation arithmeticOperation;
        String string = null;
        if (sQLFragment instanceof Function && !(sQLFragment instanceof WindowFunction)) {
            string = ((Function)sQLFragment).getFunction();
            if ("TABLE".equals(string)) {
                string = "TABLE_FUNCTION";
            } else if ("TRIM".equals(string)) {
                string = null;
            } else if ("||".equals(string)) {
                string = "CONCAT";
            }
        } else if (sQLFragment instanceof Comparison) {
            Comparison comparison = (Comparison)sQLFragment;
            string = s_comparisonMap.get(comparison.getComparator());
            if (string == null && (string = comparison.getOperatorText()).contains(" ")) {
                string = string.replaceAll(" ", "_");
            }
        } else if (sQLFragment instanceof ArithmeticOperation && (string = s_arithOpsMap.get((arithmeticOperation = (ArithmeticOperation)sQLFragment).getOperator())) == null && (string = arithmeticOperation.getOperatorText()).contains(" ")) {
            string = string.replaceAll(" ", "_");
        }
        return string;
    }

    private static synchronized void buildMaps() {
        if (s_elementTypeMap == null) {
            DOMParser dOMParser = new DOMParser();
            String string = SQLFragmentSXMLGenerator.class.getPackage().getName().replaceAll("\\.", "/") + "/xsd/kusparse.xsd";
            URL uRL = SQLFragmentSXMLGenerator.class.getClassLoader().getResource(string);
            try {
                dOMParser.parse(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            XMLDocument xMLDocument = dOMParser.getDocument();
            Element element = xMLDocument.getDocumentElement();
            s_elementTypeMap = new HashMap<String, List<String>>();
            s_compoundExpressionGroup = new ArrayList<String>();
            SQLFragmentSXMLGenerator.addElementsToTypeMap(element);
            s_comparisonMap = new HashMap<Comparison.Comparator, String>();
            s_comparisonMap.put(Comparison.Comparator.EQUAL, "EQ");
            s_comparisonMap.put(Comparison.Comparator.LESS, "LT");
            s_comparisonMap.put(Comparison.Comparator.GREATER, "GT");
            s_comparisonMap.put(Comparison.Comparator.GREATER_EQUAL, "GE");
            s_comparisonMap.put(Comparison.Comparator.LESS_EQUAL, "LE");
            s_comparisonMap.put(Comparison.Comparator.NOT_EQUAL, "NE");
            s_arithOpsMap = new HashMap<ArithmeticOperation.ArithmeticOperator, String>();
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.NEGATE, "NEG");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.ADD, "ADD");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.SUBTRACT, "SUB");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.MULTIPLY, "MUL");
            s_arithOpsMap.put(ArithmeticOperation.ArithmeticOperator.DIVIDE, "DIV");
            s_genericXsdTypes = new ArrayList<String>();
            s_genericXsdTypes.add("NONE");
            s_genericXsdTypes.add("ku:EmptyType");
            s_genericXsdTypes.add("ku:intElementWithValue1");
            s_genericXsdTypes.add("ku:PrsUnaryExprOpType");
            s_genericXsdTypes.add("ku:PrsBinaryExprOpType");
            s_genericXsdTypes.add("ku:PrsNAryExprOpType");
            s_genericXsdTypes.add("ku:PrsUnaryLogicalOpType");
            s_genericXsdTypes.add("ku:PrsAnaryLogicalOpType");
            s_genericXsdTypes.add("ku:PrsBinaryOpType");
            s_genericXsdTypes.add("ku:PrsLikeOpType");
            s_genericXsdTypes.add("ku:PrsExpressionType");
            s_genericXsdTypes.add("ku:PrsColExpressionType");
            s_genericXsdTypes.add("ku:PrsROLLUPType");
            s_genericXsdTypes.add("ku:PrsTRANSLATEType");
            s_genericXsdTypes.add("ku:PrsAVGType");
        }
    }

    private static void addElementsToTypeMap(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("xsd:element".equals(node2.getNodeName())) {
                Node node3;
                String string = null;
                String string2 = null;
                Node node4 = node2.getAttributes().getNamedItem("name");
                if (node4 != null) {
                    string = node4.getTextContent();
                }
                string2 = (node3 = node2.getAttributes().getNamedItem("type")) != null ? node3.getTextContent() : "NONE";
                if (string != null) {
                    List<String> list = s_elementTypeMap.get(string);
                    if (list == null) {
                        list = new ArrayList<String>();
                        s_elementTypeMap.put(string, list);
                    }
                    if (!list.contains(string2)) {
                        list.add(string2);
                    }
                    if (SQLFragmentSXMLGenerator.isNodeInCompoundExpressionGroup(node2)) {
                        s_compoundExpressionGroup.add(string);
                    }
                }
            }
            SQLFragmentSXMLGenerator.addElementsToTypeMap(node2);
        }
    }

    private static boolean isNodeInCompoundExpressionGroup(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        if (node3 != null && (node2 = node3.getParentNode()) != null) {
            String string = null;
            Node node4 = node2.getAttributes().getNamedItem("name");
            if (node4 != null && "PrsCompoundExpressionGroup".equals(string = node4.getTextContent())) {
                return true;
            }
        }
        return false;
    }

    private void processMapping(Node node, Document document, SQLFragment sQLFragment, String string, String string2) {
        this.processMapping(node, document, sQLFragment, string, string2, null);
    }

    private void processMapping(Node node, Document document, SQLFragment sQLFragment, String string, String string2, SXMLValueConverter sXMLValueConverter) {
        SXMLMappings.Mapping mapping = new SXMLMappings.Mapping(string, string2, sXMLValueConverter);
        this.processPropertyMapping(node, document, sQLFragment, mapping);
    }

    private String getSchemaName(Object object) {
        if (object instanceof DBObject) {
            SchemaObject schemaObject;
            DBObject dBObject;
            for (dBObject = (DBObject)object; dBObject != null && !(dBObject instanceof SchemaObject); dBObject = dBObject.getParent()) {
            }
            if (dBObject instanceof SchemaObject && (schemaObject = (SchemaObject)dBObject).getSchema() != null) {
                return schemaObject.getSchema().getName();
            }
        }
        return null;
    }

    private void markColumnUsages(SQLFragment sQLFragment) {
        if (sQLFragment instanceof ColumnUsage) {
            ((ColumnUsage)sQLFragment).setAlwaysQuote(true);
        }
        for (DBObject dBObject : sQLFragment.getOwnedObjects()) {
            if (!(dBObject instanceof SQLFragment)) continue;
            this.markColumnUsages((SQLFragment)dBObject);
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        if (object instanceof SQLQueryOwner) {
            String string;
            SQLQueryOwner sQLQueryOwner = (SQLQueryOwner)object;
            Node node2 = node;
            if (this.nodeExists(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/SUBQUERY")) {
                node2 = this.findNode(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
            }
            if ((string = this.nodeText(node2, "SUBQUERY")) != null && string.length() > 0) {
                if (object instanceof View) {
                    if (string.trim().endsWith("WITH READ ONLY")) {
                        string = string.substring(0, string.lastIndexOf("WITH READ ONLY")).trim();
                        ((View)object).setRestriction(View.Restriction.READ_ONLY);
                    } else if (string.trim().endsWith("WITH CHECK OPTION")) {
                        string = string.substring(0, string.lastIndexOf("WITH CHECK OPTION")).trim();
                        ((View)object).setRestriction(View.Restriction.CHECK_OPTION);
                    }
                }
                sQLQueryOwner.setSQLQuery(new SQLQuery(string));
            }
        } else if (object instanceof CheckConstraint) {
            CheckConstraint checkConstraint = (CheckConstraint)object;
            Node node3 = node;
            if (this.nodeExists(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/CONDITION")) {
                node3 = this.findNode(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST");
            }
            checkConstraint.setCheckCondition(this.nodeText(node3, "CONDITION"));
        } else if (object instanceof Index) {
            SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
            Index index = (Index)object;
            ArrayList<IndexObject> arrayList = new ArrayList<IndexObject>();
            Node node4 = this.findNode(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COL_LIST");
            if (node4 == null) {
                node4 = this.findNode(node, "TABLE_INDEX/COL_LIST");
            }
            SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node4);
            while (childXMLElementIterator2.hasNext()) {
                Node node5 = (Node)childXMLElementIterator2.next();
                IndexObject indexObject = new IndexObject();
                String string = this.nodeText(node5, "NAME");
                indexObject.setExpressionSource(string);
                if (this.nodeExists(node5, "DESC")) {
                    indexObject.setOrderType(IndexObject.OrderType.DESC);
                }
                arrayList.add(indexObject);
            }
            index.setColumnExpressions(arrayList.toArray(new IndexObject[arrayList.size()]));
        }
    }

    public static final boolean isInCompoundExpressionGroup(String string) {
        SQLFragmentSXMLGenerator.buildMaps();
        return s_compoundExpressionGroup.contains(string);
    }

    class InternaliseAliasConverter
    implements SXMLValueConverter {
        InternaliseAliasConverter() {
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (object2 instanceof String) {
                String string = ((String)object2).trim();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    return string.substring(1, string.length() - 1);
                }
                return string.toUpperCase();
            }
            return null;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return null;
        }
    }

    class OnlyIfDifferentConverter
    implements SXMLValueConverter {
        private Object m_value;

        OnlyIfDifferentConverter(Object object) {
            this.m_value = object;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            if (ModelUtil.areEqual((Object)object2, (Object)this.m_value)) {
                return null;
            }
            return object2;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            return null;
        }
    }

    class ValueCheckingConverter
    implements SXMLValueConverter {
        private Object[] m_values;

        ValueCheckingConverter(Object ... objectArray) {
            this.m_values = objectArray;
        }

        @Override
        public Object getXMLValue(Object object, Object object2) {
            for (Object object3 : this.m_values) {
                if (!ModelUtil.areEqual((Object)object2, (Object)object3)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getBeanValue(Object object, Object object2) {
            if (object2 instanceof Boolean) {
                return (Boolean)object2 != false ? this.m_values[0] : null;
            }
            return this.m_values[0];
        }
    }
}

