/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DataTypeSXMLGenerator
extends SXMLFragmentGenerator {
    private static Map<String, TypesFromXSD> s_dtMap;
    private static final String DEFAULTED_SCALE = "CUSTOMER_AREA/ODB_PROPERTY_LIST/DEFAULTED_SCALE";
    private static final String DERIVED_DATATYPE = "CUSTOMER_AREA/ODB_PROPERTY_LIST/DERIVED_DATATYPE";

    DataTypeSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        Object object2;
        Object object3;
        Object object4;
        SQLFragment sQLFragment;
        DataTypeUsage dataTypeUsage = null;
        Node node2 = null;
        boolean bl = false;
        if (object instanceof Column) {
            if (!(((Column)object).getRelation() instanceof View)) {
                node2 = this.findOrCreateNodeAfter(document, node, "DATATYPE", "NAME");
                dataTypeUsage = ((Column)object).getDataTypeUsage();
                if (dataTypeUsage == null && ((Column)object).getVirtualExpressionSource() != null) {
                    node2.appendChild(document.createTextNode("VARCHAR2"));
                    this.createNode(document, node, DERIVED_DATATYPE);
                }
            }
        } else if (object instanceof SQLFragment) {
            sQLFragment = (SQLFragment)object;
            object4 = this.getProvider((DBObject)sQLFragment, true);
            if (object4 != null) {
                object3 = sQLFragment.getSQLText();
                dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)object4, null, (String)object3);
                node2 = this.createNode(document, node, "DATATYPE");
            }
        } else if (object instanceof DBObjectPlSqlFragment) {
            if (object instanceof PlSqlAttribute) {
                node2 = this.findOrCreateNodeAfter(document, node, "DATATYPE", "NAME");
                sQLFragment = ((PlSqlAttribute)object).getDataTypeReference();
            } else if (object instanceof PlSqlParameter) {
                object4 = (PlSqlParameter)object;
                sQLFragment = object4.getDataTypeReference();
                node2 = this.nodeExists(node, "NO_COPY") ? this.findOrCreateNodeAfter(document, node, "DATATYPE", "NO_COPY") : (this.nodeExists(node, "IN_OUT") ? this.findOrCreateNodeAfter(document, node, "DATATYPE", "IN_OUT") : (this.nodeExists(node, "OUT") ? this.findOrCreateNodeAfter(document, node, "DATATYPE", "OUT") : this.findOrCreateNodeAfter(document, node, "DATATYPE", "NAME")));
            } else if (object instanceof PlSqlMethod) {
                object4 = (PlSqlMethod)object;
                sQLFragment = object4.getReturnTypeReference();
                node2 = this.createNode(document, node, "DATATYPE");
            } else if (object instanceof Type) {
                object4 = (Type)object;
                if ("COLLECTION".equals(object4.getTypeCode())) {
                    if ("VARYING ARRAY".equals(object4.getCollectionType())) {
                        object3 = this.findOrCreateNode(document, node, "VARRAY");
                        if (object4.getLimit() != null) {
                            object2 = this.findOrCreateNode(document, (Node)object3, "LIMIT");
                            object2.appendChild(document.createTextNode(object4.getLimit().toString()));
                        }
                    } else {
                        object3 = this.findOrCreateNode(document, node, "NESTED_TABLE");
                    }
                    node2 = this.findOrCreateNode(document, (Node)object3, "DATATYPE");
                    sQLFragment = object4.getOfTypeUsageReference();
                } else {
                    sQLFragment = null;
                }
            } else {
                sQLFragment = null;
            }
            if (sQLFragment != null) {
                dataTypeUsage = sQLFragment.getDataTypeUsage();
                if (dataTypeUsage == null) {
                    dataTypeUsage = new DataTypeUsage();
                    dataTypeUsage.setDataTypeID(sQLFragment.getReferenceID());
                }
                boolean bl2 = bl = sQLFragment.getReferenceType() == PlSqlReference.ReferenceType.REF;
            }
        }
        if (dataTypeUsage != null) {
            try {
                sQLFragment = DataTypeHelper.getDataType(dataTypeUsage, (boolean)false);
                if (sQLFragment == null) {
                    sQLFragment = this.createType((BaseObjectID)dataTypeUsage.getDataTypeID());
                }
                if (sQLFragment == null) {
                    object4 = DataTypeHelper.getDDL((DataTypeUsage)dataTypeUsage);
                    this.addErrorMessage(object, "Unrecognized datatype " + (String)object4);
                } else {
                    object4 = bl ? "REF" : DataTypeSXMLGenerator.getDataTypeElementText((DataType)sQLFragment, dataTypeUsage);
                }
                node2.appendChild(document.createTextNode((String)object4));
                if (sQLFragment instanceof Type) {
                    Node node3;
                    object3 = ((Type)sQLFragment).getSchema();
                    object2 = ((String)object4).equals("XMLTYPE") ? object4 : ((Type)sQLFragment).getName();
                    if (object3 != null) {
                        node3 = this.findOrCreateNodeAfter(document, node2.getParentNode(), "TYPE_PROPERTIES/SCHEMA", "DATATYPE");
                        node3.appendChild(document.createTextNode(object3.getName()));
                    }
                    if (ModelUtil.hasLength((String)object2)) {
                        node3 = this.findOrCreateNodeAfter(document, node2.getParentNode(), "TYPE_PROPERTIES/NAME", "DATATYPE");
                        node3.appendChild(document.createTextNode((String)object2));
                    }
                } else {
                    Object object5;
                    object3 = dataTypeUsage.getAttributeValue("scale");
                    if (object3 == null && "TIMESTAMP".equals(object4)) {
                        object3 = 6;
                        if (object instanceof Column) {
                            this.findOrCreateNode(document, node, DEFAULTED_SCALE);
                        }
                    }
                    if (object3 != null) {
                        object2 = this.findOrCreateNodeAfter(document, node2.getParentNode(), "scale".toUpperCase(), "DATATYPE");
                        object2.appendChild(document.createTextNode(object3.toString()));
                    }
                    if ((object2 = dataTypeUsage.getAttributeValue("precision")) != null) {
                        object5 = this.findOrCreateNodeAfter(document, node2.getParentNode(), "precision".toUpperCase(), "DATATYPE");
                        object5.appendChild(document.createTextNode(object2.toString()));
                    }
                    if ((object5 = dataTypeUsage.getAttributeValue("size")) != null) {
                        Node node4 = this.findOrCreateNodeAfter(document, node2.getParentNode(), "LENGTH", "DATATYPE");
                        node4.appendChild(document.createTextNode(object5.toString()));
                    }
                    if ("CHAR".equals(dataTypeUsage.getAttributeValue("unit"))) {
                        this.findOrCreateNodeAfter(document, node2.getParentNode(), "CHAR_SEMANTICS", "LENGTH");
                    }
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)this).warning(dBException.getMessage());
            }
        }
    }

    private Type createType(BaseObjectID baseObjectID) {
        Object object;
        Type type = null;
        String string = baseObjectID.getSchemaName();
        try {
            object = baseObjectID.getParent();
            if (object instanceof BaseObjectID) {
                string = ((BaseObjectID)object).getName();
                DBObject dBObject = object.resolveID();
                if (dBObject instanceof Schema) {
                    string = dBObject.getName();
                }
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        object = baseObjectID.getName();
        type = new Type();
        type.setName((String)object);
        type.setSchema(new Schema(string));
        type.setTypeCode("OBJECT");
        return type;
    }

    private void addErrorMessage(Object object, String string) {
        if (object instanceof Type) {
            Type type = (Type)object;
            String string2 = "Type " + type.getName();
        } else if (object instanceof PlSqlAttribute) {
            Type type = (Type)((PlSqlAttribute)object).getParent();
            String string3 = "Attribute " + type.getName() + "." + ((PlSqlAttribute)object).getName();
        } else if (object instanceof PlSqlMethod) {
            Type type = (Type)((PlSqlMethod)object).getParent();
            String string4 = "Method " + type.getName() + "." + ((PlSqlMethod)object).getName();
        } else if (object instanceof PlSqlParameter) {
            PlSqlMethod plSqlMethod = (PlSqlMethod)((PlSqlParameter)object).getParent();
            Type type = (Type)plSqlMethod.getParent();
            String string5 = "Parameter " + type.getName() + "." + plSqlMethod.getName() + "." + ((PlSqlParameter)object).getName();
        } else {
            return;
        }
    }

    static final String getDataTypeElementText(DataType dataType, DataTypeUsage dataTypeUsage) {
        String string = null;
        if (dataType instanceof Type) {
            String string2 = ((Type)dataType).getCollectionType();
            string = "TABLE".equals(string2) ? "NESTED_TABLE" : ("VARYING ARRAY".equals(string2) ? "VARRAY" : ("SYS".equals(((Type)dataType).getSchema().getName()) && "XMLTYPE".equalsIgnoreCase(((Type)dataType).getName()) ? "XMLTYPE" : "UDT"));
        } else if (dataType != null) {
            Map<String, TypesFromXSD> map = DataTypeSXMLGenerator.getDatatypeMap();
            if (map.containsKey(string = dataType.getName())) {
                string = map.get(string).toString();
            }
            if ("TIMESTAMP".equals(string)) {
                Object object = dataTypeUsage.getAttributeValue("time_zone");
                if ("TIME ZONE".equals(object)) {
                    string = TypesFromXSD.TIMESTAMP_WITH_TIMEZONE.toString();
                } else if ("LOCAL TIME ZONE".equals(object)) {
                    string = TypesFromXSD.TIMESTAMP_WITH_LOCAL_TIMEZONE.toString();
                }
            }
        }
        if (string == null) {
            DBLog.getLogger(DataTypeSXMLGenerator.class).log(Level.WARNING, "SXML - Invalid datatype: \"{0}\" ", new Object[]{dataType == null ? null : dataType.getName()});
        }
        return string;
    }

    @Override
    protected void readNode(Node node, Object object) {
        String string;
        String string2 = this.nodeText(node, "DATATYPE");
        DataTypeUsage dataTypeUsage = null;
        if ("NESTED_TABLE".equals(string2) || "VARRAY".equals(string2) || "XMLTYPE".equals(string2) || "UDT".equals(string2)) {
            DBObjectProvider dBObjectProvider;
            SXMLReader sXMLReader;
            string = this.nodeText(node, "TYPE_PROPERTIES/SCHEMA");
            String string3 = this.nodeText(node, "TYPE_PROPERTIES/NAME");
            if ("XMLTYPE".equalsIgnoreCase(string3)) {
                string3 = "XMLTYPE";
            }
            if ("XMLTYPE".equals(string2)) {
                if (string == null) {
                    string = "SYS";
                    sXMLReader = new Schema(string);
                }
                if ((dBObjectProvider = (sXMLReader = (SXMLReader)this.getParentGenerator()).getProvider()) != null) {
                    dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)dBObjectProvider, null, (String)(string + "." + string2));
                }
            }
            if (dataTypeUsage == null) {
                NameBasedID nameBasedID;
                sXMLReader = new Schema(string);
                dBObjectProvider = new Type();
                dBObjectProvider.setName(string3);
                dBObjectProvider.setSchema((Schema)sXMLReader);
                DBObjectID dBObjectID = null;
                DBObjectProvider dBObjectProvider2 = ((SXMLReader)this.getParentGenerator()).getProvider();
                if (dBObjectProvider2 != null) {
                    try {
                        nameBasedID = dBObjectProvider2.getObject("TYPE", (Schema)sXMLReader, string3);
                        if (nameBasedID instanceof Type) {
                            dBObjectID = nameBasedID.getID();
                        }
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                if (dBObjectID == null) {
                    nameBasedID = new NameBasedID();
                    nameBasedID.setName(string3);
                    nameBasedID.setSchema((Schema)sXMLReader);
                    nameBasedID.setType("TYPE");
                    dBObjectID = nameBasedID;
                }
                dBObjectProvider.setID(dBObjectID);
                if ("NESTED_TABLE".equals(string2)) {
                    dBObjectProvider.setTypeCode("COLLECTION");
                    dBObjectProvider.setCollectionType("TABLE");
                } else if ("VARRAY".equals(string2)) {
                    dBObjectProvider.setTypeCode("COLLECTION");
                    dBObjectProvider.setCollectionType("VARYING ARRAY");
                } else {
                    dBObjectProvider.setTypeCode("OBJECT");
                    dBObjectProvider.setCollectionType(null);
                }
                dataTypeUsage = new DataTypeUsage((DataType)dBObjectProvider);
            }
        } else if (string2 != null) {
            Object object2;
            string = DataTypeRegistry.getInstance();
            DataType dataType = string.findDataType(string2, Oracle11g.class);
            if (dataType == null) {
                try {
                    object2 = TypesFromXSD.valueOf(string2);
                    for (String string4 : DataTypeSXMLGenerator.getDatatypeMap().keySet()) {
                        if (!DataTypeSXMLGenerator.getDatatypeMap().get(string4).equals(object2)) continue;
                        string2 = string4;
                        dataType = string.findDataType(string2, Oracle11g.class);
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "SXML - Invalid column datatype \"{0}\"", string2);
                }
            }
            if (dataType != null) {
                String string5;
                String string4;
                dataTypeUsage = new DataTypeUsage(dataType);
                object2 = new HashMap();
                String string6 = this.nodeText(node, "LENGTH");
                if (string6 != null) {
                    ((HashMap)object2).put("size", Long.valueOf(string6));
                }
                if ((string4 = this.nodeText(node, "PRECISION")) != null) {
                    ((HashMap)object2).put("precision", Long.valueOf(string4));
                }
                if ((string5 = this.nodeText(node, "SCALE")) != null && !this.nodeExists(node, DEFAULTED_SCALE)) {
                    ((HashMap)object2).put("scale", Long.valueOf(string5));
                }
                if (this.nodeExists(node, "CHAR_SEMANTICS")) {
                    ((HashMap)object2).put("unit", "CHAR");
                }
                dataTypeUsage.setAttributeValues((Map)object2);
            }
        }
        if (object instanceof Column) {
            if (this.nodeExists(node, DERIVED_DATATYPE)) {
                dataTypeUsage = null;
            }
            ((Column)object).setDataTypeUsage(dataTypeUsage);
        } else {
            if (object instanceof PlSqlAttribute) {
                throw new UnsupportedOperationException("REVISIT... ((PlSqlAttribute)obj).setDataTypeUsage(dtu)");
            }
            if (object instanceof PlSqlAttribute) {
                throw new UnsupportedOperationException("REVISIT... ((PlSqlParameter)obj).setDataTypeID(dtu.getDataTypeID())");
            }
            if (object instanceof Type) {
                string = new PlSqlReference();
                string.setDataTypeUsage(dataTypeUsage);
                ((Type)object).setOfTypeUsageReference((PlSqlReference)string);
            }
        }
    }

    private static final synchronized Map<String, TypesFromXSD> getDatatypeMap() {
        if (s_dtMap == null) {
            s_dtMap = new HashMap<String, TypesFromXSD>();
            s_dtMap.put("CHAR VARYING", TypesFromXSD.VARCHAR2);
            s_dtMap.put("CHARACTER", TypesFromXSD.CHAR);
            s_dtMap.put("CHARACTER VARYING", TypesFromXSD.VARCHAR2);
            s_dtMap.put("DEC", TypesFromXSD.NUMBER);
            s_dtMap.put("DECIMAL", TypesFromXSD.NUMBER);
            s_dtMap.put("DOUBLE PRECISION", TypesFromXSD.NUMBER);
            s_dtMap.put("INT", TypesFromXSD.NUMBER);
            s_dtMap.put("INTEGER", TypesFromXSD.NUMBER);
            s_dtMap.put("INTERVAL YEAR", TypesFromXSD.INTERVAL_YEAR_TO_MONTH);
            s_dtMap.put("INTERVAL DAY", TypesFromXSD.INTERVAL_DAY_TO_SECOND);
            s_dtMap.put("LONG RAW", TypesFromXSD.LONG_RAW);
            s_dtMap.put("LONG VARCHAR", TypesFromXSD.CLOB);
            s_dtMap.put("NATIONAL CHAR", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHARACTER", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHAR VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NATIONAL CHARACTER VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NCHAR VARYING", TypesFromXSD.NCHAR);
            s_dtMap.put("NUMERIC", TypesFromXSD.NUMBER);
            s_dtMap.put("REAL", TypesFromXSD.NUMBER);
            s_dtMap.put("SMALLINT", TypesFromXSD.NUMBER);
            s_dtMap.put("VARCHAR", TypesFromXSD.VARCHAR2);
        }
        return s_dtMap;
    }

    private DBObjectProvider getProvider(DBObject dBObject, boolean bl) {
        this.getMappings();
        return SXMLMappings.getProvider(dBObject, bl);
    }

    private static enum TypesFromXSD {
        CHAR,
        VARCHAR2,
        NCHAR,
        NVARCHAR2,
        NUMBER,
        FLOAT,
        BINARY_FLOAT,
        BINARY_DOUBLE,
        LONG,
        LONG_RAW,
        RAW,
        DATE,
        TIMESTAMP,
        TIMESTAMP_WITH_TIMEZONE,
        TIMESTAMP_WITH_LOCAL_TIMEZONE,
        INTERVAL_YEAR_TO_MONTH,
        INTERVAL_DAY_TO_SECOND,
        TIME,
        TIME_WITH_TIMEZONE,
        BLOB,
        CLOB,
        NCLOB,
        BFILE,
        ROWID,
        UROWID,
        MLSLABEL,
        UDT,
        NESTED_TABLE,
        VARRAY,
        OPAQUE,
        REF,
        XMLTYPE;

    }
}

