/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class LiteralBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        List<ParseNode> list;
        SimpleSQLFragment simpleSQLFragment = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "literal")) {
            String string = oracleSQLQueryBuilderHelper.getContent(parseNode);
            simpleSQLFragment = new SimpleSQLFragment(string);
        } else if (oracleSQLQueryBuilderHelper.isLeaf(parseNode)) {
            if (oracleSQLQueryBuilderHelper.isKeyword(parseNode, "ROWNUM", "ROWID", "USER", "LEVEL", "SYSDATE", "CURRENT_DATE", "CURRENT_TIMESTAMP", "LOCALTIMESTAMP", "SYSTIMESTAMP", "BINARY_FLOAT_NAN", "BINARY_FLOAT_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_DOUBLE_INFINITY", "null")) {
                simpleSQLFragment = new SimpleSQLFragment(oracleSQLQueryBuilderHelper.getContent(parseNode).toUpperCase());
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "identifier") && !oracleSQLQueryBuilderHelper.isRule(parseNode, "column") || oracleSQLQueryBuilderHelper.isRule(parseNode, "identifier") && oracleSQLQueryBuilderHelper.isRule(parseNode, "column") && expressionContext.getQueryContext() instanceof String && "MAKE_REF".equalsIgnoreCase((String)expressionContext.getQueryContext())) {
                String string = oracleSQLQueryBuilderHelper.getContent(parseNode);
                simpleSQLFragment = new SimpleSQLFragment(string);
            } else {
                String string = oracleSQLQueryBuilderHelper.getContent(parseNode);
                if (string != null && (string.startsWith("'") || Character.isDigit(string.charAt(0)))) {
                    simpleSQLFragment = new SimpleSQLFragment(string);
                }
            }
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "bind_var") && (list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode)).size() == 2 && oracleSQLQueryBuilderHelper.isKeyword(list.get(0), ":") && oracleSQLQueryBuilderHelper.isRule(list.get(1), "identifier")) {
            String string = oracleSQLQueryBuilderHelper.getContent(parseNode);
            simpleSQLFragment = new SimpleSQLFragment(string);
            if (expressionContext.getQuery().getParent() instanceof Relation && string.startsWith(":")) {
                expressionContext.getQueryBuilder().addClauseException(new SQLQueryClauseException((SQLFragment)simpleSQLFragment, APIBundle.format((String)"SQL_BIND_VAR", (Object[])new Object[]{string})));
            }
        }
        return simpleSQLFragment;
    }
}

