/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public class ReferencePartitionHelper {
    public static final String PARTITION = "PARTITION";
    public static final String SUBPARTITION = "SUBPARTITION";

    public static Constraint getReferencedConstraint(OracleTablePartitions oracleTablePartitions) {
        Constraint constraint = null;
        if (oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            Constraint constraint2 = ReferencePartitionHelper.resolveReferenceConstraintID(oracleTablePartitions);
            try {
                FKConstraint fKConstraint;
                DBObjectID dBObjectID;
                if (constraint2 != null && constraint2 instanceof FKConstraint && (dBObjectID = (fKConstraint = (FKConstraint)constraint2).getReferenceID()) != null) {
                    constraint = (Constraint)dBObjectID.resolveID();
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(ReferencePartitionHelper.class).warning(dBException.getMessage());
            }
        }
        return constraint;
    }

    public static Table getReferencedTable(OracleTablePartitions oracleTablePartitions) {
        DBObject dBObject;
        Table table = null;
        Constraint constraint = ReferencePartitionHelper.getReferencedConstraint(oracleTablePartitions);
        if (constraint != null && (dBObject = constraint.getParent()) instanceof Table) {
            table = (Table)dBObject;
        }
        return table;
    }

    public static Constraint resolveReferenceConstraintID(OracleTablePartitions oracleTablePartitions) {
        Constraint constraint = null;
        if (oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            Table table = (Table)oracleTablePartitions.getParent();
            constraint = (Constraint)table.findOwnedObject(oracleTablePartitions.getReferenceConstraintID(), true);
        }
        return constraint;
    }

    public static boolean isValidReferenceConstraintID(OracleTablePartitions oracleTablePartitions, boolean bl) {
        boolean bl2 = false;
        if (oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            Table table = ReferencePartitionHelper.getReferencedTable(oracleTablePartitions);
            if (table == null) {
                Constraint constraint;
                if (bl && (constraint = ReferencePartitionHelper.resolveReferenceConstraintID(oracleTablePartitions)) != null && constraint instanceof FKConstraint) {
                    bl2 = true;
                }
            } else if (table != oracleTablePartitions.getParent() && table.getProperty("PARTITIONED TABLE") != null) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static int getReferencedTablePartitionsCount(Table table) {
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        return ReferencePartitionHelper.getReferencedTablePartitionsCount(oracleTablePartitions);
    }

    public static int getReferencedTablePartitionsCount(OracleTablePartitions oracleTablePartitions) {
        int n = 0;
        if (oracleTablePartitions != null) {
            Object object;
            boolean bl;
            TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
            boolean bl2 = bl = oracleTablePartitions.getSubpartitionModel() != null;
            if (tablePartitionArray.length == 0 && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH && (object = oracleTablePartitions.getHashQuantity()) != null && (Integer)object > 0) {
                n += ((Integer)object).intValue();
            }
            object = tablePartitionArray;
            int n2 = ((TablePartition[])object).length;
            for (int i = 0; i < n2; ++i) {
                Object object2 = object[i];
                if (bl) {
                    n += ReferencePartitionHelper.getSubPartitionsCount((TablePartition)object2);
                    continue;
                }
                ++n;
            }
            if (n == 0 && (object = ReferencePartitionHelper.getReferencedTable(oracleTablePartitions)) != null && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
                n = ReferencePartitionHelper.getReferencedTablePartitionsCount((Table)object);
            }
        }
        return n;
    }

    public static int getSubPartitionsCount(TablePartition tablePartition) {
        int n = 0;
        if (tablePartition.getObjectType() == OracleTablePartitions.ObjectType.PARTITION) {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)tablePartition.getParent();
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
            boolean bl = oracleTablePartitions2 != null;
            OracleTablePartitions oracleTablePartitions3 = tablePartition.getPartitionLevelSubpartitions();
            if (bl) {
                TablePartition[] tablePartitionArray;
                if (oracleTablePartitions3 == null) {
                    oracleTablePartitions3 = oracleTablePartitions2;
                }
                if ((tablePartitionArray = oracleTablePartitions3.getPartitions()).length == 0) {
                    int n2 = oracleTablePartitions2.getPartitions().length;
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    if (oracleTablePartitions3.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                        Integer n3 = oracleTablePartitions3.getHashQuantity();
                        if (n3 == null) {
                            n3 = oracleTablePartitions2.getHashQuantity();
                        }
                        if (n3 != null && n3 > 0) {
                            n2 = n3;
                        }
                    }
                    n += n2;
                } else {
                    n += tablePartitionArray.length;
                }
            }
        }
        return n;
    }

    public static Collection<TablePartition> getReferenceTablePartitions(Table table, boolean bl) {
        Collection<Object> collection = new ArrayList();
        if (table == null) {
            collection = Collections.emptyList();
        } else {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (oracleTablePartitions != null) {
                boolean bl2;
                TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
                boolean bl3 = bl2 = oracleTablePartitions.getSubpartitionModel() != null;
                if (tablePartitionArray.length == 0 && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.HASH && oracleTablePartitions.getHashQuantity() != null && oracleTablePartitions.getHashQuantity() > 0) {
                    for (int i = 1; i <= oracleTablePartitions.getHashQuantity(); ++i) {
                        String string = PARTITION + i;
                        collection.add(ReferencePartitionHelper.createReferencePartition(null, string, bl));
                    }
                }
                for (TablePartition tablePartition : tablePartitionArray) {
                    if (bl2) {
                        int n;
                        TablePartition[] tablePartitionArray2;
                        OracleTablePartitions oracleTablePartitions2 = tablePartition.getPartitionLevelSubpartitions();
                        OracleTablePartitions oracleTablePartitions3 = oracleTablePartitions2;
                        if (oracleTablePartitions3 == null) {
                            oracleTablePartitions3 = oracleTablePartitions.getSubpartitionModel();
                        }
                        if ((tablePartitionArray2 = oracleTablePartitions3.getPartitions()).length == 0) {
                            int n2 = oracleTablePartitions.getSubpartitionModel().getPartitions().length;
                            if (n2 < 1) {
                                n2 = 1;
                            }
                            if (oracleTablePartitions3.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                                Integer n3 = oracleTablePartitions3.getHashQuantity();
                                if (n3 == null && oracleTablePartitions2 != null) {
                                    n3 = oracleTablePartitions.getSubpartitionModel().getHashQuantity();
                                }
                                if (n3 != null && n3 > 0) {
                                    n2 = n3;
                                }
                            }
                            for (n = 1; n <= n2; ++n) {
                                String string = tablePartition.getName() + "_SUBPARTITION" + n;
                                collection.add(ReferencePartitionHelper.createReferencePartition(null, string, bl));
                            }
                        }
                        TablePartition[] tablePartitionArray3 = tablePartitionArray2;
                        n = tablePartitionArray3.length;
                        for (int i = 0; i < n; ++i) {
                            TablePartition tablePartition2 = tablePartitionArray3[i];
                            Object object = tablePartition.getName() + "_" + tablePartition2.getName();
                            if (tablePartition2.getObjectType() == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                                object = tablePartition2.getName();
                            }
                            collection.add(ReferencePartitionHelper.createReferencePartition(tablePartition2, (String)object, bl));
                        }
                        continue;
                    }
                    collection.add(ReferencePartitionHelper.createReferencePartition(tablePartition, tablePartition.getName(), bl));
                }
                if ((tablePartitionArray == null || tablePartitionArray.length == 0) && oracleTablePartitions.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
                    table = ReferencePartitionHelper.getReferencedTable(oracleTablePartitions);
                    collection = ReferencePartitionHelper.getReferenceTablePartitions(table, bl);
                }
            }
        }
        return collection;
    }

    public static TablePartition createReferencePartition(TablePartition tablePartition, String string, boolean bl) {
        TablePartition tablePartition2;
        if (tablePartition != null && bl) {
            tablePartition2 = (TablePartition)tablePartition.copyTo(null);
            tablePartition2.setValues(new Object[0]);
        } else {
            tablePartition2 = new TablePartition(string);
        }
        tablePartition2.setName(string);
        tablePartition2.setPartitionType(OracleTablePartitions.PartitionType.REFERENCE);
        tablePartition2.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
        tablePartition2.setParent(null);
        return tablePartition2;
    }
}

