/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.property.Metadata;

public abstract class OracleSourceBuilder<T extends AbstractBuildableObject>
extends OracleDBObjectBuilder<T> {
    OracleSourceBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
        if (!Metadata.getInstance().isTypeOf(SourceObject.class, string)) {
            throw new IllegalArgumentException("Invalid SourceObject type: " + string);
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source"})
    public void fillInSource(T t) throws DBException {
        String string = this.getSource((SourceObject)t);
        ((SourceObject)t).setSource(string);
    }

    protected abstract String getQuery();

    protected String getSource(final SourceObject sourceObject) throws DBException {
        final StringBuilder stringBuilder = new StringBuilder();
        String string = this.getObjectType();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)sourceObject, this.getQuery(), string, sourceObject.getSchema(), sourceObject);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (string != null) {
                            stringBuilder.append(string);
                            if (string.endsWith("\n")) continue;
                            stringBuilder.append('\n');
                            continue;
                        }
                        stringBuilder.append('\n');
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)sourceObject, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        String string2 = null;
        if (stringBuilder.length() > 0) {
            string2 = stringBuilder.toString().trim();
        }
        return string2;
    }
}

