/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OracleIndexBuilder
extends OracleDBObjectBuilder<Index> {
    public OracleIndexBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "INDEX");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"table"})
    public void fillInTable(Index index) throws DBException {
        this.checkParentAndCacheIndex(index, true);
    }

    private Table checkParentAndCacheIndex(Index index, boolean bl) throws DBException {
        Table table = null;
        DBObject dBObject = index.getParent();
        if (dBObject == null || bl) {
            SchemaObject schemaObject = this.getParent(index);
            BaseOracleDatabase baseOracleDatabase = this.getDatabase();
            Index index2 = (Index)this.findObjectInProviderCache("INDEX", index.getSchema(), index.getName());
            if (index2 != index) {
                if (index2 != null) {
                    this.getLogger().log(Level.WARNING, "build requested on index {0} but provider has a different version cached.", index.getName());
                }
                baseOracleDatabase.cacheObject((SystemObject)index, false);
            }
            if (schemaObject instanceof Table) {
                if (dBObject != null && dBObject != schemaObject) {
                    this.getLogger().log(Level.WARNING, "build requested on index {0} but its parent doesn't match the provider cache.", index.getName());
                }
                table = (Table)schemaObject;
                index.setTable(table);
            }
        } else if (dBObject instanceof Table) {
            table = (Table)dBObject;
        }
        return table;
    }

    private SchemaObject getParent(final Index index) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)index, this.getIndexTabQuery(), index.getSchema(), index);
        final String[] stringArray = new String[3];
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        stringArray[0] = resultSet.getString(1);
                        stringArray[1] = resultSet.getString(2);
                        stringArray[2] = resultSet.getString(3);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)index, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (ModelUtil.hasLength((String)string2) && ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string3)) {
            BaseOracleDatabase baseOracleDatabase = this.getDatabase();
            Schema schema = this.getSchema(string2);
            if (schema != null) {
                SchemaObject schemaObject = baseOracleDatabase.getObject(string3, schema, string);
                if (schemaObject == null && "TABLE".equals(string3)) {
                    schemaObject = baseOracleDatabase.getObject("MATERIALIZED VIEW", schema, string);
                }
                return schemaObject;
            }
        }
        return null;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"systemGenerated"}, depends={"table", "columnExpressions"})
    public void fillInSystemGenerated(Index index) throws DBException {
        Constraint constraint;
        Table table = this.checkParentAndCacheIndex(index, false);
        final Holder holder = new Holder();
        boolean bl = false;
        UniqueConstraint uniqueConstraint = ConstraintIndexHelper.forConstraint(index);
        if (uniqueConstraint != null) {
            bl = uniqueConstraint.getName().equals(index.getName());
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)table, "SELECT /*OracleDictionaryQueries.ALL_INDEX_METADATA_QUERY*/\n       SYS.DBMS_METADATA.GET_XML('INDEX', ?, ?) XML\nFROM   SYS.DUAL", index, table.getSchema());
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            holder.set((Object)resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
            try {
                NodeList nodeList;
                if (ModelUtil.hasLength((String)((String)holder.get()))) {
                    DOMParser dOMParser = new DOMParser();
                    StringReader stringReader = new StringReader((String)holder.get());
                    dOMParser.parse((Reader)stringReader);
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    nodeList = xMLDocument.selectNodes("/ROWSET/ROW/INDEX_T/PROPERTY");
                    if (nodeList.getLength() != 1) {
                        throw new RuntimeException("1 node expected at /ROWSET/ROW/INDEX_T/PROPERTY - got " + nodeList.getLength());
                    }
                } else {
                    throw new RuntimeException("Nothing returned from dbms_metadat.get_xml");
                }
                Node node = nodeList.item(0);
                String string = node.getTextContent();
                Integer n = Integer.valueOf(string);
                bl = (n & 0x1000) == 4096;
            }
            catch (Exception exception) {
                this.getLogger().log(Level.WARNING, "Failed to find the property of index " + index.getName(), exception);
            }
        } else if (uniqueConstraint == null && this.getDatabase() instanceof OracleLite && (constraint = table.getConstraint(index.getName())) instanceof UniqueConstraint && ConstraintIndexHelper.indexValidForConstraint(index, (UniqueConstraint)constraint, (DBObjectProvider)this.getDatabase())) {
            bl = true;
        }
        index.setSystemGenerated(Boolean.valueOf(bl));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexType", "domainIndextype", "domainIndextypeOpStatus", "domainIndextypeParameters", "OracleStorageProperties", "parallelDegree", "keyCompression", "reverse", "columnExpressions"}, depends={"table"})
    public void fillInBaseProperties(Index index) throws DBException {
        Table table = this.checkParentAndCacheIndex(index, false);
        if (table != null) {
            OracleTableBuilder oracleTableBuilder = (OracleTableBuilder)this.getDatabase().getBuilderForType("TABLE");
            oracleTableBuilder.fillInIndexes(table);
        }
    }

    void fillInIndexes(MaterializedView materializedView, String string) throws DBException {
        this.fillInIndexesImpl((Table)materializedView, string);
    }

    void fillInIndexes(Table table) throws DBException {
        this.fillInIndexesImpl(table, null);
    }

    private void fillInIndexesImpl(final Table table, String string) throws DBException {
        final TreeMap<String, Index> treeMap = new TreeMap<String, Index>();
        String string2 = this.getTableIndexesQuery();
        String string3 = table.getType();
        if (table instanceof MaterializedView) {
            string3 = "TABLE";
        }
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)table, string2, table.getSchema(), string3, table);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        Table.TableType tableType;
                        Index index;
                        Object object;
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        BigDecimal bigDecimal = resultSet.getBigDecimal(3);
                        if (resultSet.wasNull()) {
                            bigDecimal = null;
                        }
                        String string3 = resultSet.getString(4);
                        String string4 = resultSet.getString(5);
                        String string5 = resultSet.getString(6);
                        String string6 = resultSet.getString(7);
                        String string7 = resultSet.getString(8);
                        String string8 = resultSet.getString(9);
                        String string9 = resultSet.getString(10);
                        String string10 = resultSet.getString(11);
                        Schema schema = OracleIndexBuilder.this.getSchema(string2);
                        BaseOracleDatabase baseOracleDatabase = OracleIndexBuilder.this.getDatabase();
                        Index index2 = null;
                        if (bigDecimal != null) {
                            index2 = (Index)OracleIndexBuilder.this.findObjectInProviderCache((DBObjectID)new IdentifierBasedID("INDEX", (Object)bigDecimal));
                        }
                        if (index2 == null) {
                            index2 = (Index)OracleIndexBuilder.this.findObjectInProviderCache("INDEX", schema, string);
                        }
                        if (index2 != null && (object = index2.getID()) != null && (index = (Index)object.resolveID()) == null) {
                            index2 = null;
                        }
                        if (index2 == null) {
                            object = baseOracleDatabase.createID(null, schema, string, "INDEX", bigDecimal);
                            index2 = (Index)OracleIndexBuilder.this.createObject(string, schema, (DBObjectID)object);
                            baseOracleDatabase.cacheObject((SystemObject)index2, true);
                            baseOracleDatabase.setOracleBuilder(index2, OracleIndexBuilder.this);
                        }
                        if (index2 == null) continue;
                        if (table != null) {
                            object = table.getID();
                            index = index2.getID();
                            if (index instanceof BaseObjectID && object != null && !object.equals(index.getParent(), true)) {
                                ((BaseObjectID)index).setParent(object);
                                index2.setID((DBObjectID)index);
                            }
                        }
                        object = null;
                        index = null;
                        String string11 = null;
                        String string12 = null;
                        if (Index.IndexType.UNIQUE.toString().equals(string3)) {
                            object = Index.IndexType.UNIQUE;
                        } else if (string4 != null && Index.IndexType.DOMAIN.equals(object = string4.contains(Index.IndexType.NORMAL.toString()) ? Index.IndexType.NORMAL : (string4.contains(Index.IndexType.BITMAP.toString()) ? Index.IndexType.BITMAP : (string4.equals(Index.IndexType.DOMAIN.toString()) ? Index.IndexType.DOMAIN : null)))) {
                            index = new ReferenceID("INDEXTYPE", string5, string6);
                            string11 = string7;
                            string12 = string8;
                        }
                        if (string4 != null) {
                            if (string4.endsWith("/REV")) {
                                index2.setReverse(Boolean.valueOf(true));
                            } else if (object.equals((Object)Index.IndexType.NORMAL) || object.equals((Object)Index.IndexType.UNIQUE)) {
                                index2.setReverse(Boolean.valueOf(false));
                            } else {
                                index2.setReverse(null);
                            }
                        }
                        index2.setIndexType((Index.IndexType)object);
                        index2.setDomainIndextype((DBObjectID)index);
                        index2.setDomainIndextypeParameters(string11);
                        index2.setDomainIndextypeOpStatus(string12);
                        Integer n = null;
                        if (ModelUtil.hasLength((String)string9)) {
                            n = "DEFAULT".equals(string9) ? 0 : Integer.decode(string9);
                        }
                        index2.setParallelDegree(n);
                        if (ModelUtil.hasLength((String)string10)) {
                            index2.setKeyCompression(Integer.valueOf(string10));
                        } else {
                            index2.setKeyCompression(null);
                        }
                        boolean bl = "TABLE".equals(table.getType()) ? (tableType = (Table.TableType)table.getProperty("TableType")) == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP : false;
                        tableType = null;
                        if (!bl) {
                            tableType = OracleTableBuilder.getSegmentAttributeProperties(resultSet, baseOracleDatabase);
                        }
                        index2.setProperty("OracleStorageProperties", (Object)tableType);
                        index2.setTable(table);
                        treeMap.put(string, index2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        this.fillInExpressionsForTable(table, treeMap);
        ArrayList<Index> arrayList = new ArrayList<Index>(treeMap.values());
        this.removeSystemIndexes((Relation)table, arrayList, string);
        Index[] indexArray = arrayList.toArray(new Index[arrayList.size()]);
        table.setIndexes(indexArray);
        for (Index index : treeMap.values()) {
            this.registerObject((AbstractBuildableObject)index);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleIndexPartitions"}, depends={"table", "columnExpressions"})
    public void fillInPartitions(final Index index) throws DBException {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        if (baseOracleDatabase.supportsPartitioning()) {
            final Table table = this.checkParentAndCacheIndex(index, false);
            String string = index.getName();
            final QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_TYPE_QUERY*/\n       partitioning_type, subpartitioning_type, locality, partition_count\nfrom   sys.all_part_indexes api\nwhere  api.owner = ?\nand    api.index_name = ?\n", index.getSchema(), string);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            String string = resultSet.getString("PARTITIONING_TYPE");
                            String string2 = resultSet.getString("SUBPARTITIONING_TYPE");
                            String string3 = resultSet.getString("LOCALITY");
                            String string4 = resultSet.getString("PARTITION_COUNT");
                            if ("SYSTEM".equals(string)) {
                                return;
                            }
                            OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)OracleIndexBuilder.this.newObject(OracleIndexPartitions.class, null);
                            index.setProperty("OracleIndexPartitions", (Object)oracleIndexPartitions);
                            NameBasedID nameBasedID = new NameBasedID((DBObject)oracleIndexPartitions, index.getID());
                            oracleIndexPartitions.setID((DBObjectID)nameBasedID);
                            OracleIndexPartitions.PartitionType partitionType = "GLOBAL".equals(string3) ? OracleIndexPartitions.PartitionType.valueOf((String)(string3 + "_" + string)) : ("HASH".equals(string) ? OracleIndexPartitions.PartitionType.LOCAL_HASH : ("NONE".equals(string2) ? OracleIndexPartitions.PartitionType.LOCAL_OTHER : OracleIndexPartitions.PartitionType.LOCAL_COMP));
                            oracleIndexPartitions.setPartitionType(partitionType);
                            if ("GLOBAL".equals(string3)) {
                                oracleIndexPartitions.setGlobalPartitionColumns(OracleIndexBuilder.this.getGlobalPartitionColumns(index));
                                Integer n = string4 != null || string4 != "" ? Integer.decode(string4) : 0;
                                if ("HASH".equals(string) && n > 0 && index.getName().startsWith("SYS_P")) {
                                    oracleIndexPartitions.setGlobalHashQuantity(n);
                                }
                            }
                            OracleIndexBuilder.this.fillInIndexPartitions(index);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException((DBObject)table, sQLException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
    }

    private DBObjectID[] getGlobalPartitionColumns(Index index) throws DBException {
        final ArrayList arrayList = new ArrayList();
        final Table table = index.getTable();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_COLUMNS_QUERY*/\n       column_name\nfrom   sys.all_part_key_columns apk1\nwhere  apk1.owner = ?\nand    apk1.name = ?\nand    apk1.object_type = 'INDEX'\norder by apk1.column_position", index.getSchema(), index);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        arrayList.add(new NameBasedID("COLUMN", string, table.getID()));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        return arrayList.toArray(new DBObjectID[arrayList.size()]);
    }

    private void fillInIndexPartitions(final Index index) throws DBException {
        final OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        final OracleIndexPartitions.PartitionType partitionType = oracleIndexPartitions.getPartitionType();
        final Map<String, OracleIndexPartitions> map = partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP ? this.getSubpartitions(index) : null;
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   sys.all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position", index.getSchema(), index);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        Boolean bl;
                        String string;
                        String string2 = resultSet.getString("PARTITION_NAME");
                        IndexPartition indexPartition = new IndexPartition(string2, oracleIndexPartitions);
                        oracleIndexPartitions.addPartition(indexPartition);
                        NameBasedID nameBasedID = new NameBasedID((DBObject)indexPartition, oracleIndexPartitions.getID());
                        indexPartition.setID((DBObjectID)nameBasedID);
                        if (partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                            string = resultSet.getString("COMPRESSION");
                            bl = resultSet.wasNull() || !ModelUtil.hasLength((String)string) ? null : Boolean.valueOf("ENABLED".equals(string));
                            indexPartition.setUseKeyCompression(bl);
                        }
                        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                            string = resultSet.getString("HIGH_VALUE");
                            indexPartition.setValuesLessThan(string);
                        }
                        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                            string = resultSet.getString("TABLESPACE_NAME");
                            if (ModelUtil.hasLength((String)string)) {
                                bl = new OracleStorageProperties();
                                indexPartition.setSegmentAttributes((OracleStorageProperties)bl);
                                bl.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleIndexBuilder.this.getDatabase(), string));
                            }
                        } else if (index.getIndexType() == Index.IndexType.DOMAIN) {
                            indexPartition.setDomainParameters(resultSet.getString("PARAMETERS"));
                        } else {
                            indexPartition.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(resultSet, OracleIndexBuilder.this.getDatabase()));
                        }
                        if (map == null || !map.containsKey(string2)) continue;
                        indexPartition.setSubpartitions((OracleIndexPartitions)map.get(string2));
                        OracleIndexBuilder.this.setSubpartitionIDs(indexPartition);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)index, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private Map<String, OracleIndexPartitions> getSubpartitions(final Index index) throws DBException {
        final HashMap<String, OracleIndexPartitions> hashMap = new HashMap<String, OracleIndexPartitions>();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)index, "select /*OracleDictionaryQueries.ALL_INDEX_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   SYS.ALL_IND_SUBPARTITIONS\nwhere  INDEX_OWNER = ?\nand    INDEX_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION", index.getSchema(), index);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                String string = null;
                OracleIndexPartitions oracleIndexPartitions = null;
                try {
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("PARTITION_NAME");
                        if (!string2.equals(string)) {
                            oracleIndexPartitions = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
                            hashMap.put(string2, oracleIndexPartitions);
                            string = string2;
                        }
                        IndexPartition indexPartition = new IndexPartition(resultSet.getString("SUBPARTITION_NAME"), oracleIndexPartitions);
                        oracleIndexPartitions.addPartition(indexPartition);
                        string2 = resultSet.getString("TABLESPACE_NAME");
                        if (!ModelUtil.hasLength((String)string2)) continue;
                        OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
                        indexPartition.setSegmentAttributes(oracleStorageProperties);
                        oracleStorageProperties.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleIndexBuilder.this.getDatabase(), string2));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)index, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        return hashMap;
    }

    private void setSubpartitionIDs(IndexPartition indexPartition) {
        OracleIndexPartitions oracleIndexPartitions = indexPartition.getSubpartitions();
        if (oracleIndexPartitions != null) {
            NameBasedID nameBasedID = new NameBasedID((DBObject)oracleIndexPartitions, indexPartition.getID());
            oracleIndexPartitions.setID((DBObjectID)nameBasedID);
            for (IndexPartition indexPartition2 : oracleIndexPartitions.getPartitions()) {
                indexPartition2.setID((DBObjectID)new NameBasedID((DBObject)indexPartition2, (DBObjectID)nameBasedID));
            }
        }
    }

    private void fillInExpressionsForTable(final Table table, Map<String, Index> map) throws DBException {
        final MultiMap multiMap = new MultiMap();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)table, this.getIndexColumnQuery(), table.getSchema(), table);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        IndexColumnQueryResult indexColumnQueryResult = new IndexColumnQueryResult(resultSet);
                        multiMap.add((Object)indexColumnQueryResult.idxName, (Object)indexColumnQueryResult);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        Map<String, Map<Long, String>> map2 = null;
        for (Map.Entry entry : multiMap.entrySet()) {
            Index index = map.get(entry.getKey());
            if (index == null) continue;
            Collection collection = (Collection)entry.getValue();
            IndexObject[] indexObjectArray = new IndexObject[collection.size()];
            int n = 0;
            for (IndexColumnQueryResult indexColumnQueryResult : collection) {
                Map map3;
                String string = indexColumnQueryResult.idxName;
                String string2 = indexColumnQueryResult.colName;
                Long l = indexColumnQueryResult.colPosn;
                String string3 = indexColumnQueryResult.colDesc;
                String string4 = null;
                if (indexColumnQueryResult.isAllIndExp == 1) {
                    if (map2 == null) {
                        map2 = this.getIndexExpressionsForTable((SchemaObject)table);
                    }
                    if ((map3 = (Map)map2.get(string)) == null || !map3.containsKey(l)) {
                        this.getLogger().warning("Missing column expression");
                    } else {
                        string4 = (String)map3.get(l);
                    }
                } else {
                    string4 = this.getDatabase().getExternalName(string2);
                }
                if (index.getIndexType() == Index.IndexType.DOMAIN) {
                    string3 = null;
                }
                map3 = null;
                if (string3 != null) {
                    map3 = IndexObject.OrderType.valueOf((String)string3);
                }
                IndexObject indexObject = (IndexObject)this.newObject(IndexObject.class, null);
                indexObject.setExpressionSource(string4);
                indexObject.setOrderType((IndexObject.OrderType)map3);
                indexObjectArray[n++] = indexObject;
            }
            index.setColumnExpressions(indexObjectArray);
        }
    }

    private Map<String, Map<Long, String>> getIndexExpressionsForTable(final SchemaObject schemaObject) throws DBException {
        final HashMap<String, Map<Long, String>> hashMap = new HashMap<String, Map<Long, String>>();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)schemaObject, "SELECT /*OracleDictionaryQueries.ALL_INDEX_EXPRESSION_PER_TAB_QUERY*/\n       index_name, column_position, column_expression  FROM sys.all_ind_expressions WHERE table_owner = ? AND table_name = ? ", schemaObject.getSchema(), schemaObject);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        Long l = new Long(resultSet.getInt(2));
                        String string2 = resultSet.getString(3);
                        HashMap<Long, String> hashMap2 = (HashMap<Long, String>)hashMap.get(string);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap<Long, String>();
                            hashMap.put(string, hashMap2);
                        }
                        hashMap2.put(l, string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)schemaObject, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        return hashMap;
    }

    public static SQLFragment createExpression(String string, Relation relation, DBObjectProvider dBObjectProvider) {
        return SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)dBObjectProvider, (Relation)relation, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)string);
    }

    private String getIndexTabQuery() {
        String string = this.getDatabase().getDatabaseType();
        return "Oracle Lite".equals(string) ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM SYS.ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM SYS.ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?";
    }

    private String getIndexColumnQuery() {
        String string = this.getDatabase().getDatabaseType();
        return "Oracle Lite".equals(string) ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_COLUMN_PER_TAB_QUERY*/\n       INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, NULL, 0 FROM SYS.ALL_IND_COLUMNS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY INDEX_NAME, COLUMN_POSITION" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_COLUMN_PER_TAB_QUERY*/\n       c.index_name, c.column_name, c.column_position, c.descend,   ( SELECT 1     FROM   sys.all_ind_expressions e     WHERE  e.index_name  = c.index_name     AND    e.index_owner = c.index_owner     AND    e.column_position = c.column_position ) col_expr_exists FROM sys.all_ind_columns c  WHERE c.table_owner = ? AND c.table_name  = ? ORDER BY c.index_name, c.column_position ";
    }

    private String getTableIndexesQuery() {
        String string = this.getDatabase().getDatabaseType();
        return "Oracle Lite".equals(string) ? " SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, 'NORMAL', null, null, null, null, null, null,        null TABLESPACE_NAME, null PCT_FREE, null PCT_USED, null INI_TRANS, null MAX_TRANS,\n       null INITIAL_EXTENT, null NEXT_EXTENT, null MIN_EXTENTS, null MAX_EXTENTS, null PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING, null BUFFER_POOL\n FROM SYS.ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER,       (select object_id from sys.all_objects where object_name = i.index_name and owner = i.owner and object_type = 'INDEX') OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\nFROM SYS.ALL_INDEXES i WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND INDEX_TYPE != 'LOB'";
    }

    private void removeSystemIndexes(Relation relation, Collection<Index> collection, String string) throws DBException {
        Iterator<Index> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Index index = iterator.next();
            if (relation instanceof MaterializedView && string != null && index.getName().equals(string)) {
                iterator.remove();
                continue;
            }
            if (!index.getName().startsWith("SYS_C")) continue;
            boolean bl = false;
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            if (indexObjectArray.length == 1) {
                String string2 = indexObjectArray[0].getExpressionSource();
                Column column = relation.getColumn(string2);
                if (column != null) {
                    if (column.getDataTypeUsage() != null && column.getDataTypeUsage().getDataTypeID() != null) {
                        DBObject dBObject = null;
                        try {
                            dBObject = column.getDataTypeUsage().getDataTypeID().resolveID();
                            if (dBObject instanceof Type) {
                                bl = true;
                            }
                        }
                        catch (DBException dBException) {
                            this.getLogger().warning(dBException.getMessage());
                        }
                    }
                } else if (this.getDatabase().getDatabaseVersion() <= 92 && string2.startsWith("SYS_NC")) {
                    bl = true;
                }
            }
            if (bl) {
                iterator.remove();
                continue;
            }
            this.getLogger().fine("Keeping index " + index.getName() + " on " + relation.getName());
        }
    }

    private class IndexColumnQueryResult {
        String idxName;
        String colName;
        Long colPosn;
        String colDesc;
        int isAllIndExp;

        private IndexColumnQueryResult(ResultSet resultSet) throws SQLException {
            this.idxName = resultSet.getString(1);
            this.colName = resultSet.getString(2);
            this.colPosn = new Long(resultSet.getInt(3));
            this.colDesc = resultSet.getString(4);
            this.isAllIndExp = resultSet.getInt(5);
        }

        public String toString() {
            return "\n" + this.idxName + " " + this.colName + " " + this.colPosn + " " + this.colDesc + " " + this.isAllIndExp + "\n";
        }
    }
}

