/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.IntStream;
import oracle.i18n.util.OraSQLUtil;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.BuiltInObjectCache;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.extension.DelegateDDLGenerator;
import oracle.javatools.db.ora.ExternalTablePropertiesBuilder;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.LocalTablePartitionModelIDBuilder;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleDatabaseXE;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionModelIDBuilder;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterBuilder;
import oracle.javatools.db.ora.ddl.OracleDDLGenerator;
import oracle.javatools.db.ora.resource.OracleFunctionsBundle;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderFactory;
import oracle.javatools.db.ora.sql.SqlUsageUtil;
import oracle.javatools.db.ora.validators.DatabaseLinkValidator;
import oracle.javatools.db.ora.validators.DirectoryValidator;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.ora.validators.IOTPropertiesValidator;
import oracle.javatools.db.ora.validators.InMemoryColumnPropertiesValidator;
import oracle.javatools.db.ora.validators.InMemoryPropertiesValidator;
import oracle.javatools.db.ora.validators.IndexPartitionValidator;
import oracle.javatools.db.ora.validators.IndexPartitionsValidator;
import oracle.javatools.db.ora.validators.LOBDescriptorValidator;
import oracle.javatools.db.ora.validators.MaterializedViewLogValidator;
import oracle.javatools.db.ora.validators.MaterializedViewValidator;
import oracle.javatools.db.ora.validators.NestedTablePropertiesValidator;
import oracle.javatools.db.ora.validators.OracleColumnPropertiesValidator;
import oracle.javatools.db.ora.validators.OracleColumnValidator;
import oracle.javatools.db.ora.validators.OracleConstraintValidator;
import oracle.javatools.db.ora.validators.OracleDataTypeUsageValidator;
import oracle.javatools.db.ora.validators.OracleIndexValidator;
import oracle.javatools.db.ora.validators.OracleTablePropertiesValidator;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.ora.validators.OracleTablespacePropertiesValidator;
import oracle.javatools.db.ora.validators.OracleTablespaceValidator;
import oracle.javatools.db.ora.validators.StoragePropertiesValidator;
import oracle.javatools.db.ora.validators.TablePartitionValidator;
import oracle.javatools.db.ora.validators.TablePartitionsValidator;
import oracle.javatools.db.ora.validators.XMLTypeColumnPropertiesValidator;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.plsql.parser.PlSqlParserFactoryImpl;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.FileSpecificationValidator;
import oracle.javatools.db.validators.IdentityColumnPropertiesValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SequenceValidator;
import oracle.javatools.db.validators.SynonymValidator;
import oracle.javatools.db.validators.TriggerValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ViewValidator;
import oracle.javatools.db.validators.XMLSchemaValidator;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

public class OracleDatabaseDescriptor
extends BaseDatabaseDescriptor {
    public static final String FEATURE_ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN = "ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN";
    public static final char QUOTE_IDENTIFIER = '\"';
    protected static final int LEGACY_MAX_NAME_LEN = 30;
    private static final int MAX_DATABASE_LINK_NAME_LEN = 128;
    private static final int MAX_FILE_NAME_LEN = 256;
    private static final int MAX_JAVA_NAME_LEN = 4000;
    private static final char PERIOD = '.';
    private static final String ALLOWED_CHARS = "_$#";
    private static final String CTXSYS = "CTXSYS";
    private static final String EFXSYS = "EFXSYS";
    private static final String MDSYS = "MDSYS";
    private static final String ORDSYS = "ORDSYS";
    private static final String SYS = "SYS";
    private static final String XDB = "XDB";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "DUAL", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"));
    private final int m_version;

    OracleDatabaseDescriptor(Class<? extends OracleDatabase> clazz) {
        this(clazz, OracleDatabaseDescriptor.getDatabaseVersion(clazz));
    }

    OracleDatabaseDescriptor(int n) {
        this(OracleDatabaseDescriptor.getDatabaseClass(n), n);
    }

    protected OracleDatabaseDescriptor(Class<? extends OracleDatabase> clazz, int n) {
        super(clazz);
        this.m_version = n;
    }

    private String getDatabaseCharsetName() {
        return null;
    }

    private CharacterSet getDatabaseCharset() {
        return null;
    }

    public String getDatabaseType() {
        return "Oracle Database";
    }

    public int getDatabaseVersion() {
        return this.m_version;
    }

    public int getCasePolicy() {
        return 2;
    }

    @Override
    public List<UpdateProcessor> getUpdateProcessors() {
        List<UpdateProcessor> list = super.getUpdateProcessors();
        list.add(0, new ColumnSequenceProcessor());
        list.add(new ConstraintIndexHelper.Processor());
        return list;
    }

    public void validateEncoding(String string, Object object) throws ValidationException {
        CharacterSet characterSet = this.getDatabaseCharset();
        if (characterSet != null) {
            try {
                characterSet.convert(string);
            }
            catch (SQLException sQLException) {
                throw new ValidationException(null, APIBundle.format((String)"COMMENT_NOT_ENCODABLE", (Object[])new Object[]{string, this.getDatabaseCharsetName()}));
            }
            catch (Throwable throwable) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Error validating encoding", throwable);
            }
        }
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public int getMaxNameLength(String string) {
        return this.getMaxIndentifierLength(string);
    }

    protected boolean needsQuoting(String string) {
        boolean bl = true;
        if (ModelUtil.hasLength((String)string) && string.length() == string.trim().length()) {
            try {
                this.validateIdentifier(null, string, this.allowSurrogatesInIdentifierValidation());
                bl = !string.equals(string.toUpperCase());
            }
            catch (InvalidNameException invalidNameException) {
                bl = true;
            }
        }
        return bl;
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        this.validateIdentifier(string, string2, this.allowSurrogatesInIdentifierValidation());
        String string3 = this.getDatabaseCharsetName();
        if (ModelUtil.hasLength((String)string3)) {
            try {
                if (!OraSQLUtil.isValidIdentifier((String)string2, (String)string3)) {
                    throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_IN_CHARSET", (Object[])new Object[]{string2, string3}));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.getLogger().log(Level.WARNING, unsupportedEncodingException.getMessage());
            }
            CharacterSet characterSet = this.getDatabaseCharset();
            if (characterSet != null) {
                String string4 = this.getInternalName(string2, string);
                try {
                    if (characterSet.encodedByteLength(string4) > this.getMaxNameLength(string)) {
                        throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_TOO_LONG", (Object[])new Object[]{string2}));
                    }
                }
                catch (SQLException sQLException) {
                    this.getLogger().warning("Could not determine encoded byte length: " + sQLException.getMessage());
                }
                catch (Throwable throwable) {
                    this.getLogger().log(DBLog.getExceptionLogLevel(), "Error determining encoded byte length", throwable);
                }
            }
        } else if (this.getIdeCharset() != null) {
            try {
                if (!this.canEncode(string2)) {
                    throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_IN_CHARSET", (Object[])new Object[]{string2, this.getIdeCharset().name()}));
                }
                String string5 = this.getInternalName(string2, string);
                byte[] byArray = string5.getBytes(this.getIdeCharset().name());
                if (byArray.length > this.getMaxNameLength(string)) {
                    throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_TOO_LONG", (Object[])new Object[]{string2}));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.getLogger().log(Level.WARNING, "Unsupported encoding: " + unsupportedEncodingException.getMessage());
            }
        }
    }

    public String getExternalName(String string, String string2) {
        if (ModelUtil.hasLength((String)string)) {
            if ("DATABASE LINK".equals(string2)) {
                boolean bl;
                Object object = "";
                int n = string.length();
                boolean bl2 = bl = string.charAt(0) == '\"' && string.indexOf(34, 1) == n - 1;
                if (bl) {
                    return string;
                }
                int n2 = string.charAt(0) == '\"' ? 34 : 46;
                int n3 = 0;
                while (n3 < n) {
                    int n4 = n3 + (n2 == 34 ? 1 : 0);
                    int n5 = string.indexOf(n2, n4);
                    int n6 = n5 > -1 ? n5 + (n2 == 34 ? 1 : 0) : (n5 = n);
                    if (n3 == n5) {
                        return string;
                    }
                    String string3 = string.substring(n3, n5);
                    object = (String)object + (String)(this.isValidName("DATABASE LINK", string3) ? string3 : "\"" + string3 + "\"");
                    n3 = n5 + 1;
                    if (n3 == n) {
                        return string;
                    }
                    if (n3 >= n) continue;
                    object = (String)object + ".";
                    n2 = string.charAt(n3) == '\"' ? 34 : 46;
                }
                return this.isValidName("DATABASE LINK", (String)object) ? object : string;
            }
            if ("XML SCHEMA".equals(string2)) {
                return string;
            }
        }
        return super.getExternalName(string, string2);
    }

    public String getInternalName(String string, String string2) {
        if (ModelUtil.hasLength((String)string) && "DATABASE LINK".equals(string2)) {
            return string.toUpperCase().replaceAll(String.valueOf('\"'), "");
        }
        if (ModelUtil.hasLength((String)string) && "XML SCHEMA".equals(string2)) {
            return string;
        }
        return super.getInternalName(string, string2);
    }

    public String getPublicSchemaName() {
        return "PUBLIC";
    }

    public boolean allowSurrogatesInIdentifierValidation() {
        return true;
    }

    private void validateIdentifier(String string, String string2, boolean bl) throws InvalidNameException {
        String string3 = string2 = string2 == null ? "" : string2;
        if ("DATABASE LINK".equals(string)) {
            this.validateDbLinkName(string2);
        } else if (!"XML SCHEMA".equals(string)) {
            OracleDatabaseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)this.getMaxIndentifierLength(string), (String)("FILE_SPECIFICATION".equals(string) ? "._$#" : ALLOWED_CHARS), (String)String.valueOf('\"'), (boolean)true, (Set)RESERVED_WORDS, (int)2, (boolean)bl);
        }
    }

    public boolean isValidOracleIdentifier(String string, boolean bl) {
        try {
            this.validateIdentifier(null, string, bl);
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
        return true;
    }

    public int getMaxIndentifierLength(String string) {
        return "DATABASE LINK".equals(string) ? 128 : ("JAVA CLASS".equals(string) || "JAVA SOURCE".equals(string) || "JAVA RESOURCE".equals(string) || "XML SCHEMA".equals(string) ? 4000 : ("FILE_SPECIFICATION".equals(string) ? 256 : this.getDefaultMaxIndentifierLength()));
    }

    protected int getDefaultMaxIndentifierLength() {
        return 30;
    }

    private void validateDbLinkName(String string) throws InvalidNameException {
        boolean bl;
        String string2 = string.replaceAll("\"", "");
        int n = string2.codePointCount(0, string2.length());
        if (n < 1) {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_NO_NAME"));
        }
        if (n > 128) {
            throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_TOO_LONG", (Object[])new Object[]{string}));
        }
        int n2 = string.length();
        boolean bl2 = bl = string.charAt(0) == '\"' && string.indexOf(34, 1) == n2 - 1;
        if (bl) {
            string = string.substring(1, n2 - 1);
            n2 = string.length();
        }
        int n3 = string.charAt(0) == '\"' ? 34 : 46;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 + (n3 == 34 ? 1 : 0);
            int n6 = string.indexOf(n3, n5);
            int n7 = n6 > -1 ? n6 + (n3 == 34 ? 1 : 0) : (n6 = n2);
            if (n4 == n6 || n6 < n2 && string.charAt(n6) != '.') {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_MISSING_DB_LINK_COMPONENT", (Object[])new Object[]{string}));
            }
            String string3 = string.substring(n4, n6);
            this.validateDbLinkNameComponent((String)(bl ? "\"" + string3 + "\"" : string3));
            n4 = n6 + 1;
            if (n4 == n2) {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_MISSING_DB_LINK_COMPONENT", (Object[])new Object[]{string}));
            }
            if (n4 >= n2) continue;
            n3 = string.charAt(n4) == '\"' ? 34 : 46;
        }
    }

    private boolean canEncode(String string) {
        boolean bl = true;
        Charset charset = this.getIdeCharset();
        if (charset != null) {
            try {
                CharsetEncoder charsetEncoder = charset.newEncoder();
                if (charsetEncoder != null) {
                    bl = charsetEncoder.canEncode(string);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.getLogger().log(Level.FINE, "Charset " + charset.displayName() + " does not support encoding.");
            }
            catch (IllegalStateException illegalStateException) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Cannot use encoder to test name", illegalStateException);
            }
        }
        return bl;
    }

    private void validateDbLinkNameComponent(String string) throws InvalidNameException {
        boolean bl = string.charAt(0) == '\"' && string.indexOf(34, 1) == string.length() - 1;
        boolean bl2 = false;
        if (bl) {
            string = string.substring(1, string.length() - 1);
        }
        boolean bl3 = bl2 = string.indexOf(34) != -1;
        if (!bl2) {
            IntStream intStream = string.codePoints();
            PrimitiveIterator.OfInt ofInt = intStream.iterator();
            while (ofInt.hasNext()) {
                boolean bl4;
                Integer n = (Integer)ofInt.next();
                boolean bl5 = bl4 = Character.isAlphabetic(n) || Character.isDigit(n);
                if (!Character.isSupplementaryCodePoint(n) && (bl4 || ALLOWED_CHARS.indexOf(n) >= 0 || bl && String.valueOf('.').indexOf(n) != -1)) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER", (Object[])new Object[]{string}));
        }
        if (!bl) {
            if (!Character.isAlphabetic(string.codePointAt(0))) {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_NON_ALPHA_START", (Object[])new Object[]{string}));
            }
            if (RESERVED_WORDS.contains(string.toUpperCase())) {
                throw new InvalidNameException(null, APIBundle.format((String)"INVALID_IDENTIFIER_RESERVED_WORD", (Object[])new Object[]{string.toUpperCase()}));
            }
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("COLUMN", new OracleColumnValidator(dBObjectProvider));
        map.put("DataTypeUsage", new OracleDataTypeUsageValidator(dBObjectProvider));
        map.put("TABLE", (DBObjectValidator)new OracleTableValidator(dBObjectProvider));
        map.put("INDEX", (DBObjectValidator)new OracleIndexValidator(dBObjectProvider));
        map.put("CONSTRAINT", new OracleConstraintValidator(dBObjectProvider));
        map.put("SYNONYM", (DBObjectValidator)new SynonymValidator(dBObjectProvider));
        map.put("SEQUENCE", (DBObjectValidator)new SequenceValidator(dBObjectProvider));
        map.put("VIEW", (DBObjectValidator)new ViewValidator(dBObjectProvider));
        map.put("IdentityColumnProperties", new IdentityColumnPropertiesValidator(dBObjectProvider));
        map.put("OracleInMemoryProperties", new InMemoryPropertiesValidator(dBObjectProvider));
        map.put("OracleInMemoryColumnProperties", new InMemoryColumnPropertiesValidator(dBObjectProvider));
        map.put("OracleStorageProperties", new StoragePropertiesValidator(dBObjectProvider));
        if (!OracleLite.class.isAssignableFrom(this.getDatabaseClass())) {
            map.put("MATERIALIZED VIEW", (DBObjectValidator)new MaterializedViewValidator(dBObjectProvider));
            map.put("MATERIALIZED VIEW LOG", (DBObjectValidator)new MaterializedViewLogValidator(dBObjectProvider));
            map.put("XML SCHEMA", (DBObjectValidator)new XMLSchemaValidator(dBObjectProvider));
            map.put("PACKAGE", (DBObjectValidator)new PlSqlValidator(dBObjectProvider));
            map.put("PACKAGE BODY", (DBObjectValidator)new PlSqlValidator(dBObjectProvider, true));
            map.put("PROCEDURE", (DBObjectValidator)new PlSqlValidator(dBObjectProvider));
            map.put("FUNCTION", (DBObjectValidator)new PlSqlValidator(dBObjectProvider));
            map.put("TRIGGER", (DBObjectValidator)new TriggerValidator(dBObjectProvider));
            map.put("TYPE", (DBObjectValidator)new PlSqlValidator(dBObjectProvider));
            map.put("TYPE BODY", (DBObjectValidator)new PlSqlValidator(dBObjectProvider, true));
            map.put("IOT PROPERTIES", new IOTPropertiesValidator(dBObjectProvider));
            map.put("EXTERNAL TABLE PROPERTIES", new ExternalTablePropsValidator(dBObjectProvider));
            map.put("PARTITION MODEL", new TablePartitionsValidator(dBObjectProvider));
            map.put("PARTITION", new TablePartitionValidator(dBObjectProvider));
            map.put("LOB DESCRIPTOR", new LOBDescriptorValidator(dBObjectProvider));
            map.put("INDEX PARTITION MODEL", new IndexPartitionsValidator(dBObjectProvider));
            map.put("INDEX PARTITION", new IndexPartitionValidator(dBObjectProvider));
            map.put("DIRECTORY", (DBObjectValidator)new DirectoryValidator(dBObjectProvider));
            map.put("DATABASE LINK", (DBObjectValidator)new DatabaseLinkValidator(dBObjectProvider));
            map.put("OracleColumnProperties", new OracleColumnPropertiesValidator(dBObjectProvider));
            map.put("XMLTypeColumnProperties", new XMLTypeColumnPropertiesValidator(dBObjectProvider));
            map.put("OracleNestedTableProperties", new NestedTablePropertiesValidator(dBObjectProvider));
            map.put("OracleTableProperties", new OracleTablePropertiesValidator(dBObjectProvider));
        }
        if (Oracle10g.class.isAssignableFrom(this.getDatabaseClass())) {
            map.put("TABLESPACE", new OracleTablespaceValidator(dBObjectProvider));
            map.put("OracleTablespaceProperties", new OracleTablespacePropertiesValidator(dBObjectProvider));
            map.put("FILE_SPECIFICATION", new FileSpecificationValidator(dBObjectProvider));
        }
        return map;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        Class clazz = this.getDatabaseClass();
        OracleDDLGenerator oracleDDLGenerator = new OracleDDLGenerator(clazz, this.getDatabaseVersion(), dBObjectProvider);
        if (DBObjectRegistry.isActive()) {
            oracleDDLGenerator = new DelegateDDLGenerator((DDLGenerator)oracleDDLGenerator, (DatabaseDescriptor)this, clazz, dBObjectProvider);
        }
        return oracleDDLGenerator;
    }

    public Collection<String> listPreferredDataTypeNames() {
        return Arrays.asList("VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB");
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return new OracleSQLQueryBuilderFactory();
    }

    @Override
    public DerivedPropertyBuilder getDerivedPropertyBuilder(Class<? extends AbstractBuildableObject> clazz, DBObjectProvider dBObjectProvider) {
        DerivedPropertyBuilder derivedPropertyBuilder = OracleExternalTableProperties.class.equals(clazz) ? new ExternalTablePropertiesBuilder((AbstractDBObjectProvider)dBObjectProvider) : (BigDataAccessParameter.class.equals(clazz) ? new BigDataAccessParameterBuilder((AbstractDBObjectProvider)dBObjectProvider) : (OracleTablePartitions.class.equals(clazz) ? new ReferencePartitionModelIDBuilder((AbstractDBObjectProvider)dBObjectProvider) : (OracleIndexPartitions.class.equals(clazz) ? new LocalTablePartitionModelIDBuilder((AbstractDBObjectProvider)dBObjectProvider) : super.getDerivedPropertyBuilder(clazz, dBObjectProvider))));
        return derivedPropertyBuilder;
    }

    public PlSqlParserFactory getPlSqlParserFactory(DBObjectProvider dBObjectProvider) {
        return new PlSqlParserFactoryImpl(dBObjectProvider);
    }

    public boolean supportsRowID(DBObjectProvider dBObjectProvider, String string) {
        boolean bl = false;
        if (ModelUtil.hasLength((String)string)) {
            if (dBObjectProvider instanceof Database) {
                String string2 = "SELECT ROWID FROM " + string + " WHERE 1=2";
                StatementWrapper statementWrapper = new StatementWrapper((Database)dBObjectProvider, new String[]{string2});
                try {
                    statementWrapper.execute();
                    bl = true;
                }
                catch (DBException dBException) {
                    bl = false;
                }
            } else if (dBObjectProvider != null) {
                try {
                    String[] stringArray;
                    Schema schema = null;
                    PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
                    if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                        schema = dBObjectProvider.getSchema(dBObjectProvider.getInternalName(plSqlToken.getSource()));
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(2);
                        string = plSqlToken.getSource();
                    }
                    string = dBObjectProvider.getInternalName(string);
                    if (schema == null) {
                        schema = dBObjectProvider.getDefaultSchema();
                    }
                    DBObjectSet dBObjectSet = new DBObjectSet();
                    for (String string3 : stringArray = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM"}) {
                        SchemaObject schemaObject = dBObjectProvider.getObject(string3, schema, string);
                        if (!this.supportsRowID(dBObjectProvider, schemaObject, (Set<SchemaObject>)dBObjectSet)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (DBException dBException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean supportsRowID(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, Set<SchemaObject> set) throws DBException {
        boolean bl = false;
        if (schemaObject != null) {
            set.add(schemaObject);
            if (schemaObject instanceof Synonym) {
                SchemaObject schemaObject2;
                DBObjectID dBObjectID = ((Synonym)schemaObject).getReference();
                if (dBObjectID != null && !set.contains(schemaObject2 = (SchemaObject)dBObjectID.resolveID())) {
                    bl = this.supportsRowID(dBObjectProvider, schemaObject2, set);
                }
            } else if (schemaObject instanceof Table) {
                bl = true;
            } else if (schemaObject instanceof View) {
                View view = (View)schemaObject;
                DBUtil.ensureDerivedPropertiesBuilt((DBObject)view, (DBObjectProvider)dBObjectProvider);
                SQLQuery sQLQuery = view.getSQLQuery();
                if (sQLQuery != null && sQLQuery.isDeclarative()) {
                    boolean bl2 = bl = sQLQuery.getGroupByObject() == null && sQLQuery.getHierarchicalQueryObject() == null && sQLQuery.getSetOperator() == null;
                    if (bl) {
                        for (SelectObject selectObject : sQLQuery.getSelectObjects()) {
                            Function function;
                            SQLFragment sQLFragment = selectObject.getExpression();
                            if (!(sQLFragment instanceof Function) || !(function = (Function)sQLFragment).isDistinct() && !function.isGrouping()) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl) {
                        // empty if block
                    }
                }
            }
        }
        return bl;
    }

    public boolean isXE() {
        return OracleDatabaseXE.class.isAssignableFrom(this.getDatabaseClass());
    }

    public boolean isCompatibleWith(DatabaseDescriptor databaseDescriptor) {
        Class<? extends OracleDatabase> clazz;
        boolean bl = super.isCompatibleWith(databaseDescriptor);
        if (bl && "Oracle Database".equals(this.getDatabaseType()) && OracleDatabaseXE.class.isAssignableFrom(clazz = OracleDatabaseDescriptor.getDatabaseClass(databaseDescriptor.getDatabaseVersion())) && !this.isXE()) {
            bl = false;
        }
        return bl;
    }

    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    protected <T extends SystemObject> Collection<T> listBuiltInObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) {
        dBObjectCriteria.setDatabaseDescriptor((DatabaseDescriptor)this);
        Collection collection = super.listBuiltInObjectsImpl(dBObjectCriteria);
        if (this.isXE()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SystemObject systemObject = (SystemObject)iterator.next();
                if (!(systemObject instanceof Type) || !ORDSYS.equals(DBUtil.getSchemaName((DBObject)systemObject))) continue;
                iterator.remove();
            }
        }
        return collection;
    }

    public DataType getDataType(String string) {
        if (string.startsWith("TIMESTAMP")) {
            string = "TIMESTAMP";
        } else if (string.startsWith("INTERVAL YEAR")) {
            string = "INTERVAL YEAR";
        } else if (string.startsWith("INTERVAL DAY")) {
            string = "INTERVAL DAY";
        }
        return super.getDataType(string);
    }

    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        String string = this.getDatabaseType();
        if ("Oracle Database".equals(string)) {
            int n = this.getDatabaseVersion();
            if (n == 120) {
                dataTypeCache.registerDataType("NVARCHAR2");
                dataTypeCache.registerDataType("RAW");
                dataTypeCache.registerDataType("VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR2");
                dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR2");
                dataTypeCache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR2");
            } else if (n == 100) {
                dataTypeCache.registerDataType("BINARY_DOUBLE");
                dataTypeCache.registerDataType("BINARY_FLOAT");
            } else if (n == 92) {
                dataTypeCache.registerDataType("INTERVAL DAY");
                dataTypeCache.registerDataType("INTERVAL YEAR");
            } else if (n == 91) {
                dataTypeCache.registerDataType("CHAR");
                dataTypeCache.registerDataType("TIMESTAMP");
                dataTypeCache.registerDataType("VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
                dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
            } else if (n == 82) {
                dataTypeCache.registerDataType("UROWID");
            } else if (n == 81) {
                dataTypeCache.registerDataType("BFILE");
                dataTypeCache.registerDataType("BLOB");
                dataTypeCache.registerDataType("CLOB");
                dataTypeCache.registerDataType("NCHAR");
                dataTypeCache.registerDataType("NCLOB");
                dataTypeCache.registerDataType("NVARCHAR2");
                dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR", "NCHAR");
                dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR2");
                dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER", "NCHAR");
                dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR2");
                dataTypeCache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR2");
            } else if (n == 0) {
                dataTypeCache.registerDataType("CHAR");
                dataTypeCache.registerDataType("DATE");
                dataTypeCache.registerDataType("DOUBLE PRECISION");
                dataTypeCache.registerDataType("FLOAT");
                dataTypeCache.registerDataType("INT");
                dataTypeCache.registerDataType("INTEGER");
                dataTypeCache.registerDataType("LONG RAW");
                dataTypeCache.registerDataType("LONG");
                dataTypeCache.registerDataType((DataType)new OracleNumberDataType(0));
                dataTypeCache.registerDataType("RAW");
                dataTypeCache.registerDataType("REAL");
                dataTypeCache.registerDataType("ROWID");
                dataTypeCache.registerDataType("SMALLINT");
                dataTypeCache.registerDataType("VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
                dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("LONG VARCHAR", "LONG");
                dataTypeCache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
                dataTypeCache.registerDataTypeSynonym("DEC", "NUMBER");
                dataTypeCache.registerDataTypeSynonym("DECIMAL", "NUMBER");
                dataTypeCache.registerDataTypeSynonym("NUMERIC", "NUMBER");
            }
        }
    }

    protected void registerBuiltInObjects(BuiltInObjectCache builtInObjectCache) {
        String string = this.getDatabaseType();
        if ("Oracle Database".equals(string)) {
            int n = this.getDatabaseVersion();
            if (n == 110) {
                this.registerComplexTypes(builtInObjectCache, ORDSYS, "ORDDICOM");
                this.registerBuiltInIndextypes(builtInObjectCache, MDSYS, "RTREE_INDEX", "SEM_INDEXTYPE", "SPATIAL_INDEX");
                this.registerBuiltInIndextypes(builtInObjectCache, SYS, "XMLTABLEINDEX");
            } else if (n == 102) {
                this.registerComplexTypes(builtInObjectCache, MDSYS, "SDO_TOPO_GEOMETRY");
            } else if (n == 100) {
                this.registerComplexTypes(builtInObjectCache, MDSYS, "SDO_GEORASTER");
                this.registerComplexTypes(builtInObjectCache, ORDSYS, "SI_AVERAGECOLOR", "SI_COLOR", "SI_COLORHISTOGRAM", "SI_FEATURELIST", "SI_POSITIONALCOLOR", "SI_STILLIMAGE", "SI_TEXTURE");
                this.registerBuiltInIndextypes(builtInObjectCache, EFXSYS, "EXPFILTER");
                this.registerBuiltInIndextypes(builtInObjectCache, XDB, "XDBHI_IDTYP", "XMLINDEX");
            } else if (n == 91) {
                this.registerComplexTypes(builtInObjectCache, SYS, "ANYDATA", "ANYDATASET", "ANYTYPE", "DBURITYPE", "HTTPURITYPE", "URITYPE", "XDBURITYPE", "XMLTYPE");
                this.registerComplexTypes(builtInObjectCache, ORDSYS, "ORDDOC", "ORDIMAGESIGNATURE");
                this.registerComplexTypes(builtInObjectCache, "PUBLIC", "XMLTYPE");
                this.registerBuiltInIndextypes(builtInObjectCache, XDB, "PATH_INDEX", "XDBHI_IDTYP");
            } else if (n == 82) {
                this.registerComplexTypes(builtInObjectCache, ORDSYS, "ORDIMAGE", "ORDAUDIO", "ORDVIDEO", "ORDSOURCE");
                this.registerComplexTypes(builtInObjectCache, MDSYS, "SDO_GEOMETRY", "SDO_ORDINATE_ARRAY", "SDO_ELEM_INFO_ARRAY", "SDO_POINT_TYPE");
                this.registerBuiltInIndextypes(builtInObjectCache, CTXSYS, "CONTEXT", "CTXCAT", "CTXRULE", "CTXPATH");
                this.registerBuiltInIndextypes(builtInObjectCache, ORDSYS, "ORDIMAGEINDEX");
                this.registerBuiltInIndextypes(builtInObjectCache, MDSYS, "SPATIAL_INDEX", "RTREE_INDEX");
            }
        }
    }

    private void registerBuiltInIndextypes(BuiltInObjectCache builtInObjectCache, String string, String ... stringArray) {
        if (stringArray != null) {
            Schema schema = new Schema(string);
            for (int i = 0; i < stringArray.length; ++i) {
                Indextype indextype = new Indextype(stringArray[i], schema);
                builtInObjectCache.registerBuiltInObject((SystemObject)indextype);
            }
        }
    }

    private void registerComplexTypes(BuiltInObjectCache builtInObjectCache, String string, String ... stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                builtInObjectCache.registerBuiltInObject("TYPE", string, string2);
            }
        }
    }

    @Override
    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider dBObjectProvider, Schema schema) {
        if ("Y".equals(System.getProperty("oracle.javatools.db.ora.sql.SqlUsageUtil"))) {
            return new SqlUsageUtil();
        }
        return super.getSqlAliasExpander(dBObjectProvider, schema);
    }

    public DBObjectLister getTriggerLister(DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider instanceof OracleDatabaseImpl) {
            return new OracleTriggerLister((OracleDatabaseImpl)dBObjectProvider);
        }
        return super.getTriggerLister(dBObjectProvider);
    }

    protected void initialiseDefaultSourceOptions(DefaultSourceOptions defaultSourceOptions) {
        defaultSourceOptions.setUseCreateOrReplace(true);
        defaultSourceOptions.setIncludeTerminators(false);
        defaultSourceOptions.setEnableTriggers(true);
    }

    public String getBuiltInFunctionDescription(BuiltInFunction builtInFunction) {
        String string;
        try {
            string = OracleFunctionsBundle.get(builtInFunction.getName());
        }
        catch (MissingResourceException missingResourceException) {
            string = null;
        }
        return string;
    }

    public static int getDatabaseVersion(Class<? extends OracleDatabase> clazz) {
        return OracleDatabaseFactory.getDatabaseVersion(clazz);
    }

    private static Class<? extends OracleDatabase> getDatabaseClass(int n) {
        return OracleDatabaseFactory.getDatabaseClass(n);
    }

    private static class OracleTriggerLister
    extends DBObjectLister {
        protected OracleTriggerLister(OracleDatabaseImpl oracleDatabaseImpl) {
            super((DBObjectProvider)oracleDatabaseImpl);
        }

        private OracleDatabaseImpl getDatabase() {
            return (OracleDatabaseImpl)this.getProvider();
        }

        public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria dBObjectCriteria) throws DBException {
            final HashSet<DBObjectLister.ObjectInfo> hashSet = new HashSet<DBObjectLister.ObjectInfo>();
            Collection collection = dBObjectCriteria.getTypes();
            if (collection.size() != 1 || !collection.contains("TABLE") && !collection.contains("VIEW") && !collection.contains("SCHEMA")) {
                throw new IllegalArgumentException("Criteria for just one of TABLE, VIEW or SCHEMA expected");
            }
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)null, "SELECT  /*OracleDictionaryQueries.ALL_TRIGGERS_FOR_BASE_OBJECT_QUERY*/\n       O.OBJECT_TYPE, T.OWNER, T.TRIGGER_NAME, O.OBJECT_ID\nFROM   SYS.ALL_TRIGGERS T\n,      SYS.ALL_OBJECTS O\nWHERE  T.BASE_OBJECT_TYPE = ?\nAND    ( T.TABLE_OWNER = ? OR T.BASE_OBJECT_TYPE = 'DATABASE' )\nAND    ( ( T.BASE_OBJECT_TYPE IN ( 'TABLE','VIEW') AND T.TABLE_NAME LIKE ? ) OR\n         ( T.BASE_OBJECT_TYPE IN ( 'SCHEMA','DATABASE') AND T.TABLE_NAME IS NULL ) \n       )\nAND    O.OBJECT_TYPE = 'TRIGGER'\nAND    O.OWNER = T.OWNER\nAND    O.OBJECT_NAME = T.TRIGGER_NAME", collection.toArray()[0], dBObjectCriteria.getSchemaName(), dBObjectCriteria.getNameLike());
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            Schema schema = this.getDatabase().getSchema(resultSet.getString(2));
                            String string2 = resultSet.getString(3);
                            BigInteger bigInteger = new BigInteger(resultSet.getString(4));
                            hashSet.add(new DBObjectLister.ObjectInfo(string, schema, string2, (Object)bigInteger));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
            return hashSet;
        }
    }
}

