/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBException;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.OracleTablespaceBuilder;
import oracle.javatools.db.resource.APIBundle;

public class Oracle12cR2
extends Oracle12c {
    Oracle12cR2(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, n);
    }

    public boolean isShardedUser() {
        final boolean[] blArray = new boolean[]{false};
        String string = "SELECT /*OracleDictionaryQueries.SHARDED_USER_12c2_QUERY*/\n      ALL_SHARD \nFROM  USER_USERS";
        try {
            final QueryWrapper queryWrapper = this.newQueryWrapper(null, string, Collections.EMPTY_LIST);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            blArray[0] = resultSet.getString(1).equals("YES");
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(null, sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            Logger.getLogger(OracleTablespaceBuilder.class.getName()).log(Level.WARNING, "error check shard ddl enabled", dBException);
        }
        return blArray[0];
    }

    public boolean isShardDDLEnabled() {
        final boolean[] blArray = new boolean[]{false};
        String string = null;
        int n = this.getDatabaseVersion();
        if (n > 1220) {
            string = "SELECT /*OracleDictionaryQueries.SHARD_DDL_ENABLED_12c202_QUERY*/\n      S.SHARD_DDL_STATUS \nFROM  V$SESSION S, \n      GSMADMIN_INTERNAL.CLOUD C\nWHERE S.AUDSID=USERENV('sessionid') AND C.DATABASE_FLAGS = 'C'";
        } else if (n == 1220) {
            string = "SELECT /*OracleDictionaryQueries.SHARD_DDL_ENABLED_12c2_QUERY*/\n      S.SHARD_DDL_STATUS \nFROM  V$SESSION S \nWHERE S.AUDSID=USERENV('sessionid')";
        }
        if (string != null) {
            try {
                final QueryWrapper queryWrapper = this.newQueryWrapper(null, string, Collections.EMPTY_LIST);
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                blArray[0] = resultSet.getString(1).equals("ENABLED");
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(null, sQLException);
                        }
                    }
                };
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (DBException dBException) {
                Logger.getLogger(OracleTablespaceBuilder.class.getName()).log(Level.WARNING, "error check shard ddl enabled", dBException);
            }
        }
        return blArray[0];
    }

    public boolean isShardingCatalog() {
        final boolean[] blArray = new boolean[]{false};
        String string = null;
        int n = this.getDatabaseVersion();
        if (n > 1220) {
            string = "SELECT /*OracleDictionaryQueries.SHARDING_CATALOG_12c202_QUERY*/\n       COUNT(*) C from GSMADMIN_INTERNAL.CLOUD WHERE DATABASE_FLAGS = 'C'";
        } else if (n == 1220) {
            string = "SELECT /*OracleDictionaryQueries.SHARDING_CATALOG_12c2_QUERY*/\n       COUNT(*) C from GSMADMIN_INTERNAL.CLOUD";
        }
        if (string != null) {
            try {
                final QueryWrapper queryWrapper = this.newQueryWrapper(null, string, Collections.EMPTY_LIST);
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                blArray[0] = resultSet.getInt(1) > 0;
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(null, sQLException);
                        }
                    }
                };
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (DBException dBException) {
                Logger.getLogger(OracleTablespaceBuilder.class.getName()).log(Level.WARNING, "error check shard ddl enabled", dBException);
            }
        }
        return blArray[0];
    }

    public List<String> getTablespaceSets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        QueryWrapper queryWrapper = this.newQueryWrapper(null, "select /*OracleDictionaryQueries.TABLESPACE_SETS_QUERY*/\n       case when upper(tablespace_name) = tablespace_name then tablespace_name else '\"' || tablespace_name || '\"' end as tablespace_name from dba_tablespaces where chunk_tablespace = 'Y'", new Object[0]);
        try {
            queryWrapper.executeQuery(resultSet -> this.processTablespaceSetsResultSet(resultSet, arrayList));
        }
        catch (DBException dBException) {
            this.getLogger().warning(APIBundle.format((String)"MT_CONTAINER_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
        }
        return arrayList;
    }

    private void processTablespaceSetsResultSet(ResultSet resultSet, List<String> list) throws DBException, SQLException {
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            list.add(string);
        }
    }
}

