/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.dcn.DatabaseChangeRegistration;

public class Oracle10gR2
extends Oracle10g {
    Oracle10gR2(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, n);
    }

    @Override
    public boolean supportsDatabaseChangeNotification() {
        boolean bl;
        try {
            bl = this.getConnection(false) instanceof OracleConnection;
        }
        catch (DBException dBException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDatabaseChangeNotificationCompatible(String string, boolean bl, boolean bl2) throws DBException {
        boolean bl3 = false;
        Connection connection = this.getConnection();
        if (connection instanceof OracleConnection) {
            OracleConnection oracleConnection = (OracleConnection)connection;
            Properties properties = new Properties();
            if (bl) {
                properties.setProperty("DCN_QUERY_CHANGE_NOTIFICATION", "true");
            }
            if (bl2) {
                properties.setProperty("DCN_BEST_EFFORT", "true");
            }
            DatabaseChangeRegistration databaseChangeRegistration = null;
            try {
                databaseChangeRegistration = oracleConnection.registerDatabaseChangeNotification(properties);
            }
            catch (SQLException sQLException) {
                throw new DBException(null, sQLException.getMessage(), (Throwable)sQLException);
            }
            if (databaseChangeRegistration != null) {
                try {
                    OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement(string);
                    oraclePreparedStatement.setDatabaseChangeRegistration(databaseChangeRegistration);
                    for (String string2 : SQLFragmentUtils.listBindVariables((String)string)) {
                        oraclePreparedStatement.setNullAtName(string2, 12);
                    }
                    try {
                        ResultSet resultSet = oraclePreparedStatement.executeQuery();
                        resultSet.close();
                        bl3 = true;
                    }
                    catch (SQLException sQLException) {
                        int n = sQLException.getErrorCode();
                        if (n == 29983) {
                            bl3 = false;
                        }
                        throw new DBException(null, sQLException.getMessage(), (Throwable)sQLException);
                    }
                    finally {
                        try {
                            oraclePreparedStatement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (SQLException sQLException) {
                    throw new DBException(null, sQLException.getMessage(), (Throwable)sQLException);
                }
                finally {
                    try {
                        oracleConnection.unregisterDatabaseChangeNotification(databaseChangeRegistration);
                    }
                    catch (SQLException sQLException) {
                        this.getLogger().warning("DCN deregistration failed: " + sQLException.getMessage());
                    }
                }
            }
        } else {
            bl3 = super.isDatabaseChangeNotificationCompatible(string, bl, bl2);
        }
        return bl3;
    }
}

