/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.ide.util.Assert;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;

public class MaterializedViewLogBuilder
extends OracleDBObjectBuilder<MaterializedViewLog> {
    MaterializedViewLogBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "MATERIALIZED VIEW LOG");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"masterTableID", "logTable", "rowidLogged", "primaryKeyLogged", "objectIdLogged", "sequenceLogged", "newValues", "cache", "parallelDegree"})
    public void fillInBaseProperties(final MaterializedViewLog materializedViewLog) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)materializedViewLog, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_OBJECT_QUERY*/\n       L.MASTER, L.LOG_TABLE, L.ROWIDS, L.PRIMARY_KEY, \n       L.OBJECT_ID, L.SEQUENCE, L.INCLUDE_NEW_VALUES, \n       T.CACHE, T.DEGREE \nFROM SYS.ALL_SNAPSHOT_LOGS L, \n     SYS.ALL_TABLES T \nWHERE T.TABLE_NAME = L.LOG_TABLE \nAND   T.OWNER = L.LOG_OWNER \nAND   L.LOG_OWNER = ''{0}'' AND L.MASTER = ''{1}''", materializedViewLog.getSchema(), materializedViewLog);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                block10: {
                    try {
                        if (!resultSet.next()) break block10;
                        int n = 1;
                        SchemaObject schemaObject = null;
                        String string = resultSet.getString(n++);
                        try {
                            schemaObject = MaterializedViewLogBuilder.this.getDatabase().getObject("TABLE", materializedViewLog.getSchema(), string);
                        }
                        catch (DBException dBException) {
                            Assert.printStackTrace();
                            return;
                        }
                        if (schemaObject == null) {
                            try {
                                schemaObject = MaterializedViewLogBuilder.this.getDatabase().getObject("MATERIALIZED VIEW", materializedViewLog.getSchema(), string);
                            }
                            catch (DBException dBException) {
                                Assert.printStackTrace();
                                return;
                            }
                        }
                        if (schemaObject != null) {
                            materializedViewLog.setMasterTableID(schemaObject.getID());
                        }
                        materializedViewLog.setLogTable(resultSet.getString(n++));
                        materializedViewLog.setRowidLogged(MaterializedViewLogBuilder.parseBoolean(resultSet.getString(n++)));
                        materializedViewLog.setPrimaryKeyLogged(MaterializedViewLogBuilder.parseBoolean(resultSet.getString(n++)));
                        materializedViewLog.setObjectIdLogged(MaterializedViewLogBuilder.parseBoolean(resultSet.getString(n++)));
                        materializedViewLog.setSequenceLogged(MaterializedViewLogBuilder.parseBoolean(resultSet.getString(n++)));
                        materializedViewLog.setNewValues(MaterializedViewLogBuilder.parseBoolean(resultSet.getString(n++)));
                        materializedViewLog.setCache(MaterializedViewLogBuilder.parseBoolean(resultSet.getString(n++)));
                        String string2 = resultSet.getString(n++).trim();
                        if ("DEFAULT".equals(string2)) {
                            materializedViewLog.setParallelDegree(Integer.valueOf(0));
                        } else {
                            materializedViewLog.setParallelDegree(Integer.valueOf(string2));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleStorageProperties"}, depends={"logTable"})
    public void fillInOSP(final MaterializedViewLog materializedViewLog) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)materializedViewLog, this.getTableQuery(), materializedViewLog.getSchema(), materializedViewLog.getLogTable());
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        OracleStorageProperties oracleStorageProperties = OracleTableBuilder.getSegmentAttributeProperties(resultSet, MaterializedViewLogBuilder.this.getDatabase());
                        materializedViewLog.setProperty("OracleStorageProperties", (Object)oracleStorageProperties);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)materializedViewLog, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columnIDs"}, depends={"masterTableID", "logTable"})
    public void fillInColumns(final MaterializedViewLog materializedViewLog) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)materializedViewLog, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_COLUMNS_QUERY*/\n     TC.COLUMN_NAME \nFROM SYS.ALL_TAB_COLS TC\nWHERE TC.OWNER = ?\n  AND TC.TABLE_NAME = ?\n  AND TC.COLUMN_NAME IN \n  ( SELECT TC2.COLUMN_NAME \n    FROM SYS.ALL_TAB_COLS TC2\n    WHERE TC2.OWNER = TC.OWNER\n      AND TC2.TABLE_NAME = ?\n    MINUS \n    SELECT ACC.COLUMN_NAME \n    FROM SYS.ALL_CONS_COLUMNS ACC \n    WHERE ACC.OWNER = TC.OWNER \n      AND ACC.TABLE_NAME = ? \n      AND ACC.CONSTRAINT_NAME = \n    ( SELECT C.CONSTRAINT_NAME FROM SYS.ALL_CONSTRAINTS C \n      WHERE C.CONSTRAINT_TYPE = 'P' AND C.TABLE_NAME = ACC.TABLE_NAME \n        AND C.OWNER = TC.OWNER ) ) \nORDER BY TC.COLUMN_ID", materializedViewLog.getSchema(), materializedViewLog.getLogTable(), materializedViewLog, materializedViewLog);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    DBObjectID dBObjectID = materializedViewLog.getMasterTableID();
                    ArrayList<NameBasedID> arrayList = new ArrayList<NameBasedID>();
                    while (resultSet.next()) {
                        NameBasedID nameBasedID = new NameBasedID("COLUMN", resultSet.getString(1), dBObjectID);
                        arrayList.add(nameBasedID);
                    }
                    materializedViewLog.setColumnIDs(arrayList.toArray(new DBObjectID[arrayList.size()]));
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private String getTableQuery() {
        return OracleTableBuilder.getTableQuery(this.getDatabase());
    }

    public static String getCandidateTablesQuery() {
        return "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_CANDIDATE_TABLES_QUERY*/\n       T.TABLE_NAME \n,      DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') OBJECT_TYPE\n,     (SELECT O.OBJECT_ID\n       FROM   SYS.ALL_OBJECTS O \n       WHERE  O.OWNER = T.OWNER \n       AND    O.OBJECT_TYPE = DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') \n       AND    O.OBJECT_NAME = T.TABLE_NAME) OBJECT_ID \nFROM   SYS.ALL_TABLES T \n,      SYS.ALL_MVIEWS MV\nWHERE  T.OWNER = ? \nAND    T.TEMPORARY = 'N' \nAND    T.NESTED = 'NO' \nAND    T.IOT_NAME IS NULL \nAND    T.SECONDARY = 'N'\nAND    MV.MVIEW_NAME (+) = T.TABLE_NAME\nAND    MV.OWNER (+) = T.OWNER\nAND    NOT EXISTS (SELECT 1 \n                   FROM   SYS.ALL_SNAPSHOT_LOGS L   \n                   WHERE  (L.MASTER = T.TABLE_NAME OR \n                           L.LOG_TABLE = T.TABLE_NAME) \n                   AND    L.LOG_OWNER = T.OWNER) \nAND    NOT EXISTS (SELECT 1 \n                   FROM   SYS.ALL_EXTERNAL_TABLES E \n                   WHERE  E.TABLE_NAME = T.TABLE_NAME \n                   AND    E.OWNER = T.OWNER)\nORDER BY 1";
    }

    private static Boolean parseBoolean(String string) {
        return "Y".equals(string.trim()) || "YES".equals(string.trim()) ? Boolean.TRUE : Boolean.FALSE;
    }
}

