/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class DirectoryBuilder
extends OracleDBObjectBuilder<Directory> {
    DirectoryBuilder(Oracle8 oracle8) {
        super(oracle8, "DIRECTORY");
    }

    protected void fillInObject(final Directory directory) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)directory, "SELECT /*OracleDictionaryQueries.ALL_DIRECTORY_QUERY*/\n       DIRECTORY_PATH FROM SYS.ALL_DIRECTORIES WHERE OWNER = ? AND DIRECTORY_NAME = ? ", directory.getSchema(), directory);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        directory.setPath(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)directory, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }
}

