/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.MultitenantContainerInfo;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleQueryWrapper;
import oracle.javatools.db.ora.OracleSchemaBuilder;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.db.ora.OracleSequenceBuilder;
import oracle.javatools.db.ora.OracleSynonymBuilder;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleViewBuilder;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseOracleDatabase
extends DictionaryDatabase
implements OracleDatabase {
    private final OracleDictionaryQueries m_dictionary = new OracleDictionaryQueries(this);
    private SessionParameterQueryMap m_nlsParamQueries = null;
    private final Holder<String> m_databaseLinkNameSuffix = new Holder();

    BaseOracleDatabase(String string, String string2, Connection connection, String string3, int n) {
        super(string, string2, connection, string3, n);
    }

    public OracleDictionaryQueries getDictionaryQueries() {
        return this.m_dictionary;
    }

    public void disableDBAViews() {
        this.m_dictionary.disableDBAViews();
    }

    @Deprecated
    public int getOracleDatabaseType() {
        return this.getDatabaseVersion();
    }

    public MultitenantContainerInfo getMultitenantContainerInfo() {
        return null;
    }

    protected QueryWrapper newQueryWrapper(SystemObject systemObject, String string, Object ... objectArray) {
        return this.newQueryWrapper(systemObject, string, Arrays.asList(objectArray));
    }

    protected QueryWrapper newQueryWrapper(SystemObject systemObject, String string, List list) {
        OracleQueryWrapper oracleQueryWrapper = new OracleQueryWrapper(this, string, list);
        oracleQueryWrapper.setContextObject((DBObject)systemObject);
        return oracleQueryWrapper;
    }

    protected final boolean isPublicSchema(Schema schema) {
        return schema != null && "PUBLIC".equals(schema.getName());
    }

    protected final boolean isCurrentUser(Schema schema) {
        return schema != null && ModelUtil.areEqual((Object)this.getUserName(), (Object)schema.getName());
    }

    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_databaseLinkNameSuffix.set(null);
        if (this.m_nlsParamQueries != null) {
            this.m_nlsParamQueries.markAsDirty();
        }
    }

    protected String getTransactionTestQuery() {
        return "SELECT /*OracleDictionaryQueries.LOCAL_TRANSACTION_QUERY*/ dbms_transaction.local_transaction_id FROM SYS.DUAL";
    }

    protected void registerBuilders() {
        this.registerBuilder("SCHEMA", (DBObjectBuilder)new OracleSchemaBuilder(this));
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new OracleSynonymBuilder(this));
        this.registerBuilder("SEQUENCE", (DBObjectBuilder)new OracleSequenceBuilder(this));
        this.registerBuilder("TABLE", (DBObjectBuilder)new OracleTableBuilder(this));
        this.registerBuilder("INDEX", (DBObjectBuilder)new OracleIndexBuilder(this));
        this.registerBuilder("VIEW", (DBObjectBuilder)new OracleViewBuilder(this));
    }

    public boolean supportsDebugging() {
        return false;
    }

    protected DBObjectBuilder getBuilderForType(String string) {
        return super.getBuilderForType(string);
    }

    <T extends AbstractBuildableObject> void setOracleBuilder(T t, OracleDBObjectBuilder<? super T> oracleDBObjectBuilder) {
        this.markForLazyInit(t, (DBObjectBuilder)oracleDBObjectBuilder);
    }

    protected void cacheObject(SystemObject systemObject, boolean bl) {
        super.cacheObject(systemObject, bl);
    }

    public boolean hasSystemPrivilege(String string, Schema schema, String string2) {
        return !ModelUtil.areEqual((Object)"CREATE", (Object)string2) && super.hasSystemPrivilege(string, schema, string2);
    }

    public void validateUniqueName(DBObject dBObject, final DBObject dBObject2) throws NameInUseException {
        String string = dBObject.getName();
        String string2 = dBObject.getType();
        if (ModelUtil.hasLength((String)string)) {
            if (!(dBObject2 instanceof Schema)) {
                super.validateUniqueName(dBObject, dBObject2);
                return;
            }
            Schema schema = (Schema)dBObject2;
            if ("DATABASE LINK".equals(string2)) {
                NameInUseException nameInUseException = null;
                String string3 = this.getGlobalName();
                try {
                    for (String string4 : this.listObjects("DATABASE LINK", schema, string)) {
                        if (!string4.equals(string) && !string4.equals(string + string3)) continue;
                        nameInUseException = new NameInUseException(dBObject, string4, "DATABASE LINK");
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (nameInUseException != null) {
                    throw nameInUseException;
                }
            } else {
                final Holder holder = new Holder();
                String string5 = this.m_dictionary.getValidateNamespaceQuery(string2);
                List list = this.getParameters(this.m_dictionary.getValidateNamespaceQueryParams(string2), BaseOracleDatabase.convertObject((DBObject)schema), string, null);
                final QueryWrapper queryWrapper = this.newQueryWrapper((SystemObject)null, string5, list);
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                holder.set((Object)new String[]{resultSet.getString(1), resultSet.getString(2)});
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(dBObject2, sQLException);
                        }
                    }
                };
                try {
                    queryWrapper.executeQuery(queryRunnable);
                }
                catch (DBException dBException) {
                    this.getLogger().log(Level.WARNING, APIBundle.format((String)"UNIQUE_NAME_CHECK_ERR", (Object[])new Object[]{dBException.getMessage()}));
                }
                String[] stringArray = (String[])holder.get();
                if (stringArray != null) {
                    throw new NameInUseException(dBObject, stringArray[0], stringArray[1]);
                }
            }
        }
    }

    public String getUniqueName(String string, DBObject dBObject, String object) {
        if (!(dBObject instanceof Schema)) {
            return super.getUniqueName(string, dBObject, (String)object);
        }
        Schema schema = (Schema)dBObject;
        if ("DATABASE LINK".equals(string)) {
            if (!ModelUtil.hasLength((String)object)) {
                object = "DBLINK";
            }
            try {
                String string2 = this.getGlobalName();
                String string3 = ((String)object).split("\\.")[0];
                String string4 = ((String)object).replaceFirst((String)object, "");
                HashSet<String> hashSet = new HashSet<String>();
                boolean bl = false;
                for (String string5 : this.listObjects("DATABASE LINK", schema)) {
                    if (string5.equals(object) || string5.equals((String)object + string2)) {
                        bl = true;
                    }
                    hashSet.add(string5.split("\\.")[0]);
                }
                return bl ? DBUtil.getUniqueName(hashSet, (String)string3) + string4 : object;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        final HashSet hashSet = new HashSet();
        string = this.normaliseType(string);
        if (!ModelUtil.hasLength((String)object)) {
            object = string + "1";
        }
        int n = this.getDescriptor().getMaxNameLength(string);
        Object object2 = object;
        if (((String)object2).length() > n - 3) {
            object2 = ((String)object2).substring(0, n - 3);
        }
        String string6 = ((String)object2).replaceAll("\\d*$", "") + "%";
        String string7 = this.m_dictionary.getNamespaceQuery(string);
        List list = this.getParameters(this.m_dictionary.getNamespaceQueryParams(string), BaseOracleDatabase.convertObject((DBObject)schema), string6, null);
        final QueryWrapper queryWrapper = this.newQueryWrapper((SystemObject)null, string7, list);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        hashSet.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, APIBundle.format((String)"UNIQUE_NAME_CHECK_ERR", (Object[])new Object[]{dBException.getMessage()}));
        }
        return DBUtil.getUniqueName(hashSet, (String)object, (boolean)true, (int)n);
    }

    public boolean canRestrictSchemaList() {
        return true;
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        Collection collection = super.listObjectsImpl(dBObjectCriteria);
        if (dBObjectCriteria.isAllowedType("SCHEMA") && dBObjectCriteria.isAllowedName("PUBLIC") && dBObjectCriteria.getDatabaseName() == null) {
            Schema schema = (Schema)this.findOrCreateObject("SCHEMA", null, "PUBLIC", null);
            collection.add(schema);
        }
        return collection;
    }

    protected <T extends SystemObject> T loadObjectImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        String string = dBObjectCriteria.getName();
        SystemObject systemObject = dBObjectCriteria.isAllowedType("SCHEMA") && ("PUBLIC".equals(string) || ModelUtil.areEqual((Object)this.getUserName(), (Object)string)) ? this.findOrCreateObject("SCHEMA", null, string, null) : super.loadObjectImpl(dBObjectCriteria);
        return (T)systemObject;
    }

    public boolean supportsTimestamps(String string) {
        boolean bl = "DATABASE LINK".equals(string) || "XML SCHEMA".equals(string) || !Metadata.getInstance().isTypeOf(SchemaObject.class, string) ? false : super.supportsTimestamps(string);
        return bl;
    }

    protected Long getRefinedTimestamp(SystemObject systemObject, Long l) throws DBException {
        Map map;
        Object v;
        Long l2 = l;
        String string = systemObject.getType();
        if ("PACKAGE".equals(string) || "TYPE".equals(string)) {
            String string2 = "PACKAGE".equals(string) ? "PACKAGE BODY" : "TYPE BODY";
            String string3 = systemObject.getName();
            Schema schema = DBUtil.getSchema((DBObject)systemObject);
            SystemObject systemObject2 = this.findObject(string2, schema, string3);
            Long l3 = systemObject2 != null ? this.getExistingTimestamp(systemObject2) : this.getExternalTimestampByName(string2, schema, string3);
            if (l3 != null && l3.compareTo(l2) > 0) {
                l2 = l3;
            }
        } else if ("TABLE".equals(string) && (v = (map = DBUtil.getFrozenProperties((DBObject)systemObject)).get("indexes")) instanceof Index[]) {
            for (Index index : (Index[])v) {
                Long l4 = this.getExternalTimestamp((SystemObject)index);
                if (l4 == null && index.getID() != null) {
                    l4 = this.getExternalTimestampByName(index.getType(), index.getSchema(), index.getName());
                }
                if (l4 == null) {
                    Long l5 = (Long)map.get("Timestamp");
                    if (l5 == null || !l5.equals(l2)) continue;
                    Long l6 = l2;
                    Long l7 = l2 = Long.valueOf(l2 + 1L);
                    continue;
                }
                if (l4.compareTo(l2) <= 0) continue;
                l2 = l4;
            }
        }
        return l2;
    }

    protected <T extends SystemObject> T checkCachedObject(T t) throws DBException {
        Object object = t instanceof Schema && (this.isCurrentUser((Schema)t) || this.isPublicSchema((Schema)t)) ? t : super.checkCachedObject(t);
        return (T)object;
    }

    @Deprecated
    public final String[] listTablespaces() {
        final ArrayList arrayList = new ArrayList();
        final QueryWrapper queryWrapper = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.QUERY_TABLESPACES*/ TABLESPACE_NAME FROM SYS.USER_TABLESPACES WHERE CONTENTS = 'PERMANENT'", new Object[0]);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Could not query tablespaces from {0}: {1}", new Object[]{this.getConnectionName(), dBException.getMessage()});
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected boolean isCauseNameInUse(DBException dBException) {
        int n;
        Throwable throwable = dBException.getCause();
        return throwable instanceof SQLException && ((n = ((SQLException)throwable).getErrorCode()) == 955 || n == 12000 || n == 12006 || n == 2011);
    }

    protected void processDeleteException(DBException dBException, SystemObject systemObject) throws DBException {
        Throwable throwable = dBException.getCause();
        if (throwable instanceof SQLException) {
            int n = ((SQLException)throwable).getErrorCode();
            if (n == 2441 || n == 2442 || n == 2443) {
                return;
            }
            if (n == 2449) {
                throw new CascadeRequiredException((DBObject)systemObject, throwable.getMessage());
            }
        }
        throw dBException;
    }

    public String getDatabaseSource(String string, Schema schema, String string2, String string3) throws DBException {
        SchemaObject schemaObject;
        String string4 = null;
        String string5 = string;
        if ("Body".equals(string3)) {
            if ("PACKAGE".equals(string5)) {
                string5 = "PACKAGE BODY";
            } else if ("TYPE".equals(string5)) {
                string5 = "TYPE BODY";
            }
        }
        if ((schemaObject = this.getObject(string5, schema, string2)) instanceof SourceObject) {
            string4 = ((SourceObject)schemaObject).getSource();
        }
        if (string4 == null) {
            return null;
        }
        if (!(schemaObject instanceof PlSqlSourceObject)) {
            return string4;
        }
        if (string4.indexOf("CREATE OR REPLACE") == 0) {
            return string4;
        }
        return "CREATE OR REPLACE \n" + string4;
    }

    public String getDatabaseSource(String string, Schema schema, String string2) throws DBException {
        return this.getDatabaseSource(string, schema, string2, null);
    }

    protected SystemObject getCreatedObject(String string, Schema schema, String string2) throws DBException {
        SystemObject systemObject = super.getCreatedObject(string, schema, string2);
        if (systemObject == null && string.equals("DATABASE LINK")) {
            DBObjectCriteria dBObjectCriteria = new DBObjectCriteria(DatabaseLink.class, new String[0]);
            dBObjectCriteria.setName(string2 + this.getGlobalName());
            dBObjectCriteria.setSchema(schema);
            Collection collection = this.listObjects(dBObjectCriteria);
            if (collection != null & collection.size() == 1) {
                systemObject = (SystemObject)collection.iterator().next();
            }
        }
        return systemObject;
    }

    protected Schema createSchema(Connection connection) {
        final Holder holder = new Holder();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this, "SELECT /*OracleDictionaryQueries.CURR_USER_QUERY*/ \n       USERNAME\n,      DEFAULT_TABLESPACE\n,      TEMPORARY_TABLESPACE\nFROM   SYS.USER_USERS\nUNION ALL\nSELECT USER, NULL, NULL\nFROM   SYS.DUAL\nWHERE  NOT EXISTS (SELECT 1 FROM SYS.USER_USERS)");
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        Schema schema = BaseOracleDatabase.this.createSchema(resultSet.getString(1));
                        OracleSchemaProperties oracleSchemaProperties = new OracleSchemaProperties();
                        oracleSchemaProperties.setDefaultTablespace(resultSet.getString(2));
                        oracleSchemaProperties.setTemporaryTablespace(resultSet.getString(3));
                        schema.setProperty("OracleSchemaProperties", (Object)oracleSchemaProperties);
                        holder.set((Object)schema);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        Schema schema = null;
        try {
            queryWrapper.executeQuery(queryRunnable);
            schema = (Schema)holder.get();
        }
        catch (DBException dBException) {
            try {
                schema = this.createSchema(connection.getMetaData().getUserName());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return schema;
    }

    protected <T extends SystemObject> boolean isRequestedObject(T t, DBObjectCriteria<T> dBObjectCriteria) {
        Schema schema;
        boolean bl = super.isRequestedObject(t, dBObjectCriteria);
        if (!bl && dBObjectCriteria.isAllowedType("DATABASE LINK") && "DATABASE LINK".equals(t.getType()) && (schema = ((SchemaObject)t).getSchema()) != null && dBObjectCriteria.isAllowedSchema(schema)) {
            bl = t.getName().equals(dBObjectCriteria.getName() + this.getGlobalName());
        }
        return bl;
    }

    public String getGlobalName() {
        if (this.m_databaseLinkNameSuffix.get() == null) {
            final Holder holder = new Holder();
            final OracleQueryWrapper oracleQueryWrapper = new OracleQueryWrapper(this, "SELECT /*OracleDictionaryQueries.QUERY_GLOBAL_NAME*/ GLOBAL_NAME FROM GLOBAL_NAME ", new Object[0]);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            holder.set((Object)resultSet.getString(1));
                        }
                    }
                    catch (SQLException sQLException) {
                        oracleQueryWrapper.throwDBException(sQLException);
                    }
                }
            };
            String string = "";
            try {
                oracleQueryWrapper.executeQuery(queryRunnable);
                String string2 = (String)holder.get();
                if (string2 != null && string2.indexOf(".") != -1) {
                    string = string2.substring(string2.indexOf("."), string2.length());
                }
            }
            catch (DBException dBException) {
                this.getLogger().warning(APIBundle.format((String)"GLOBAL_NAME_CHECK_ERR", (Object[])new Object[]{dBException.getMessage()}));
            }
            this.m_databaseLinkNameSuffix.set((Object)string);
        }
        return (String)this.m_databaseLinkNameSuffix.get();
    }

    public final String getSessionParameterValue(String string) {
        return this.getSessionQueriesImpl().getValue(string);
    }

    public final void alterSessionParameterValue(String string, String string2) throws DBException {
        this.getSessionQueriesImpl().setValue(string, string2);
    }

    public final void markSessionParametersDirty() {
        this.getSessionQueriesImpl().markAsDirty();
    }

    public final Map<String, String> getSessionParameterQueries() {
        return this.getSessionQueriesImpl();
    }

    private SessionParameterQueryMap getSessionQueriesImpl() {
        if (this.m_nlsParamQueries == null) {
            this.m_nlsParamQueries = new SessionParameterQueryMap(this);
            this.initSessionParameterQueryMap(this.m_nlsParamQueries);
        }
        return this.m_nlsParamQueries;
    }

    protected void initSessionParameterQueryMap(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        map.put("NLS_SESSION_PARAMS", "select /*OracleDictionaryQueries.NLS_SESSION_PARAMS_QUERY*/\n       s.parameter, s.value \nfrom  sys.nls_session_parameters s");
        map.put("NLS_CHARACTERSET", "select /*OracleDictionaryQueries.NLS_CHARACTERSET_QUERY*/\n       d.parameter, d.value \nfrom  sys.nls_database_parameters d \nwhere d.parameter = 'NLS_CHARACTERSET'");
        map.put("NLS_CHARSET_ID", "select /*OracleDictionaryQueries.NLS_CHARSET_ID_QUERY*/\n     'NLS_CHARSET_ID' parameter, to_char(/**/NLS_CHARSET_ID(charset.value)) value\nfrom (select value\n      from sys.nls_database_parameters\n      where parameter = 'NLS_CHARACTERSET') charset \n");
        map.put("NLS_OTHER_DATABASE_PARAMS", "select /*OracleDictionaryQueries.NLS_OTHER_DATABASE_PARAMS_QUERY*/\n       d.parameter, d.value \nfrom  sys.nls_database_parameters d \nwhere not exists (select 1 from sys.nls_session_parameters s2 \n                  where   s2.parameter = d.parameter) \nand   d.parameter != 'NLS_CHARACTERSET'");
        map.put("DB_TIMEZONE", "select /*OracleDictionaryQueries.DB_TIMEZONE_QUERY*/\n       'DB_TIMEZONE' parameter,  DBTIMEZONE value \nfrom  sys.dual");
        map.put("SESSION_TIMEZONE", "select /*OracleDictionaryQueries.SESSION_TIMEZONE_QUERY*/\n       'SESSION_TIMEZONE' parameter,  SESSIONTIMEZONE value \nfrom  sys.dual");
        map.put("SESSION_TIMEZONE_OFFSET", "select /*OracleDictionaryQueries.SESSION_TIMEZONE_OFFSET_QUERY*/\n       'SESSION_TIMEZONE_OFFSET' parameter,  TZ_OFFSET(SESSIONTIMEZONE) value \nfrom  sys.dual");
    }

    public String getDefaultSchemaName(DatabaseLink databaseLink) {
        final Holder holder = new Holder();
        if (databaseLink != null) {
            String string = "select /*OracleDictionaryQueries.DEFAULT_DBLINK_SCHEMA_QUERY*/\n       sys.dbms_utility.old_current_schema@<LINK> \nfrom   sys.dual".replace("<LINK>", databaseLink.getName());
            QueryWrapper queryWrapper = new QueryWrapper((Database)this, string);
            try {
                queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                holder.set((Object)resultSet.getString(1));
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return (String)holder.get();
    }

    public boolean supportsDatabaseChangeNotification() {
        return false;
    }

    public boolean isDatabaseChangeNotificationCompatible(String string, boolean bl, boolean bl2) throws DBException {
        throw new DBException((Throwable)new UnsupportedOperationException());
    }

    private static class SessionParameterQueryMap
    extends HashMap<String, String> {
        private final Map<String, String> m_cache;
        private final BaseOracleDatabase m_db;
        private String m_query;

        SessionParameterQueryMap(BaseOracleDatabase baseOracleDatabase) {
            this.m_db = baseOracleDatabase;
            this.m_cache = new HashMap<String, String>();
            this.m_query = null;
        }

        String getValue(String string) {
            if (this.m_query == null && this.size() > 0) {
                Object object2;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = true;
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(this.keySet());
                Collections.sort(arrayList);
                for (Object object2 : arrayList) {
                    String string2 = (String)this.get(object2);
                    if (string2 == null || string2.length() <= 0) continue;
                    if (!bl) {
                        stringBuilder.append("\nunion all\n");
                    }
                    stringBuilder.append(string2);
                    bl = false;
                }
                this.m_query = stringBuilder.toString();
                final QueryWrapper queryWrapper = new QueryWrapper((Database)this.m_db, this.m_query);
                object2 = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            while (resultSet.next()) {
                                m_cache.put(resultSet.getString(1), resultSet.getString(2));
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(sQLException);
                        }
                    }
                };
                try {
                    queryWrapper.executeQuery((QueryWrapper.QueryRunnable)object2);
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(APIBundle.format((String)"NLS_PARAM_LOAD_ERR", (Object[])new Object[]{this.m_db.getConnectionName(), dBException.getMessage()}));
                }
            }
            return this.m_cache.get(string);
        }

        void setValue(String string, String string2) throws DBException {
            try {
                this.setValueImpl(string, string2, false);
            }
            catch (DBException dBException) {
                if (string2.startsWith("'")) {
                    throw dBException;
                }
                this.setValueImpl(string, string2, true);
            }
            this.markAsDirty();
        }

        void setValueImpl(String string, String string2, boolean bl) throws DBException {
            StringBuilder stringBuilder = new StringBuilder("ALTER SESSION SET ");
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            if (bl) {
                stringBuilder.append("'");
            }
            stringBuilder.append(string2);
            if (bl) {
                stringBuilder.append("'");
            }
            StatementWrapper statementWrapper = new StatementWrapper((Database)this.m_db, new String[]{stringBuilder.toString()});
            statementWrapper.execute();
        }

        void markAsDirty() {
            this.m_query = null;
            this.m_cache.clear();
        }

        @Override
        public void clear() {
            this.markAsDirty();
            super.clear();
        }

        @Override
        public String put(String string, String string2) {
            this.markAsDirty();
            return super.put(string, string2);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map) {
            this.markAsDirty();
            super.putAll(map);
        }

        @Override
        public String remove(Object object) {
            this.markAsDirty();
            return (String)super.remove(object);
        }
    }
}

