/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.View;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcRelationBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class JdbcViewBuilder
extends JdbcRelationBuilder<View> {
    protected static final String DEFAULT_SEARCH_STRING = "CREATE VIEW <name ?.> [(<cols {^)}...>)] AS <select {^{WITH CHECK OPTION|WITH READ ONLY}}...> <check [WITH CHECK OPTION]> <readOnly [WITH READ ONLY]>";
    private TokenPattern m_viewSearch;

    public JdbcViewBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string, "VIEW");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery", "restriction"})
    public void buildQuery(final View view) throws DBException {
        String string = this.getDictionaryQuery();
        if (string == null) {
            this.getLogger().warning(APIBundle.format((String)"VIEW_BUILD_SQL_ERR", (Object[])new Object[]{view.getName()}));
        } else {
            final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), string, this.getDictionaryQueryParams(view));
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            String string = resultSet.getString(1);
                            JdbcViewBuilder.this.decodeQueryString(string, view);
                            if (resultSet.getMetaData().getColumnCount() > 1) {
                                String string2 = resultSet.getString(2);
                                View.Restriction restriction = JdbcViewBuilder.this.decodeRestriction(string2);
                                view.setRestriction(restriction);
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            });
        }
    }

    public boolean canBuildEditableObject() {
        return this.getDictionaryQuery() != null;
    }

    protected String getDictionaryQuery() {
        return null;
    }

    protected Object[] getDictionaryQueryParams(View view) {
        return new Object[]{view.getSchema(), view};
    }

    @Deprecated
    protected SQLQuery decodeQueryString(String string) {
        return null;
    }

    protected void decodeQueryString(String string, View view) {
        SQLQuery sQLQuery;
        String string2 = this.getQuerySearchString();
        if (string2 != null) {
            if (this.m_viewSearch == null) {
                this.m_viewSearch = new TokenPattern(string2);
            }
            if ((sQLQuery = this.m_viewSearch.getResult(string)) != null) {
                Token token;
                Token token2 = sQLQuery.getNamedMatchStartToken("select");
                Token token3 = sQLQuery.getNamedMatchEndToken("select");
                string = token2.getSource(false, token3);
                Token token4 = sQLQuery.getNamedMatchStartToken("check");
                if (token4 != null) {
                    view.setRestriction(View.Restriction.CHECK_OPTION);
                }
                if ((token = sQLQuery.getNamedMatchStartToken("readOnly")) != null) {
                    view.setRestriction(View.Restriction.READ_ONLY);
                }
            }
        }
        sQLQuery = (SQLQuery)this.newObject(SQLQuery.class, null);
        sQLQuery.setQueryString(string);
        view.setSQLQuery(sQLQuery);
    }

    protected String getQuerySearchString() {
        return null;
    }

    protected View.Restriction decodeRestriction(String string) {
        return null;
    }
}

