/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.derby.DerbyDDLGenerator;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class DerbyDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "LIKE", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NVARCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "ROW_NUMBER", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "YEAR"));

    public DerbyDatabaseDescriptor(Class<? extends DerbyDatabase> clazz) {
        super(clazz);
    }

    @Override
    public int getCasePolicy() {
        return 2;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 128;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        DerbyDatabaseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)128, (String)"_", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("SYNONYM", (DBObjectValidator)new SynonymValidator(dBObjectProvider));
        return map;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new DerbyDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public String getDatabaseType() {
        return "Derby";
    }

    @Override
    public int getDatabaseVersion() {
        return 1;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        dataTypeCache.registerDataType("BIGINT");
        dataTypeCache.registerDataType("BLOB");
        dataTypeCache.registerDataType("CHAR FOR BIT DATA");
        dataTypeCache.registerDataType("CHAR");
        dataTypeCache.registerDataType("CLOB");
        dataTypeCache.registerDataType("DATE");
        dataTypeCache.registerDataType("DECIMAL");
        dataTypeCache.registerDataType("DOUBLE");
        dataTypeCache.registerDataType("FLOAT");
        dataTypeCache.registerDataType("INTEGER");
        dataTypeCache.registerDataType("LONG VARCHAR FOR BIT DATA");
        dataTypeCache.registerDataType("LONG VARCHAR");
        dataTypeCache.registerDataType("REAL");
        dataTypeCache.registerDataType("SMALLINT");
        dataTypeCache.registerDataType("TIME");
        dataTypeCache.registerDataType("TIMESTAMP");
        dataTypeCache.registerDataType("VARCHAR FOR BIT DATA");
        dataTypeCache.registerDataType("VARCHAR");
        dataTypeCache.registerDataType("XML");
        dataTypeCache.registerDataTypeSynonym("BINARY LARGE OBJECT", "BLOB");
        dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR");
        dataTypeCache.registerDataTypeSynonym("CHAR VARYING FOR BIT DATA", "VARCHAR FOR BIT DATA");
        dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
        dataTypeCache.registerDataTypeSynonym("CHARACTER FOR BIT DATA", "CHAR FOR BIT DATA");
        dataTypeCache.registerDataTypeSynonym("CHARACTER LARGE OBJECT", "CLOB");
        dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
        dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING FOR BIT DATA", "VARCHAR FOR BIT DATA");
        dataTypeCache.registerDataTypeSynonym("DEC", "DECIMAL");
        dataTypeCache.registerDataTypeSynonym("DOUBLE PRECISION", "DOUBLE");
        dataTypeCache.registerDataTypeSynonym("INT", "INTEGER");
        dataTypeCache.registerDataTypeSynonym("NUMERIC", "DECIMAL");
    }
}

