/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

@Deprecated
public class ComplexType
extends SpecPlSql
implements DataType {
    public static final String TYPE = "TYPE";
    public static final String OBJECT_TYPECODE = "OBJECT";
    public static final String COLLECTION_TYPECODE = "COLLECTION";
    public static final String BODY_TYPE = "TYPE BODY";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VARRAY_TYPE = "VARYING ARRAY";
    private String m_typeCode = "OBJECT";
    private String m_collType = "";
    private boolean m_final = true;
    private boolean m_instantiable = true;
    private DataTypeUsage m_ofTypeUsage;
    private DBObjectID m_underTypeID;
    private boolean m_authidCurrentUser;
    private Integer m_limit;
    private String m_OID;
    private String m_sqljExtenalName;
    private SQLJUsingType m_sqljUsing;
    private boolean m_madeDeclarative = false;
    private final DataTypeAttribute[] m_dataTypeAttributes = new DataTypeAttribute[0];
    private ArrayList<String> m_declaratorErrors = new ArrayList();

    public ComplexType() {
    }

    public ComplexType(String string, Schema schema) {
        super(string, schema);
    }

    public String getType() {
        return TYPE;
    }

    public Integer getSQLType() {
        return null;
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        ComplexType complexType = (ComplexType)abstractDBObject;
        super.copyToImpl((AbstractDBObject)complexType, dBObject, iDPolicy);
        complexType.m_typeCode = this.m_typeCode;
        complexType.m_collType = this.m_collType;
        complexType.m_final = this.m_final;
        complexType.m_instantiable = this.m_instantiable;
        complexType.m_authidCurrentUser = this.m_authidCurrentUser;
        complexType.m_limit = this.m_limit;
        complexType.m_ofTypeUsage = (DataTypeUsage)this.copyObject(this.m_ofTypeUsage, (DBObject)complexType, iDPolicy);
        complexType.m_underTypeID = this.m_underTypeID;
        complexType.m_OID = this.m_OID;
        complexType.m_sqljExtenalName = this.m_sqljExtenalName;
        complexType.m_sqljUsing = this.m_sqljUsing;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        ComplexType complexType = (ComplexType)abstractDBObject;
        return super.equalsImpl((AbstractDBObject)complexType) && ModelUtil.areEqual((Object)this.m_typeCode, (Object)complexType.m_typeCode) && ModelUtil.areEqual((Object)this.m_collType, (Object)complexType.m_collType) && ModelUtil.areEqual((Object)this.m_ofTypeUsage, (Object)complexType.m_ofTypeUsage) && ModelUtil.areEqual((Object)this.m_underTypeID, (Object)complexType.m_underTypeID) && ModelUtil.areEqual((Object)this.m_limit, (Object)complexType.m_limit) && ModelUtil.areEqual((Object)this.m_OID, (Object)complexType.m_OID) && ModelUtil.areEqual((Object)this.m_sqljExtenalName, (Object)complexType.m_sqljExtenalName) && ModelUtil.areEqual((Object)((Object)this.m_sqljUsing), (Object)((Object)complexType.m_sqljUsing)) && this.m_final == complexType.m_final && this.m_instantiable == complexType.m_instantiable && this.m_authidCurrentUser == complexType.m_authidCurrentUser;
    }

    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        this.includeOwnedObject(collection, (DBObject)this.m_ofTypeUsage, stringArray);
    }

    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        if (this.m_underTypeID != null) {
            collection.add(this.m_underTypeID);
        }
    }

    public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> map) {
        boolean bl = super.replaceReferenceIDs(map);
        if (map.containsKey(this.m_underTypeID)) {
            this.m_underTypeID = map.get(this.m_underTypeID);
            bl = true;
        }
        return bl;
    }

    public boolean isFinal() {
        this.checkInit();
        return this.m_final;
    }

    public void setFinal(boolean bl) {
        this.checkInit();
        this.m_final = bl;
    }

    public boolean isInstantiable() {
        this.checkInit();
        return this.m_instantiable;
    }

    public void setInstantiable(boolean bl) {
        this.checkInit();
        this.m_instantiable = bl;
    }

    public String getTypeCode() {
        this.checkInit();
        return this.m_typeCode;
    }

    public void setTypeCode(String string) {
        if (string == null || string.equals("")) {
            this.m_typeCode = string;
            this.getChildSupport("dataTypeAttributes").clearChildren();
        } else if (OBJECT_TYPECODE.equals(string) || COLLECTION_TYPECODE.equals(string) || this.getSchema() != null && "SYS".equals(this.getSchema().getName()) && this.getName().equals(string)) {
            this.m_typeCode = string;
        } else {
            throw new IllegalArgumentException("ComplexType: Invalid typecode " + string);
        }
    }

    public String getCollectionType() {
        this.checkInit();
        return this.m_collType;
    }

    public void setCollectionType(String string) {
        if (string == null || string.equals("") || TABLE_TYPE.equals(string) || VARRAY_TYPE.equals(string)) {
            this.m_collType = string == null ? "" : string;
        } else if (string != null && !string.equals("")) {
            throw new IllegalArgumentException("ComplexType: Invalid collType " + string);
        }
    }

    public void setAuthidCurrentUser(boolean bl) {
        this.checkInit();
        this.m_authidCurrentUser = bl;
    }

    public boolean isAuthidCurrentUser() {
        this.checkInit();
        return this.m_authidCurrentUser;
    }

    public void setLimit(Integer n) {
        this.m_limit = n;
    }

    public Integer getLimit() {
        this.checkInit();
        return this.m_limit;
    }

    public void setOfTypeUsage(DataTypeUsage dataTypeUsage) {
        this.checkInit();
        this.changeParent((ChildDBObject)this.m_ofTypeUsage, (ChildDBObject)dataTypeUsage);
        this.m_ofTypeUsage = dataTypeUsage;
    }

    public DataTypeUsage getOfTypeUsage() {
        this.checkInit();
        return this.m_ofTypeUsage;
    }

    public void setUnderTypeID(DBObjectID dBObjectID) {
        this.checkInit();
        this.m_underTypeID = dBObjectID;
    }

    public DBObjectID getUnderTypeID() {
        this.checkInit();
        return this.m_underTypeID;
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (dataTypeUsage.hasAttributeValue("ref")) {
            stringBuffer.append("REF ");
        }
        DBObjectProvider dBObjectProvider = this.getID() instanceof BaseObjectID ? ((BaseObjectID)this.getID()).getProvider() : null;
        Schema schema = this.getSchema();
        if (schema != null && ModelUtil.hasLength((String)(string = schema.getName()))) {
            if (dBObjectProvider != null) {
                string = dBObjectProvider.getExternalName(string);
            }
            stringBuffer.append(string).append(".");
        }
        if ((string = this.getName()) != null && dBObjectProvider != null) {
            string = dBObjectProvider.getExternalName(string);
        }
        stringBuffer.append(string);
        Object object = dataTypeUsage.getAttributeValue("ref_scope");
        if (object instanceof BaseObjectID) {
            String string2;
            stringBuffer.append(" SCOPE IS ");
            String string3 = ((BaseObjectID)object).getSchemaName();
            if (ModelUtil.hasLength((String)string3)) {
                if (dBObjectProvider != null) {
                    string3 = dBObjectProvider.getExternalName(string3);
                }
                stringBuffer.append(string3).append(".");
            }
            if ((string2 = ((BaseObjectID)object).getName()) != null && dBObjectProvider != null) {
                string2 = dBObjectProvider.getExternalName(string2);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public DataTypeAttribute[] getDataTypeAttributes() {
        return this.m_dataTypeAttributes;
    }

    public boolean hasDataTypeAttribute(String string) {
        return false;
    }

    public DataTypeAttribute getDataTypeAttribute(String string) {
        return null;
    }

    public DataTypeUsage createDefaultUsage() {
        return new ObjectTypeUsage(this);
    }

    public DataTypeUsage createUsage(Map<String, Object> map) {
        return new ObjectTypeUsage(this);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
    }

    public void setOID(String string) {
        this.checkInit();
        this.m_OID = string;
    }

    public String getOID() {
        this.checkInit();
        return this.m_OID;
    }

    public void setSqljExternalName(String string) {
        this.checkInit();
        this.m_sqljExtenalName = string;
    }

    public String getSqljExternalName() {
        this.checkInit();
        return this.m_sqljExtenalName;
    }

    public void setSqljUsing(SQLJUsingType sQLJUsingType) {
        this.checkInit();
        this.m_sqljUsing = sQLJUsingType;
    }

    public SQLJUsingType getSqljUsing() {
        this.checkInit();
        return this.m_sqljUsing;
    }

    @Transient
    public final void setMadeDeclarative(boolean bl) {
        this.m_madeDeclarative = bl;
    }

    @Transient
    public final boolean isMadeDeclarative() {
        return this.m_madeDeclarative;
    }

    @Override
    public void setSource(String string) {
        super.setSource(string);
        this.m_madeDeclarative = false;
        this.m_declaratorErrors = new ArrayList();
    }

    public boolean matches(String string) {
        StringBuffer stringBuffer = new StringBuffer("[? .] {");
        stringBuffer.append("\"").append(this.getName()).append("\" |");
        stringBuffer.append(this.getName().toUpperCase()).append("}");
        PlSqlSearch plSqlSearch = null;
        try {
            plSqlSearch = new PlSqlSearch(stringBuffer.toString());
            return plSqlSearch.matches(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public DataTypeUsage createUsage(String string) {
        return new ObjectTypeUsage(this);
    }

    @Transient
    public void addDeclaratorError(String string) {
        this.m_declaratorErrors.add(string);
    }

    @Transient
    public List<String> getDeclaratorErrors() {
        return this.m_declaratorErrors;
    }

    public static enum SQLJUsingType {
        SQLData,
        CustomDatum,
        OraData;

    }
}

