/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceEfficientStackCache {
    private static final Logger logger = Logger.getLogger(SpaceEfficientStackCache.class.getName());
    private static final String EMPTY_STACK = "EMPTY STACK";
    private final int highWaterMark;
    private final Object pseudoMapValue = new Object();
    private final LinkedHashMap<String, Object> cacheMap = new LinkedHashMap<String, Object>(4, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            return this.size() > SpaceEfficientStackCache.this.highWaterMark;
        }
    };
    private boolean md5Reported = false;

    public SpaceEfficientStackCache() {
        this(50);
    }

    public SpaceEfficientStackCache(int hwm) {
        this.highWaterMark = hwm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldReport(StackTraceElement[] elements) {
        String digestStr = elements != null && elements.length > 0 ? this.getDigestString(elements) : EMPTY_STACK;
        LinkedHashMap<String, Object> linkedHashMap = this.cacheMap;
        synchronized (linkedHashMap) {
            return this.cacheMap.put(digestStr, this.pseudoMapValue) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldReport(Throwable t) {
        String digestStr = t != null ? this.getDigestString(t.getStackTrace()) : EMPTY_STACK;
        LinkedHashMap<String, Object> linkedHashMap = this.cacheMap;
        synchronized (linkedHashMap) {
            return this.cacheMap.put(digestStr, this.pseudoMapValue) == null;
        }
    }

    private String getDigestString(StackTraceElement[] elements) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(this.getStackBytes(elements));
            return this.stringify(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            if (!this.md5Reported && logger.isLoggable(Level.WARNING)) {
                this.md5Reported = true;
                logger.log(Level.WARNING, "", e);
            }
            return "BAD MD5";
        }
    }

    private byte[] getStackBytes(StackTraceElement[] elements) {
        StringBuilder buf = new StringBuilder(elements.length * 80);
        for (StackTraceElement elem : elements) {
            buf.append(elem.getClassName());
            buf.append(elem.getLineNumber());
        }
        return buf.toString().getBytes();
    }

    private String stringify(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2 + 4);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedHashMap<String, Object> linkedHashMap = this.cacheMap;
        synchronized (linkedHashMap) {
            return this.cacheMap.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashMap<String, Object> linkedHashMap = this.cacheMap;
        synchronized (linkedHashMap) {
            this.cacheMap.clear();
        }
    }
}

