/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.platform.mt.jrf;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.platform.mt.Tenant;

public final class JRFTenant
extends Tenant {
    private static final Logger logger = Logger.getLogger(JRFTenant.class.getName());
    private final String tenantName;
    private final String tenantId;
    private final UUID tenantUUID;
    private final boolean isGlobal;

    JRFTenant(String tenantName, UUID tenantUUID, boolean isGlobal) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Name=" + tenantName + ", UUID=" + tenantUUID);
        }
        this.tenantName = tenantName;
        this.tenantId = null;
        this.tenantUUID = tenantUUID;
        if (tenantUUID == null) {
            throw new IllegalArgumentException("tenantUUID");
        }
        this.isGlobal = isGlobal;
    }

    @Override
    public final String getTenantName() {
        return this.tenantName;
    }

    @Override
    public final UUID getTenantUUID() {
        return this.tenantUUID;
    }

    @Override
    @Deprecated
    public final String getTenantId() {
        return this.tenantUUID != null ? this.tenantUUID.toString() : this.tenantId;
    }

    @Override
    public final boolean isGlobal() {
        return this.isGlobal;
    }
}

