/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.rest.filter;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.rest.filter.RestHttpRequestWrapper;

public abstract class AbstractRestFilter
implements Filter {
    private FilterConfig _filterConfig;
    private static final ADFLogger LOG = ADFLogger.createADFLogger(AbstractRestFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String pathInfo = request.getPathInfo();
        String metadataContextValue = this.processMetadataContextHeader(pathInfo);
        Locale locale = this.getLocale(request, pathInfo);
        String pathPostMetadataContextProcessing = this.getPath(pathInfo);
        if (LOG.isFinest()) {
            LOG.finest(MessageFormat.format("AbstractRestFilter :: pathInfo={0} metadataContextValue={1} locale={2} pathPostMetadataContextProcessing={3} ", pathInfo, metadataContextValue, locale, pathPostMetadataContextProcessing));
        }
        request.setAttribute("__IS_PREFILTER_CONFIGURED__", (Object)"TRUE");
        RestHttpRequestWrapper requestWrapper = new RestHttpRequestWrapper(request);
        requestWrapper.setMetadataContextValue(metadataContextValue);
        requestWrapper.setLocaleValue(locale);
        requestWrapper.setPathPostMetadataContextProcessing(pathPostMetadataContextProcessing);
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)response);
    }

    public abstract String processMetadataContextHeader(String var1);

    public Locale getLocale(HttpServletRequest request, String path) {
        return null;
    }

    public String getPath(String pathInfo) {
        return null;
    }

    public void destroy() {
        this._filterConfig = null;
    }
}

