/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import java.text.DecimalFormat;

abstract class SensorResult {
    String mRID = null;
    long mTimeStamp = 0L;
    long mElapseTime = 0L;
    int mNameIndex = 0;
    String mValue = null;
    int mHit = 0;
    double mRunningTotal = 0.0;
    long mGap = 0L;
    static DecimalFormat sDblFmt = new DecimalFormat("#,##0.00");
    static DecimalFormat sIntFmt = new DecimalFormat("###,##0");

    SensorResult() {
    }

    abstract void print(PrintStream var1, boolean var2, String var3);

    void setValue(String value) {
        ++this.mHit;
        this.mValue = value;
    }

    String getValue() {
        return this.mValue;
    }

    void setGap(SensorResult prev, boolean isChild) {
        this.mGap = this.mTimeStamp - prev.mTimeStamp;
        if (!isChild) {
            this.mGap -= prev.mElapseTime;
        }
    }

    void aggregate(SensorResult result) {
        this.mTimeStamp += result.mTimeStamp;
        this.setValue(result.mValue);
    }

    static String prependSpace(String str, int bufSize) {
        int size = str.length();
        if (bufSize <= size) {
            return str;
        }
        StringBuffer buf = new StringBuffer(size);
        for (int i = 0; i < bufSize - size; ++i) {
            buf.append('_');
        }
        buf.replace(bufSize - size, bufSize, str);
        return buf.toString();
    }
}

