/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.ADFLoggerExtension;

public class TraceSpanContext {
    private final long beginMillis;
    private final ADFLogger inst;
    private final Level level;
    private final LogRecord rec;
    private final Map<String, String> cntx;
    private final int stackSize;
    final Throwable created;
    private Object[] beginCurrents = null;
    private int hash = 0;
    private String equalsKey = null;
    private Map<String, String> cntxUpdates = Collections.EMPTY_MAP;
    private long duration = -1L;

    public TraceSpanContext(ADFLogger inst, Level level, LogRecord rec, Map<String, String> cntx, int stackSize) {
        this.beginMillis = System.currentTimeMillis();
        this.inst = inst;
        this.level = level;
        this.rec = rec;
        this.cntx = cntx;
        this.stackSize = stackSize;
        this.created = new Throwable();
    }

    public ADFLogger getADFLogger() {
        return this.inst;
    }

    public Level getLevel() {
        return this.level;
    }

    public LogRecord getLogRecord() {
        return this.rec;
    }

    public Map<String, String> getLoggingContext() {
        return this.cntx;
    }

    public Map<String, String> getLoggingContextUpdates() {
        return this.cntxUpdates;
    }

    public long recordDuration() {
        this.duration = this.beginMillis != -1L ? System.currentTimeMillis() - this.beginMillis : 0L;
        return this.duration;
    }

    public TraceSpanContext(ADFLogger inst, String actionName) {
        this.beginMillis = -1L;
        this.inst = inst;
        this.level = null;
        this.rec = null;
        this.cntx = new HashMap<String, String>(1);
        this.cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        this.stackSize = -1;
        this.created = null;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public String getActionName() {
        return this.cntx.get("ADF_MESSAGE_ACTION_NAME");
    }

    public void setBeginCurrents(Object[] beginCurrents) {
        this.beginCurrents = beginCurrents;
    }

    public Object[] getBeginCurrents() {
        return this.beginCurrents;
    }

    public void updateCntxItem(String key, String value) {
        this.cntx.put(key, value);
    }

    public void updateCntxItems(Map<String, String> updates, StackTraceElement[] elems, int ix) {
        if (this.cntxUpdates == Collections.EMPTY_MAP) {
            this.cntxUpdates = new HashMap<String, String>();
        }
        this.cntxUpdates.putAll(updates);
        this.cntxUpdates.put("ADF_MESSAGE_THROWABLE", ADFLoggerExtension.abbreviatedStackTrace(elems, ix, ADFLoggerExtension.DFLT_FILTER).replace("\n  ", " | "));
    }

    public void updateCntxItems(Map<String, String> updates, Throwable t) {
        if (this.cntxUpdates == Collections.EMPTY_MAP) {
            this.cntxUpdates = new HashMap<String, String>();
        }
        this.cntxUpdates.putAll(updates);
        if (t != null) {
            this.cntxUpdates.put("ADF_MESSAGE_THROWABLE", ADFLoggerExtension.abbreviatedStackTrace(t.getStackTrace(), this.inst.getClass().getName()).replace("\n  ", " | "));
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.getEqualsKey().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getEqualsKey().equals(((TraceSpanContext)obj).getEqualsKey());
    }

    private String getEqualsKey() {
        if (this.equalsKey == null) {
            this.equalsKey = TraceSpanContext.createEqualsKey(this.getActionName(), this.inst);
        }
        return this.equalsKey;
    }

    public static String createEqualsKey(String actionName, ADFLogger inst) {
        return actionName + ":" + inst.getName();
    }

    public String toString() {
        String updateStr = this.cntxUpdates == Collections.EMPTY_MAP ? "" : "\n  cntxUpdates=" + new TreeMap<String, String>(this.cntxUpdates);
        String begStr = this.beginCurrents != null ? String.valueOf(this.beginCurrents[0]) : "null";
        return this.getClass().getName() + " begin=" + begStr + "\n  logger=" + this.inst.getClass().getName() + "\n  record=" + this.rec.getClass().getName() + "\n  cntx=" + new TreeMap<String, String>(this.cntx) + updateStr + "\n  stackSize=" + this.stackSize;
    }
}

